/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceType;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.android.util.HintBasedErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AndroidInlineStyleHandler
extends InlineActionHandler {
    private static AndroidInlineTestConfig ourTestConfig;

    @TestOnly
    public static void setTestConfig(@Nullable AndroidInlineTestConfig testConfig) {
        ourTestConfig = testConfig;
    }

    public boolean isEnabledForLanguage(Language l) {
        return l == XMLLanguage.INSTANCE;
    }

    public boolean canInlineElement(PsiElement element) {
        if (element instanceof ResourceReferencePsiElement) {
            return ((ResourceReferencePsiElement)element).getResourceReference().getResourceType().equals((Object)ResourceType.STYLE);
        }
        return element != null && AndroidFacet.getInstance((PsiElement)element) != null && AndroidInlineUtil.getInlinableStyleDataFromContext(element) != null;
    }

    public void inlineElement(Project project, Editor editor2, PsiElement element) {
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor2);
        if (psiReference == null) {
            return;
        }
        PsiElement destination = element instanceof LazyValueResourceElementWrapper ? element : psiReference.getElement();
        AndroidInlineUtil.MyStyleData data = AndroidInlineUtil.getInlinableStyleDataFromContext(destination);
        if (data != null) {
            HintBasedErrorReporter reporter = new HintBasedErrorReporter(editor2);
            StyleUsageData usageData = AndroidInlineStyleHandler.getUsageDataFromEditor(psiReference);
            AndroidInlineUtil.doInlineStyleDeclaration(project, data, usageData, reporter, ourTestConfig);
        }
    }

    @Nullable
    private static StyleUsageData getUsageDataFromEditor(@NotNull PsiReference reference2) {
        PsiElement usageElement;
        XmlTag tag;
        if (reference2 == null) {
            AndroidInlineStyleHandler.$$$reportNull$$$0(0);
        }
        return (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(usageElement = reference2.getElement()), XmlTag.class, (boolean)false)) != null ? AndroidInlineUtil.getStyleUsageData(tag) : null;
    }

    @Nullable
    public String getActionName(PsiElement element) {
        return "Inline Android Style";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/android/refactoring/AndroidInlineStyleHandler", "getUsageDataFromEditor"));
    }
}

