/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.AndroidRefactoringErrorException;
import org.jetbrains.android.refactoring.LayoutUsageData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInlineLayoutProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.refactoring.AndroidInlineLayoutProcessor");
    private final XmlFile myLayoutFile;
    private final XmlTag myLayoutRootTag;
    private final PsiElement myUsageElement;
    private final AndroidInlineTestConfig myTestConfig;

    protected AndroidInlineLayoutProcessor(@NotNull Project project, @NotNull XmlFile file, @NotNull XmlTag rootTag, @Nullable PsiElement usageElement, @Nullable AndroidInlineTestConfig config) {
        if (project == null) {
            AndroidInlineLayoutProcessor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            AndroidInlineLayoutProcessor.$$$reportNull$$$0(1);
        }
        if (rootTag == null) {
            AndroidInlineLayoutProcessor.$$$reportNull$$$0(2);
        }
        super(project);
        this.myLayoutFile = file;
        this.myLayoutRootTag = rootTag;
        this.myUsageElement = usageElement;
        this.myTestConfig = config;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            AndroidInlineLayoutProcessor.$$$reportNull$$$0(3);
        }
        return new UsageViewDescriptor(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{AndroidInlineLayoutProcessor.this.myLayoutFile};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "References to be inlined" + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            public String getProcessedElementsHeader() {
                return "Layout file to inline";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/refactoring/AndroidInlineLayoutProcessor$1", "getElements"));
            }
        };
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (this.myUsageElement != null) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo(this.myUsageElement)};
            if (usageInfoArray == null) {
                AndroidInlineLayoutProcessor.$$$reportNull$$$0(4);
            }
            return usageInfoArray;
        }
        HashSet<UsageInfo> usages = new HashSet<UsageInfo>();
        AndroidInlineUtil.addReferences((PsiElement)this.myLayoutFile, usages);
        for (PsiField field2 : AndroidResourceUtil.findResourceFieldsForFileResource((PsiFile)this.myLayoutFile, false)) {
            AndroidInlineUtil.addReferences((PsiElement)field2, usages);
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            AndroidInlineLayoutProcessor.$$$reportNull$$$0(5);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            AndroidInlineLayoutProcessor.$$$reportNull$$$0(6);
        }
        ArrayList<LayoutUsageData> inlineInfos = new ArrayList<LayoutUsageData>();
        for (UsageInfo usage : usages) {
            LayoutUsageData usageData;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            LayoutUsageData layoutUsageData = usageData = tag != null ? AndroidInlineUtil.getLayoutUsageData(tag) : null;
            if (usageData == null || usageData.getReference().computeTargetElements().length != 1) continue;
            inlineInfos.add(usageData);
        }
        for (LayoutUsageData info : inlineInfos) {
            try {
                info.inline(this.myLayoutRootTag);
            }
            catch (AndroidRefactoringErrorException e) {
                LOG.info((Throwable)e);
                String message2 = e.getMessage();
                if (message2 == null) {
                    message2 = "Refactoring was performed with errors";
                }
                AndroidUtils.reportError(this.myProject, message2, AndroidBundle.message("android.inline.style.title", new Object[0]));
                return;
            }
        }
        if (this.myUsageElement == null) {
            try {
                this.myLayoutFile.delete();
            }
            catch (IncorrectOperationException e) {
                Throwable c = e.getCause();
                if (c instanceof IOException && c.getMessage() != null) {
                    AndroidUtils.reportError(this.myProject, c.getMessage(), AndroidBundle.message("android.inline.style.title", new Object[0]));
                    return;
                }
                throw e;
            }
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            AndroidInlineLayoutProcessor.$$$reportNull$$$0(7);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap<PsiElement, String> conflicts = AndroidInlineLayoutProcessor.detectConflicts(usages);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myTestConfig.setConflicts(conflicts);
            return true;
        }
        return this.showConflicts(conflicts, usages);
    }

    private static MultiMap<PsiElement, String> detectConflicts(UsageInfo[] usages) {
        ArrayList<PsiElement> nonXmlUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> unsupportedUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> unambiguousUsages = new ArrayList<PsiElement>();
        for (UsageInfo usage : usages) {
            LayoutUsageData usageData;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            if (element.getLanguage() != XMLLanguage.INSTANCE) {
                nonXmlUsages.add(element);
                continue;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            LayoutUsageData layoutUsageData = usageData = tag != null ? AndroidInlineUtil.getLayoutUsageData(tag) : null;
            if (usageData == null) {
                unsupportedUsages.add(element);
                continue;
            }
            if (usageData.getReference().computeTargetElements().length <= 1) continue;
            unambiguousUsages.add(element);
        }
        return AndroidInlineUtil.buildConflicts(nonXmlUsages, unambiguousUsages, unsupportedUsages, Collections.emptyList());
    }

    @NotNull
    protected String getCommandName() {
        String string = AndroidBundle.message("android.inline.layout.command.name", this.myLayoutFile.getName());
        if (string == null) {
            AndroidInlineLayoutProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = UndoConfirmationPolicy.REQUEST_CONFIRMATION;
        if (undoConfirmationPolicy == null) {
            AndroidInlineLayoutProcessor.$$$reportNull$$$0(9);
        }
        return undoConfirmationPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/refactoring/AndroidInlineLayoutProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/refactoring/AndroidInlineLayoutProcessor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoConfirmationPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

