/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.refactoring.AndroidBaseXmlRefactoringAction;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.LayoutUsageData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class AndroidInlineIncludeAction
extends AndroidBaseXmlRefactoringAction {
    private final AndroidInlineTestConfig myTestConfig;
    public static final String ACTION_ID = "AndroidInlineIncludeAction";

    public AndroidInlineIncludeAction() {
        this.myTestConfig = null;
    }

    @TestOnly
    public AndroidInlineIncludeAction(AndroidInlineTestConfig testConfig) {
        this.myTestConfig = testConfig;
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags2) {
        if (project == null) {
            AndroidInlineIncludeAction.$$$reportNull$$$0(0);
        }
        if (tags2 == null) {
            AndroidInlineIncludeAction.$$$reportNull$$$0(1);
        }
        assert (tags2.length == 1);
        XmlTag tag = tags2[0];
        PsiFile file = tag.getContainingFile();
        if (file == null) {
            return;
        }
        LayoutUsageData usageData = AndroidInlineUtil.getLayoutUsageData(tag);
        if (usageData == null) {
            return;
        }
        AndroidResourceReferenceBase reference2 = usageData.getReference();
        String title = AndroidBundle.message("android.inline.layout.title", new Object[0]);
        PsiElement[] resolvedElements = reference2.computeTargetElements();
        if (resolvedElements.length == 0) {
            AndroidUtils.reportError(project, "Cannot find layout by reference '" + reference2.getValue() + "'", title);
            return;
        }
        if (resolvedElements.length > 1) {
            AndroidUtils.reportError(project, RefactoringBundle.getCannotRefactorMessage((String)"Unambiguous layout reference."), title);
            return;
        }
        PsiElement resolvedElement = resolvedElements[0];
        if (!(resolvedElement instanceof XmlFile)) {
            AndroidUtils.reportError(project, "Cannot find layout by reference '" + reference2.getValue() + "'", title);
            return;
        }
        AndroidInlineUtil.doInlineLayoutFile(project, (XmlFile)resolvedElement, usageData.getReference().getElement(), this.myTestConfig);
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags2) {
        if (tags2 == null) {
            AndroidInlineIncludeAction.$$$reportNull$$$0(2);
        }
        return tags2.length == 1 && AndroidInlineUtil.getLayoutUsageData(tags2[0]) != null;
    }

    @Override
    protected boolean isMyFile(PsiFile file) {
        return DomManager.getDomManager((Project)file.getProject()).getDomFileDescription((XmlFile)file) instanceof LayoutDomFileDescription;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/refactoring/AndroidInlineIncludeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doRefactorForTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForTags";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

