/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFrameworkDetector;
import org.jetbrains.android.importDependencies.ImportDependenciesUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importWizard.EclipseNatureImporter;

public class AndroidEclipseNatureImporter
extends EclipseNatureImporter {
    private static final Set<String> ADT_INTERNAL_LIBS = new HashSet<String>(Arrays.asList("com.android.ide.eclipse.adt.ANDROID_FRAMEWORK", "com.android.ide.eclipse.adt.LIBRARIES"));

    @NotNull
    public String getNatureName() {
        return "com.android.ide.eclipse.adt.AndroidNature";
    }

    public Set<String> getProvidedCons() {
        return ADT_INTERNAL_LIBS;
    }

    public void doImport(@NotNull Project project, @NotNull List<Module> modules) {
        if (project == null) {
            AndroidEclipseNatureImporter.$$$reportNull$$$0(0);
        }
        if (modules == null) {
            AndroidEclipseNatureImporter.$$$reportNull$$$0(1);
        }
        for (Module module : modules) {
            VirtualFile contentRoot = AndroidEclipseNatureImporter.chooseMainContentRoot(module);
            if (contentRoot == null) {
                AndroidUtils.reportImportErrorToEventLog("Cannot find content root containing AndroidManifest.xml file", module.getName(), project);
                continue;
            }
            AndroidFacet facet2 = AndroidUtils.addAndroidFacetInWriteAction(module, contentRoot, false);
            final ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            AndroidFrameworkDetector.doImportSdkAndFacetConfiguration(facet2, modifiableModel);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    modifiableModel.commit();
                }
            });
        }
        ImportDependenciesUtil.doImportDependencies(project, modules, true);
    }

    @Nullable
    private static VirtualFile chooseMainContentRoot(@NotNull Module module) {
        VirtualFile[] roots;
        if (module == null) {
            AndroidEclipseNatureImporter.$$$reportNull$$$0(2);
        }
        if ((roots = ModuleRootManager.getInstance((Module)module).getContentRoots()).length == 0) {
            return null;
        }
        if (roots.length == 1) {
            return roots[0];
        }
        for (VirtualFile root2 : roots) {
            if (root2.findChild("AndroidManifest.xml") == null) continue;
            return root2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/newProject/AndroidEclipseNatureImporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doImport";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseMainContentRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

