/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.intentions.AbstractRegisterComponentAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddBroadcastReceiverToManifest
extends AbstractRegisterComponentAction {
    @Nls
    @NotNull
    public String getText() {
        return "Add broadcast receiver to manifest";
    }

    @Override
    boolean isAvailable(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        if (psiClass == null) {
            AddBroadcastReceiverToManifest.$$$reportNull$$$0(0);
        }
        if (manifest == null) {
            AddBroadcastReceiverToManifest.$$$reportNull$$$0(1);
        }
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)"android.content.BroadcastReceiver")) {
            return false;
        }
        return !AddBroadcastReceiverToManifest.isRegisteredBroadcastReceiver(psiClass, manifest.getApplication());
    }

    @Override
    void invoke(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        if (psiClass == null) {
            AddBroadcastReceiverToManifest.$$$reportNull$$$0(2);
        }
        if (manifest == null) {
            AddBroadcastReceiverToManifest.$$$reportNull$$$0(3);
        }
        Application application = manifest.getApplication();
        application.addReceiver().getReceiverClass().setValue(psiClass);
    }

    private static boolean isRegisteredBroadcastReceiver(PsiClass psiClass, Application application) {
        for (Receiver receiver : application.getReceivers()) {
            if (!psiClass.isEquivalentTo((PsiElement)receiver.getReceiverClass().getValue())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/intentions/AddBroadcastReceiverToManifest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

