/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MoveFileQuickFix
implements LocalQuickFix {
    @NotNull
    private final String myFolderName;
    @NotNull
    private final SmartPsiElementPointer<XmlFile> myFile;

    public MoveFileQuickFix(@NotNull String folderName, @NotNull XmlFile file) {
        if (folderName == null) {
            MoveFileQuickFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MoveFileQuickFix.$$$reportNull$$$0(1);
        }
        this.myFolderName = folderName;
        this.myFile = SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiElementPointer((PsiElement)file);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = String.format("Move file to \"%s\"", this.myFolderName);
        if (string == null) {
            MoveFileQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Move file";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        boolean removeFirst;
        PsiDirectory resultDirectory;
        XmlFile xmlFile;
        if (project == null) {
            MoveFileQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            MoveFileQuickFix.$$$reportNull$$$0(4);
        }
        if ((xmlFile = (XmlFile)this.myFile.getElement()) == null) {
            return;
        }
        PsiDirectory directory = xmlFile.getContainingDirectory();
        assert (directory != null);
        PsiDirectory parent = directory.getParent();
        assert (parent != null);
        PsiDirectory existingDirectory = parent.findSubdirectory(this.myFolderName);
        PsiDirectory psiDirectory = resultDirectory = existingDirectory == null ? parent.createSubdirectory(this.myFolderName) : existingDirectory;
        if (resultDirectory.findFile(xmlFile.getName()) != null) {
            String message2 = String.format("File %s already exists in directory %s. Overwrite it?", xmlFile.getName(), resultDirectory.getName());
            boolean bl = removeFirst = Messages.showOkCancelDialog((Project)project, (String)message2, (String)"Move Resource File", (Icon)Messages.getWarningIcon()) == 0;
            if (!removeFirst) {
                return;
            }
        } else {
            removeFirst = false;
        }
        new WriteCommandAction.Simple(project, new PsiFile[]{xmlFile}){

            protected void run() throws Throwable {
                PsiFile file;
                if (removeFirst && (file = resultDirectory.findFile(xmlFile.getName())) != null) {
                    file.delete();
                }
                MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)xmlFile, (PsiDirectory)resultDirectory);
            }
        }.execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/inspections/MoveFileQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/inspections/MoveFileQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

