/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.CustomFormattingModelBuilder;
import com.intellij.formatting.DelegatingFormattingModel;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XmlFormattingModelBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.android.dom.color.fileDescriptions.ColorStateListDomFileDescription;
import org.jetbrains.android.dom.drawable.fileDescriptions.DrawableStateListDomFileDescription;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.formatter.AndroidXmlCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlFormattingModelBuilder
implements CustomFormattingModelBuilder {
    private final XmlFormattingModelBuilder myXmlFormattingModelBuilder = new XmlFormattingModelBuilder();

    public boolean isEngagedToFormat(@NotNull PsiElement context) {
        PsiFile psiFile2;
        if (context == null) {
            AndroidXmlFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        if (!((psiFile2 = context.getContainingFile()) instanceof XmlFile) || AndroidFacet.getInstance((PsiElement)psiFile2) == null) {
            return false;
        }
        XmlFile xmlFile = (XmlFile)psiFile2;
        return new ColorStateListDomFileDescription().isMyFile(xmlFile, null) || new DrawableStateListDomFileDescription().isMyFile(xmlFile, null) || ManifestDomFileDescription.isManifestFile(xmlFile) || ResourceHelper.getFolderType((PsiFile)xmlFile) != null;
    }

    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        if (formattingContext == null) {
            AndroidXmlFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        FormattingModel baseModel = this.myXmlFormattingModelBuilder.createModel(formattingContext);
        CodeStyleSettings codeStyleSettings = formattingContext.getCodeStyleSettings();
        AndroidXmlCodeStyleSettings baseSettings = AndroidXmlCodeStyleSettings.getInstance(codeStyleSettings);
        if (!baseSettings.USE_CUSTOM_SETTINGS) {
            FormattingModel formattingModel = baseModel;
            if (formattingModel == null) {
                AndroidXmlFormattingModelBuilder.$$$reportNull$$$0(2);
            }
            return formattingModel;
        }
        AndroidXmlCodeStyleSettings.MySettings settings = AndroidXmlFormattingModelBuilder.getContextSpecificSettings(formattingContext.getPsiElement(), baseSettings);
        Object object = settings != null ? new DelegatingFormattingModel(baseModel, AndroidXmlFormattingModelBuilder.createDelegatingBlock(baseModel, settings, codeStyleSettings)) : baseModel;
        if (object == null) {
            AndroidXmlFormattingModelBuilder.$$$reportNull$$$0(3);
        }
        return object;
    }

    private static Block createDelegatingBlock(FormattingModel model2, AndroidXmlCodeStyleSettings.MySettings customSettings, CodeStyleSettings settings) {
        Block block = model2.getRootBlock();
        if (block instanceof XmlBlock) {
            XmlBlock b = (XmlBlock)block;
            XmlPolicy policy = customSettings.createXmlPolicy(settings, model2.getDocumentModel());
            return new XmlBlock(b.getNode(), b.getWrap(), b.getAlignment(), (XmlFormattingPolicy)policy, b.getIndent(), b.getTextRange()){

                protected XmlTagBlock createTagBlock(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
                    return new XmlTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent(), this.isPreserveSpace());
                }
            };
        }
        return block;
    }

    @Nullable
    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return this.myXmlFormattingModelBuilder.getRangeAffectingIndent(file, offset, elementAtOffset);
    }

    @Nullable
    private static AndroidXmlCodeStyleSettings.MySettings getContextSpecificSettings(@NotNull PsiElement context, @NotNull AndroidXmlCodeStyleSettings settings) {
        PsiFile psiFile2;
        if (context == null) {
            AndroidXmlFormattingModelBuilder.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            AndroidXmlFormattingModelBuilder.$$$reportNull$$$0(5);
        }
        if (!((psiFile2 = context.getContainingFile()) instanceof XmlFile) || AndroidFacet.getInstance((PsiElement)psiFile2) == null) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile2;
        if (new ColorStateListDomFileDescription().isMyFile(xmlFile, null) || new DrawableStateListDomFileDescription().isMyFile(xmlFile, null)) {
            return settings.VALUE_RESOURCE_FILE_SETTINGS;
        }
        if (ManifestDomFileDescription.isManifestFile(xmlFile)) {
            return settings.MANIFEST_SETTINGS;
        }
        ResourceFolderType type = ResourceHelper.getFolderType((PsiFile)xmlFile);
        if (type == null) {
            return null;
        }
        switch (type) {
            case ANIM: 
            case ANIMATOR: 
            case COLOR: 
            case DRAWABLE: 
            case FONT: 
            case INTERPOLATOR: {
                return settings.OTHER_SETTINGS;
            }
            case LAYOUT: {
                return settings.LAYOUT_SETTINGS;
            }
            case MENU: 
            case MIPMAP: 
            case NAVIGATION: 
            case RAW: 
            case TRANSITION: {
                return settings.OTHER_SETTINGS;
            }
            case VALUES: {
                return settings.VALUE_RESOURCE_FILE_SETTINGS;
            }
            case XML: {
                return settings.OTHER_SETTINGS;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/formatter/AndroidXmlFormattingModelBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/formatter/AndroidXmlFormattingModelBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEngagedToFormat";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContextSpecificSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

