/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.download;

import com.intellij.util.download.FileDownloader;
import java.io.File;
import org.jetbrains.android.download.AndroidComponentDownloader;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.annotations.NotNull;

public final class AndroidLayoutlibDownloader
extends AndroidComponentDownloader {
    private AndroidLayoutlibDownloader() {
    }

    @Override
    protected boolean doDownload(File pluginDir, FileDownloader downloader) {
        boolean res = super.doDownload(pluginDir, downloader);
        if (res) {
            StudioEmbeddedRenderTarget.resetInstance();
        }
        return res;
    }

    @Override
    @NotNull
    protected String getArtifactName() {
        return "layoutlib-resources";
    }

    @Override
    @NotNull
    protected String getExtension() {
        return "jar";
    }

    @Override
    protected File getTargetDir(File dir) {
        return new File(dir, "lib/layoutlib");
    }

    public static AndroidLayoutlibDownloader getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final AndroidLayoutlibDownloader INSTANCE = new AndroidLayoutlibDownloader();

        private Holder() {
        }
    }
}

