/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.xml;

import com.android.SdkConstants;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class AndroidXmlResourcesUtil {
    @NonNls
    public static final String SEARCHABLE_TAG_NAME = "searchable";
    @NonNls
    public static final String KEYBOARD_TAG_NAME = "Keyboard";
    @NonNls
    public static final String DEVICE_ADMIN_TAG_NAME = "device-admin";
    @NonNls
    public static final String ACCOUNT_AUTHENTICATOR_TAG_NAME = "account-authenticator";
    @NonNls
    public static final String PREFERENCE_HEADERS_TAG_NAME = "preference-headers";
    public static final ImmutableMap<String, String> SPECIAL_STYLEABLE_NAMES = ImmutableMap.builder().put((Object)"appwidget-provider", (Object)"AppWidgetProviderInfo").put((Object)"searchable", (Object)"Searchable").put((Object)"actionkey", (Object)"SearchableActionKey").put((Object)"intent", (Object)"Intent").put((Object)"Keyboard", (Object)"Keyboard").put((Object)"Row", (Object)"Keyboard_Row").put((Object)"Key", (Object)"Keyboard_Key").put((Object)"device-admin", (Object)"DeviceAdmin").put((Object)"account-authenticator", (Object)"AccountAuthenticator").put((Object)"header", (Object)"PreferenceHeader").build();
    private static final ImmutableSet<String> ROOT_TAGS = ImmutableSet.of((Object)"appwidget-provider", (Object)"searchable", (Object)"Keyboard", (Object)"device-admin", (Object)"account-authenticator", (Object)"preference-headers", (Object[])new String[]{"paths"});

    private AndroidXmlResourcesUtil() {
    }

    @NotNull
    public static List<String> getPossibleRoots(@NotNull AndroidFacet facet2) {
        boolean hasAndroidXClass;
        if (facet2 == null) {
            AndroidXmlResourcesUtil.$$$reportNull$$$0(0);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)facet2.getModule().getProject());
        boolean bl = hasAndroidXClass = javaPsiFacade.findClass(SdkConstants.CLASS_PREFERENCE_ANDROIDX.newName(), facet2.getModule().getModuleWithLibrariesScope()) != null;
        if (hasAndroidXClass) {
            result2.addAll(AndroidDomUtil.removeUnambiguousNames(AttributeProcessingUtil.getClassMap(facet2, SdkConstants.CLASS_PREFERENCE_ANDROIDX.newName())));
        } else if (javaPsiFacade.findClass(SdkConstants.CLASS_PREFERENCE_ANDROIDX.oldName(), facet2.getModule().getModuleWithLibrariesScope()) != null) {
            result2.addAll(AndroidDomUtil.removeUnambiguousNames(AttributeProcessingUtil.getClassMap(facet2, SdkConstants.CLASS_PREFERENCE_ANDROIDX.oldName())));
        } else {
            result2.addAll(AndroidDomUtil.removeUnambiguousNames(AttributeProcessingUtil.getFrameworkPreferencesClassMap(facet2)));
        }
        result2.addAll((Collection<String>)ROOT_TAGS);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            AndroidXmlResourcesUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static boolean isSupportedRootTag(@NotNull AndroidFacet facet2, @NotNull String rootTagName) {
        if (facet2 == null) {
            AndroidXmlResourcesUtil.$$$reportNull$$$0(2);
        }
        if (rootTagName == null) {
            AndroidXmlResourcesUtil.$$$reportNull$$$0(3);
        }
        return ROOT_TAGS.contains((Object)rootTagName) || LayoutViewClassUtils.findClassByTagName(facet2, rootTagName, "android.preference.Preference") != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/xml/AndroidXmlResourcesUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/xml/AndroidXmlResourcesUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleRoots";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedRootTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum PreferenceSource {
        ANDROIDX(SdkConstants.CLASS_PREFERENCE_ANDROIDX.newName(), SdkConstants.CLASS_PREFERENCE_GROUP_ANDROIDX.newName()),
        SUPPORT(SdkConstants.CLASS_PREFERENCE_ANDROIDX.oldName(), SdkConstants.CLASS_PREFERENCE_GROUP_ANDROIDX.oldName()),
        FRAMEWORK("android.preference.Preference", "android.preference.PreferenceGroup");

        private final String myQualifiedBaseClass;
        private final String myQualifiedGroupClass;

        private PreferenceSource(String qualifiedBaseClass, String qualifiedGroupClass) {
            this.myQualifiedBaseClass = qualifiedBaseClass;
            this.myQualifiedGroupClass = qualifiedGroupClass;
        }

        public String getQualifiedBaseClass() {
            return this.myQualifiedBaseClass;
        }

        public String getQualifiedGroupClass() {
            return this.myQualifiedGroupClass;
        }

        public static PreferenceSource getPreferencesSource(@NotNull XmlTag tag, @NotNull AndroidFacet facet2) {
            XmlTag rootTag;
            if (tag == null) {
                PreferenceSource.$$$reportNull$$$0(0);
            }
            if (facet2 == null) {
                PreferenceSource.$$$reportNull$$$0(1);
            }
            if ((rootTag = ((XmlFile)tag.getContainingFile()).getRootTag()) == null) {
                return FRAMEWORK;
            }
            String rootTagName = rootTag.getName();
            if (rootTagName.startsWith("androidx.")) {
                return ANDROIDX;
            }
            if (rootTagName.startsWith("android.support.v") && StringUtil.getPackageName((String)rootTagName).endsWith("preference")) {
                return SUPPORT;
            }
            if (rootTagName.startsWith("android.")) {
                return FRAMEWORK;
            }
            Project project = facet2.getModule().getProject();
            String supportLibName = SdkConstants.CLASS_PREFERENCE_ANDROIDX.oldName();
            String androidXLibName = SdkConstants.CLASS_PREFERENCE_ANDROIDX.newName();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            if (psiFacade.findClass(supportLibName, rootTag.getResolveScope()) == null && psiFacade.findClass(androidXLibName, rootTag.getResolveScope()) == null) {
                return FRAMEWORK;
            }
            PsiJavaParserFacade parser = psiFacade.getParserFacade();
            try {
                PsiType type = parser.createTypeFromText(rootTagName, null);
                if (type instanceof PsiClassType && ((PsiClassType)type).resolve() != null) {
                    if (InheritanceUtil.isInheritor((PsiType)type, (String)androidXLibName)) {
                        return ANDROIDX;
                    }
                    if (InheritanceUtil.isInheritor((PsiType)type, (String)supportLibName)) {
                        return SUPPORT;
                    }
                    return FRAMEWORK;
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (psiFacade.findClass(androidXLibName, rootTag.getResolveScope()) != null) {
                return ANDROIDX;
            }
            return SUPPORT;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "facet";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/dom/xml/AndroidXmlResourcesUtil$PreferenceSource";
            objectArray[2] = "getPreferencesSource";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

