/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.ResourceType;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00032\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/android/dom/converters/StringResourceAdapterConverter;", "Lcom/intellij/util/xml/WrappingConverter;", "innerConverter", "Lcom/intellij/util/xml/Converter;", "(Lcom/intellij/util/xml/Converter;)V", "getConverter", "domElement", "Lcom/intellij/util/xml/GenericDomValue;", "intellij.android.core"})
public final class StringResourceAdapterConverter
extends WrappingConverter {
    private final Converter<?> innerConverter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Converter<?> getConverter(@NotNull GenericDomValue<?> domElement) {
        Converter converter;
        Intrinsics.checkNotNullParameter(domElement, (String)"domElement");
        String string = domElement.getRawText();
        if (string != null) {
            if (StringsKt.startsWith$default((CharSequence)string, (char)'@', (boolean)false, (int)2, null)) {
                converter = (Converter)new ResourceReferenceConverter(ResourceType.STRING, true, true);
                return converter;
            }
        }
        converter = this.innerConverter;
        return converter;
    }

    public StringResourceAdapterConverter(@NotNull Converter<?> innerConverter) {
        Intrinsics.checkNotNullParameter(innerConverter, (String)"innerConverter");
        this.innerConverter = innerConverter;
    }
}

