/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.StringKt;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.xml.XmlExtension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.converters.ResourceNamespaceFakePsiElement;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/android/dom/converters/ResourceNamespaceReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/xml/XmlElement;", "domValue", "Lcom/intellij/util/xml/GenericDomValue;", "resourceValue", "Lorg/jetbrains/android/dom/resources/ResourceValue;", "(Lcom/intellij/util/xml/GenericDomValue;Lorg/jetbrains/android/dom/resources/ResourceValue;)V", "calculateDefaultRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getVariants", "", "Lcom/intellij/psi/PsiElement;", "()[Lcom/intellij/psi/PsiElement;", "resolve", "intellij.android.core"})
public final class ResourceNamespaceReference
extends PsiReferenceBase<XmlElement> {
    private final ResourceValue resourceValue;

    @NotNull
    public PsiElement[] getVariants() {
        Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"PsiElement.EMPTY_ARRAY");
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement psiElement;
        SchemaPrefix schemaPrefix;
        TextRange textRange = this.getRangeInElement();
        XmlElement xmlElement = (XmlElement)this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)xmlElement, (String)"element");
        String string = StringKt.nullize((String)textRange.substring(xmlElement.getText()), (boolean)true);
        if (string == null) {
            return null;
        }
        String prefix = string;
        XmlExtension xmlExtension = XmlExtension.getExtensionByElement((PsiElement)this.getElement());
        if (xmlExtension != null) {
            XmlElement xmlElement2 = (XmlElement)this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)xmlElement2, (String)"element");
            PsiElement $this$parentOfType$iv = (PsiElement)xmlElement2;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            schemaPrefix = xmlExtension.getPrefixDeclaration((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, XmlTag.class, (boolean)true), prefix);
        } else {
            schemaPrefix = null;
        }
        SchemaPrefix prefixDeclaration = schemaPrefix;
        ResourceRepositoryManager resourceRepositoryManager = ResourceRepositoryManager.getInstance(this.getElement());
        if (resourceRepositoryManager == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)resourceRepositoryManager, (String)"ResourceRepositoryManage\u2026e(element) ?: return null");
        ResourceRepositoryManager repositoryManager = resourceRepositoryManager;
        if (prefixDeclaration != null && repositoryManager.getNamespacing() != AaptOptions.Namespacing.DISABLED) {
            return (PsiElement)prefixDeclaration;
        }
        XmlElement xmlElement3 = (XmlElement)this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)xmlElement3, (String)"element");
        ResourceNamespace resourceNamespace = ResourceHelper.resolveResourceNamespace(xmlElement3, prefix);
        if (resourceNamespace == null) {
            return null;
        }
        ResourceNamespace resourceNamespace2 = resourceNamespace;
        XmlElement xmlElement4 = (XmlElement)this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)xmlElement4, (String)"element");
        ResourceNamespace resourceNamespace3 = ResourceHelper.resolveResourceNamespace(xmlElement4, prefix);
        if (Intrinsics.areEqual((Object)resourceNamespace3, (Object)ResourceNamespace.ANDROID)) {
            XmlElement xmlElement5 = (XmlElement)this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)xmlElement5, (String)"element");
            psiElement = (PsiElement)new ResourceNamespaceFakePsiElement(resourceNamespace2, xmlElement5);
        } else {
            LocalResourceRepository localResourceRepository = repositoryManager.getAppResources();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)localResourceRepository), (String)"repositoryManager.appResources");
            if (localResourceRepository.getNamespaces().contains(resourceNamespace3)) {
                XmlElement xmlElement6 = (XmlElement)this.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)xmlElement6, (String)"element");
                psiElement = (PsiElement)new ResourceNamespaceFakePsiElement(resourceNamespace2, xmlElement6);
            } else {
                psiElement = null;
            }
        }
        return psiElement;
    }

    @NotNull
    protected TextRange calculateDefaultRangeInElement() {
        TextRange wholeReferenceRange;
        TextRange textRange = wholeReferenceRange = super.calculateDefaultRangeInElement();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"wholeReferenceRange");
        int startOffset = textRange.getStartOffset() + (this.resourceValue.getPrefix() == (char)0 ? 0 : 1);
        String string = this.resourceValue.getPackage();
        Intrinsics.checkNotNull((Object)string);
        return new TextRange(startOffset, startOffset + string.length());
    }

    public ResourceNamespaceReference(@NotNull GenericDomValue<?> domValue, @NotNull ResourceValue resourceValue2) {
        Intrinsics.checkNotNullParameter(domValue, (String)"domValue");
        Intrinsics.checkNotNullParameter((Object)resourceValue2, (String)"resourceValue");
        XmlElement xmlElement = DomUtil.getValueElement(domValue);
        Intrinsics.checkNotNull((Object)xmlElement);
        super((PsiElement)xmlElement, null, true);
        this.resourceValue = resourceValue2;
    }
}

