/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.psi.TagToClassMapper;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtension;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.RequiredImpl;
import org.jetbrains.android.dom.Styleable;
import org.jetbrains.android.dom.animation.InterpolatorElement;
import org.jetbrains.android.dom.animation.fileDescriptions.InterpolatorDomFileDescription;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.dom.attrs.ToolsAttributeUtil;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.ManifestPlaceholderConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.DataBindingElement;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.layout.Tag;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElement;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.dom.menu.MenuItem;
import org.jetbrains.android.dom.navigation.NavDestinationElement;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.dom.raw.XmlRawResourceElement;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.Intent;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeProcessingUtil {
    private static final String PREFERENCE_TAG_NAME = "Preference";
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_TAG_NAMES = ImmutableSet.of((Object)"merge", (Object)"TableRow", (Object)"include", (Object)"requestFocus", (Object)"layout", (Object)"data", (Object[])new String[]{"import", "tag"});
    private static final ImmutableSet<String> SIZE_NOT_REQUIRED_PARENT_TAG_NAMES = ImmutableSet.of((Object)"TableRow", (Object)"TableLayout", (Object)"merge", (Object)"GridLayout", (Object)SdkConstants.FQCN_GRID_LAYOUT_V7.oldName(), (Object)SdkConstants.FQCN_GRID_LAYOUT_V7.newName(), (Object[])new String[]{"android.support.percent.PercentRelativeLayout", "android.support.percent.PercentFrameLayout"});

    private AttributeProcessingUtil() {
    }

    private static Logger getLog() {
        return Logger.getInstance(AttributeProcessingUtil.class);
    }

    public static boolean isLayoutAttributeRequired(@NotNull XmlName attributeName, @NotNull DomElement element) {
        String localName;
        if (attributeName == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(1);
        }
        if (!"layout_width".equals(localName = attributeName.getLocalName()) && !"layout_height".equals(localName)) {
            return false;
        }
        if ((element instanceof LayoutViewElement || element instanceof Fragment) && "http://schemas.android.com/apk/res/android".equals(attributeName.getNamespaceKey())) {
            String tagName;
            XmlElement xmlElement = element.getXmlElement();
            XmlTag tag = xmlElement instanceof XmlTag ? (XmlTag)xmlElement : null;
            String string = tagName = tag != null ? tag.getName() : null;
            if (!(SIZE_NOT_REQUIRED_TAG_NAMES.contains((Object)tagName) || tag != null && tag.getAttribute("style") != null)) {
                String parentTagName;
                XmlTag parentTag = tag != null ? tag.getParentTag() : null;
                String string2 = parentTagName = parentTag != null ? parentTag.getName() : null;
                if (!SIZE_NOT_REQUIRED_PARENT_TAG_NAMES.contains((Object)parentTagName)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private static String getNamespaceUriByResourcePackage(@NotNull AndroidFacet facet2, @Nullable String resPackage) {
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(2);
        }
        if (resPackage == null) {
            String aPackage;
            if (!((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject() || AndroidModel.isRequired(facet2)) {
                return "http://schemas.android.com/apk/res-auto";
            }
            Manifest manifest = Manifest.getMainManifest(facet2);
            if (manifest != null && (aPackage = (String)manifest.getPackage().getValue()) != null && !aPackage.isEmpty()) {
                return "http://schemas.android.com/apk/res/" + aPackage;
            }
        } else if (resPackage.equals("android")) {
            return "http://schemas.android.com/apk/res/android";
        }
        return null;
    }

    private static void registerStyleableAttributes(@NotNull DomElement element, @NotNull StyleableDefinition styleable, @Nullable String namespaceUri, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skippedAttributes) {
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(3);
        }
        if (styleable == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(4);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(5);
        }
        if (skippedAttributes == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(6);
        }
        for (AttributeDefinition attrDef : styleable.getAttributes()) {
            XmlName xmlName = AttributeProcessingUtil.getXmlName(attrDef, namespaceUri);
            if (!skippedAttributes.add(xmlName)) continue;
            AttributeProcessingUtil.registerAttribute(attrDef, xmlName, styleable.getName(), element, callback2);
        }
    }

    private static boolean mustBeSoft(@NotNull Converter converter, @NotNull Collection<AttributeFormat> formats) {
        if (converter == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(7);
        }
        if (formats == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(8);
        }
        if (converter instanceof CompositeConverter || converter instanceof ResourceReferenceConverter) {
            return false;
        }
        return formats.size() > 1;
    }

    private static void registerAttribute(@NotNull AttributeDefinition attrDef, @NotNull XmlName xmlName, @Nullable String parentStyleableName, @NotNull DomElement element, @NotNull AttributeProcessor callback2) {
        DomExtension extension;
        if (attrDef == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(9);
        }
        if (xmlName == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(10);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(11);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(12);
        }
        if ((extension = callback2.processAttribute(xmlName, attrDef, parentStyleableName)) == null) {
            return;
        }
        Object converter = AndroidDomUtil.getSpecificConverter(xmlName, element);
        if (converter == null) {
            if ("http://schemas.android.com/tools".equals(xmlName.getNamespaceKey())) {
                converter = ToolsAttributeUtil.getConverter(attrDef);
            } else {
                converter = AndroidDomUtil.getConverter(attrDef);
                if (converter != null && element.getParentOfType(Manifest.class, true) != null) {
                    converter = new ManifestPlaceholderConverter((Converter)converter);
                }
            }
        }
        if (converter != null) {
            extension.setConverter(converter, AttributeProcessingUtil.mustBeSoft(converter, attrDef.getFormats()));
        }
        if (element instanceof LayoutElement && AttributeProcessingUtil.isLayoutAttributeRequired(xmlName, element) || element instanceof ManifestElement && AndroidManifestUtils.isRequiredAttribute(xmlName, element)) {
            extension.addCustomAnnotation((Annotation)((Object)new RequiredImpl()));
        }
    }

    private static void registerAttributes(@NotNull AndroidFacet facet2, @NotNull DomElement element, @NotNull String styleableName, @Nullable String resPackage, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skipNames) {
        ResourceManager manager;
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(13);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(14);
        }
        if (styleableName == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(15);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(16);
        }
        if (skipNames == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(17);
        }
        if ((manager = ModuleResourceManagers.getInstance(facet2).getResourceManager(resPackage)) == null) {
            return;
        }
        AttributeDefinitions attrDefs = manager.getAttributeDefinitions();
        if (attrDefs == null) {
            return;
        }
        String namespace = AttributeProcessingUtil.getNamespaceUriByResourcePackage(facet2, resPackage);
        StyleableDefinition styleable = attrDefs.getStyleableByName(styleableName);
        if (styleable != null) {
            AttributeProcessingUtil.registerStyleableAttributes(element, styleable, namespace, callback2, skipNames);
        }
    }

    private static void registerAttributesForClassAndSuperclasses(@NotNull AndroidFacet facet2, @NotNull DomElement element, @Nullable PsiClass c, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skipNames) {
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(18);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(19);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(20);
        }
        if (skipNames == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(21);
        }
        while (c != null) {
            String styleableName = c.getName();
            if (styleableName != null) {
                AttributeProcessingUtil.registerAttributes(facet2, element, styleableName, AttributeProcessingUtil.getResourcePackage(c), callback2, skipNames);
            }
            for (PsiClass additional : AttributeProcessingUtil.getAdditionalAttributesClasses(facet2, c)) {
                String additionalStyleableName = additional.getName();
                if (additionalStyleableName == null) continue;
                AttributeProcessingUtil.registerAttributes(facet2, element, additionalStyleableName, AttributeProcessingUtil.getResourcePackage(additional), callback2, skipNames);
            }
            c = AttributeProcessingUtil.getSuperclass(c);
        }
    }

    private static Collection<PsiClass> getAdditionalAttributesClasses(@NotNull AndroidFacet facet2, @NotNull PsiClass c) {
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(22);
        }
        if (c == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(23);
        }
        if (SdkConstants.CLASS_NESTED_SCROLL_VIEW.isEquals(StringUtil.notNullize((String)c.getQualifiedName()))) {
            return Collections.singleton(AttributeProcessingUtil.getViewClassMap(facet2).get("ScrollView"));
        }
        return Collections.emptySet();
    }

    @Nullable
    private static String getResourcePackage(@NotNull PsiClass psiClass) {
        String qualifiedName;
        if (psiClass == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(24);
        }
        return (qualifiedName = psiClass.getQualifiedName()) != null && qualifiedName.startsWith("android.") && !qualifiedName.startsWith("android.support.") && !qualifiedName.startsWith("androidx.") && !qualifiedName.startsWith("android.arch.") ? "android" : null;
    }

    @Nullable
    private static PsiClass getSuperclass(@NotNull PsiClass c) {
        if (c == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(25);
        }
        return (PsiClass)ApplicationManager.getApplication().runReadAction(() -> c.isValid() ? c.getSuperClass() : null);
    }

    public static void processXmlAttributes(@NotNull AndroidFacet facet2, @NotNull XmlTag tag, @NotNull XmlResourceElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback2) {
        PsiClass widgetClass;
        String widgetClassName;
        AndroidXmlResourcesUtil.PreferenceSource preferenceSource;
        Map<String, PsiClass> prefClassMap;
        PsiClass psiClass;
        String tagName;
        String styleableName;
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(26);
        }
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(27);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(28);
        }
        if (skipAttrNames == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(29);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(30);
        }
        if ((styleableName = (String)AndroidXmlResourcesUtil.SPECIAL_STYLEABLE_NAMES.get((Object)(tagName = tag.getName()))) != null) {
            HashSet<XmlName> newSkipAttrNames = new HashSet<XmlName>();
            if (element instanceof Intent) {
                newSkipAttrNames.add(new XmlName("action", "http://schemas.android.com/apk/res/android"));
            }
            AttributeProcessingUtil.registerAttributes(facet2, element, styleableName, "android", callback2, newSkipAttrNames);
        }
        if ((psiClass = (prefClassMap = AttributeProcessingUtil.getClassMap(facet2, (preferenceSource = AndroidXmlResourcesUtil.PreferenceSource.getPreferencesSource(tag, facet2)).getQualifiedBaseClass())).get(tagName)) == null) {
            return;
        }
        AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element, psiClass, callback2, skipAttrNames);
        if (StringUtil.notNullize((String)psiClass.getQualifiedName()).startsWith("android.preference.") && (widgetClassName = AndroidTextUtils.trimEndOrNullize((String)tagName, (String)PREFERENCE_TAG_NAME)) != null && (widgetClass = LayoutViewClassUtils.findClassByTagName(facet2, widgetClassName, "android.view.View")) != null) {
            AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element, widgetClass, callback2, skipAttrNames);
        }
    }

    public static Map<String, PsiClass> getClassMap(AndroidFacet facet2, String qualifiedClassName) {
        if (DumbService.isDumb((Project)facet2.getModule().getProject())) {
            return Collections.emptyMap();
        }
        return TagToClassMapper.getInstance(facet2.getModule()).getClassMap(qualifiedClassName);
    }

    public static Map<String, PsiClass> getFrameworkPreferencesClassMap(AndroidFacet facet2) {
        return AttributeProcessingUtil.getClassMap(facet2, "android.preference.Preference");
    }

    public static Map<String, PsiClass> getViewClassMap(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(31);
        }
        return AttributeProcessingUtil.getClassMap(facet2, "android.view.View");
    }

    public static Map<String, PsiClass> getViewGroupClassMap(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(32);
        }
        return AttributeProcessingUtil.getClassMap(facet2, "android.view.ViewGroup");
    }

    @Nullable
    public static String getLayoutStyleablePrimary(@NotNull PsiClass psiLayoutClass) {
        String viewName;
        if (psiLayoutClass == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(33);
        }
        if ((viewName = psiLayoutClass.getName()) == null) {
            return null;
        }
        switch (viewName) {
            case "ViewGroup": {
                return "ViewGroup_MarginLayout";
            }
            case "TableRow": {
                return "TableRow_Cell";
            }
        }
        return viewName + "_Layout";
    }

    @Nullable
    public static String getLayoutStyleableSecondary(@NotNull PsiClass psiLayoutClass) {
        String viewName;
        if (psiLayoutClass == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(34);
        }
        if ((viewName = psiLayoutClass.getName()) == null) {
            return null;
        }
        switch (viewName) {
            case "AppBarLayout": 
            case "CollapsingToolbarLayout": 
            case "CoordinatorLayout": {
                return viewName + "_LayoutParams";
            }
        }
        return null;
    }

    private static void registerAttributesFromSuffixedStyleables(@NotNull AndroidFacet facet2, @NotNull DomElement element, @NotNull PsiClass psiClass, @NotNull AttributeProcessor callback2, @NotNull Set<XmlName> skipAttrNames) {
        String secondary;
        String primary;
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(35);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(36);
        }
        if (psiClass == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(37);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(38);
        }
        if (skipAttrNames == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(39);
        }
        if ((primary = AttributeProcessingUtil.getLayoutStyleablePrimary(psiClass)) != null) {
            AttributeProcessingUtil.registerAttributes(facet2, element, primary, AttributeProcessingUtil.getResourcePackage(psiClass), callback2, skipAttrNames);
        }
        if ((secondary = AttributeProcessingUtil.getLayoutStyleableSecondary(psiClass)) != null) {
            AttributeProcessingUtil.registerAttributes(facet2, element, secondary, null, callback2, skipAttrNames);
        }
    }

    public static void processNavAttributes(@NotNull AndroidFacet facet2, @NotNull XmlTag tag, @NotNull NavDestinationElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback2) {
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(40);
        }
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(41);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(42);
        }
        if (skipAttrNames == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(43);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(44);
        }
        try {
            NavigationSchema.createIfNecessary(facet2.getModule());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        NavigationSchema schema = NavigationSchema.get(facet2.getModule());
        for (PsiClass psiClass : schema.getStyleablesForTag(tag.getName())) {
            AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element, psiClass, callback2, skipAttrNames);
        }
    }

    public static void processLayoutAttributes(@NotNull AndroidFacet facet2, @NotNull XmlTag tag, @NotNull LayoutElement element, @NotNull Set<XmlName> skipAttrNames, @NotNull AttributeProcessor callback2) {
        String tagName;
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(45);
        }
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(46);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(47);
        }
        if (skipAttrNames == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(48);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(49);
        }
        Map<String, PsiClass> map2 = AttributeProcessingUtil.getViewClassMap(facet2);
        if (!(element instanceof DataBindingElement)) {
            PsiClass newRecyclerView;
            PsiClass oldRecyclerView;
            PsiClass newDrawerLayout;
            PsiClass oldDrawerLayout;
            AttributeProcessingUtil.registerToolsAttribute("targetApi", callback2);
            if (tag.getParentTag() == null) {
                AttributeProcessingUtil.registerToolsAttribute("context", callback2);
                AttributeProcessingUtil.registerToolsAttribute("menu", callback2);
                AttributeProcessingUtil.registerToolsAttribute("actionBarNavMode", callback2);
                AttributeProcessingUtil.registerToolsAttribute("showIn", callback2);
                AttributeProcessingUtil.registerToolsAttribute("viewBindingIgnore", callback2);
            }
            PsiClass adapterView = map2.get("AdapterView");
            String psiClass = map2.get(tag.getName());
            if (adapterView != null && psiClass != null && psiClass.isInheritor(adapterView, true)) {
                AttributeProcessingUtil.registerToolsAttribute("listitem", callback2);
                AttributeProcessingUtil.registerToolsAttribute("listheader", callback2);
                AttributeProcessingUtil.registerToolsAttribute("listfooter", callback2);
            }
            if ((oldDrawerLayout = map2.get(SdkConstants.CLASS_DRAWER_LAYOUT.oldName())) != null && psiClass != null && (psiClass.isEquivalentTo((PsiElement)oldDrawerLayout) || psiClass.isInheritor(oldDrawerLayout, true))) {
                AttributeProcessingUtil.registerToolsAttribute("openDrawer", callback2);
            }
            if ((newDrawerLayout = map2.get(SdkConstants.CLASS_DRAWER_LAYOUT.newName())) != null && psiClass != null && (psiClass.isEquivalentTo((PsiElement)newDrawerLayout) || psiClass.isInheritor(newDrawerLayout, true))) {
                AttributeProcessingUtil.registerToolsAttribute("openDrawer", callback2);
            }
            if ((oldRecyclerView = map2.get(SdkConstants.RECYCLER_VIEW.oldName())) != null && psiClass != null && (psiClass.isEquivalentTo((PsiElement)oldRecyclerView) || psiClass.isInheritor(oldRecyclerView, true))) {
                AttributeProcessingUtil.registerToolsAttribute("itemCount", callback2);
                AttributeProcessingUtil.registerToolsAttribute("listitem", callback2);
            }
            if ((newRecyclerView = map2.get(SdkConstants.RECYCLER_VIEW.newName())) != null && psiClass != null && (psiClass.isEquivalentTo((PsiElement)newRecyclerView) || psiClass.isInheritor(newRecyclerView, true))) {
                AttributeProcessingUtil.registerToolsAttribute("itemCount", callback2);
                AttributeProcessingUtil.registerToolsAttribute("listitem", callback2);
            }
            if (((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue()) {
                AttributeProcessingUtil.registerToolsAttribute("mockup", callback2);
                AttributeProcessingUtil.registerToolsAttribute("mockup_crop", callback2);
                AttributeProcessingUtil.registerToolsAttribute("mockup_opacity", callback2);
            }
        }
        if (element instanceof Tag || element instanceof Data) {
            return;
        }
        switch (tagName = tag.getName()) {
            case "fragment": {
                AttributeProcessingUtil.registerToolsAttribute("layout", callback2);
                break;
            }
            case "view": {
                for (PsiClass aClass : map2.values()) {
                    String name = aClass.getName();
                    if (name == null) continue;
                    AttributeProcessingUtil.registerAttributes(facet2, element, name, AttributeProcessingUtil.getResourcePackage(aClass), callback2, skipAttrNames);
                }
                break;
            }
            case "merge": {
                if (tag.getParentTag() == null) {
                    AttributeProcessingUtil.registerToolsAttribute("parentTag", callback2);
                }
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element, map2.get("merge"), callback2, skipAttrNames);
                String parentTagName = tag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
                if (parentTagName == null) break;
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element, map2.get(parentTagName), callback2, skipAttrNames);
                break;
            }
            default: {
                PsiClass c = map2.get(tagName);
                AttributeProcessingUtil.registerAttributesForClassAndSuperclasses(facet2, element, c, callback2, skipAttrNames);
            }
        }
        if (tagName.equals("merge")) {
            return;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag != null) {
            String parentTagName = parentTag.getName();
            if ("merge".equals(parentTagName)) {
                parentTagName = parentTag.getAttributeValue("parentTag", "http://schemas.android.com/tools");
            }
            if ("layout".equals(parentTagName)) {
                parentTagName = "ViewGroup";
            }
            if (parentTagName != null) {
                PsiClass c = map2.get(parentTagName);
                while (c != null) {
                    AttributeProcessingUtil.registerAttributesFromSuffixedStyleables(facet2, element, c, callback2, skipAttrNames);
                    c = AttributeProcessingUtil.getSuperclass(c);
                }
                return;
            }
        }
        for (PsiClass c : map2.values()) {
            AttributeProcessingUtil.registerAttributesFromSuffixedStyleables(facet2, element, c, callback2, skipAttrNames);
        }
    }

    public static void processAttributes(@NotNull AndroidDomElement element, @NotNull AndroidFacet facet2, boolean processAllExistingAttrsFirst, @NotNull AttributeProcessor callback2) {
        String styleableName;
        AttributeDefinitions definitions;
        HashSet<XmlName> skippedAttributes;
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(50);
        }
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(51);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(52);
        }
        if (DumbService.getInstance((Project)facet2.getModule().getProject()).isDumb()) {
            return;
        }
        XmlTag tag = element.getXmlTag();
        assert (tag != null);
        Set<XmlName> set = skippedAttributes = processAllExistingAttrsFirst ? AttributeProcessingUtil.registerExistingAttributes(facet2, tag, element, callback2) : new HashSet<XmlName>();
        if (element instanceof ManifestElement) {
            AttributeProcessingUtil.processManifestAttributes(tag, element, callback2);
        } else if (element instanceof LayoutElement) {
            AttributeProcessingUtil.processLayoutAttributes(facet2, tag, (LayoutElement)element, skippedAttributes, callback2);
        } else if (element instanceof XmlResourceElement) {
            AttributeProcessingUtil.processXmlAttributes(facet2, tag, (XmlResourceElement)element, skippedAttributes, callback2);
        } else if (element instanceof XmlRawResourceElement) {
            AttributeProcessingUtil.processRawAttributes(tag, callback2);
        } else if (element instanceof NavDestinationElement) {
            AttributeProcessingUtil.processNavAttributes(facet2, tag, (NavDestinationElement)element, skippedAttributes, callback2);
        }
        Styleable styleableAnnotation = (Styleable)element.getAnnotation(Styleable.class);
        if (styleableAnnotation == null) {
            return;
        }
        boolean isSystem = styleableAnnotation.packageName().equals("android");
        if (isSystem) {
            String[] manager = ModuleResourceManagers.getInstance(facet2).getFrameworkResourceManager();
            if (manager == null) {
                return;
            }
            definitions = manager.getAttributeDefinitions();
            if (definitions == null) {
                return;
            }
        } else {
            definitions = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager().getAttributeDefinitions();
        }
        if (element instanceof MenuItem) {
            AttributeProcessingUtil.processMenuItemAttributes(facet2, element, skippedAttributes, callback2);
            return;
        }
        for (String styleableName2 : styleableAnnotation.value()) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName2);
            if (styleable != null) {
                AttributeProcessingUtil.registerStyleableAttributes(element, styleable, isSystem ? "http://schemas.android.com/apk/res/android" : "http://schemas.android.com/apk/res-auto", callback2, skippedAttributes);
                continue;
            }
            if (!isSystem) continue;
            AttributeProcessingUtil.getLog().warn(String.format("@Styleable(%s) annotation doesn't point to existing styleable", styleableName2));
        }
        if (element instanceof InterpolatorElement && (styleableName = InterpolatorDomFileDescription.getInterpolatorStyleableByTagName(tag.getName())) != null) {
            StyleableDefinition styleable = definitions.getStyleableByName(styleableName);
            if (styleable == null) {
                AttributeProcessingUtil.getLog().warn(String.format("%s doesn't point to existing styleable for interpolator", styleableName));
            } else {
                AttributeProcessingUtil.registerStyleableAttributes(element, styleable, "http://schemas.android.com/apk/res/android", callback2, skippedAttributes);
            }
        }
    }

    public static void processRawAttributes(@NotNull XmlTag tag, @NotNull AttributeProcessor callback2) {
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(53);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(54);
        }
        if ("resources".equals(tag.getName())) {
            AttributeProcessingUtil.registerToolsAttribute("shrinkMode", callback2);
            AttributeProcessingUtil.registerToolsAttribute("keep", callback2);
            AttributeProcessingUtil.registerToolsAttribute("discard", callback2);
        }
    }

    public static void processManifestAttributes(@NotNull XmlTag tag, @NotNull AndroidDomElement element, @NotNull AttributeProcessor callback2) {
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(55);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(56);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(57);
        }
        if (tag.getParentTag() != null) {
            AttributeProcessingUtil.registerToolsAttribute("node", callback2);
            AttributeProcessingUtil.registerToolsAttribute("strict", callback2);
            AttributeProcessingUtil.registerToolsAttribute("remove", callback2);
            AttributeProcessingUtil.registerToolsAttribute("replace", callback2);
        }
        if (element instanceof UsesSdk) {
            AttributeProcessingUtil.registerToolsAttribute("overrideLibrary", callback2);
        }
    }

    private static void processMenuItemAttributes(@NotNull AndroidFacet facet2, @NotNull DomElement element, @NotNull Collection<XmlName> skippedAttributes, @NotNull AttributeProcessor callback2) {
        FrameworkResourceManager manager;
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(58);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(59);
        }
        if (skippedAttributes == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(60);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(61);
        }
        if ((manager = ModuleResourceManagers.getInstance(facet2).getFrameworkResourceManager()) == null) {
            return;
        }
        AttributeDefinitions styleables = ((ResourceManager)manager).getAttributeDefinitions();
        if (styleables == null) {
            return;
        }
        StyleableDefinition styleable = styleables.getStyleableByName("MenuItem");
        if (styleable == null) {
            AttributeProcessingUtil.getLog().warn("No StyleableDefinition for MenuItem");
            return;
        }
        for (AttributeDefinition attribute : styleable.getAttributes()) {
            XmlName xmlName;
            String name = attribute.getName();
            if (name.equals("showAsAction")) {
                boolean hasAppCompat;
                boolean bl = hasAppCompat = DependencyManagementUtil.dependsOn(facet2.getModule(), GoogleMavenArtifactId.APP_COMPAT_V7) || DependencyManagementUtil.dependsOn(facet2.getModule(), GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
                if (hasAppCompat) {
                    XmlName xmlName2 = new XmlName(name, "http://schemas.android.com/apk/res-auto");
                    if (!skippedAttributes.add(xmlName2)) continue;
                    AttributeProcessingUtil.registerAttribute(attribute, xmlName2, "MenuItem", element, callback2);
                    continue;
                }
            }
            if (!skippedAttributes.add(xmlName = new XmlName(name, "http://schemas.android.com/apk/res/android"))) continue;
            AttributeProcessingUtil.registerAttribute(attribute, xmlName, "MenuItem", element, callback2);
        }
    }

    private static void registerToolsAttribute(@NotNull String attributeName, @NotNull AttributeProcessor callback2) {
        AttributeDefinition definition;
        if (attributeName == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(62);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(63);
        }
        if ((definition = ToolsAttributeUtil.getAttrDefByName(attributeName)) != null) {
            XmlName name = new XmlName(attributeName, "http://schemas.android.com/tools");
            DomExtension domExtension = callback2.processAttribute(name, definition, null);
            Converter converter = ToolsAttributeUtil.getConverter(definition);
            if (domExtension != null && converter != null) {
                domExtension.setConverter(converter);
            }
        } else {
            AttributeProcessingUtil.getLog().warn("No attribute definition for tools attribute " + attributeName);
        }
    }

    @NotNull
    private static Set<XmlName> registerExistingAttributes(@NotNull AndroidFacet facet2, @NotNull XmlTag tag, @NotNull AndroidDomElement element, @NotNull AttributeProcessor callback2) {
        XmlAttribute[] attrs;
        if (facet2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(64);
        }
        if (tag == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(65);
        }
        if (element == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(66);
        }
        if (callback2 == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(67);
        }
        HashSet<XmlName> result2 = new HashSet<XmlName>();
        for (XmlAttribute attr : attrs = tag.getAttributes()) {
            AttributeDefinition attrDef;
            String localName = attr.getLocalName();
            if (localName.endsWith(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED) || "xmlns".equals(attr.getNamespacePrefix()) || (attrDef = AndroidDomUtil.getAttributeDefinition(facet2, attr)) == null) continue;
            XmlName xmlName = AttributeProcessingUtil.getXmlName(attrDef, attr.getNamespace());
            result2.add(xmlName);
            String namespaceUri = attr.getNamespace();
            AttributeProcessingUtil.registerAttribute(attrDef, xmlName, null, element, callback2);
        }
        HashSet<XmlName> hashSet = result2;
        if (hashSet == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(68);
        }
        return hashSet;
    }

    private static XmlName getXmlName(@NotNull AttributeDefinition attrDef, @Nullable String namespaceUri) {
        if (attrDef == null) {
            AttributeProcessingUtil.$$$reportNull$$$0(69);
        }
        ResourceReference attrReference = attrDef.getResourceReference();
        String attrNamespaceUri = attrReference.getNamespace().getXmlNamespaceUri();
        return new XmlName(attrReference.getName(), "http://schemas.android.com/tools".equals(namespaceUri) ? "http://schemas.android.com/tools" : attrNamespaceUri);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 68: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 68: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 14: 
            case 19: 
            case 28: 
            case 36: 
            case 42: 
            case 47: 
            case 50: 
            case 56: 
            case 59: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 13: 
            case 18: 
            case 22: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 40: 
            case 45: 
            case 51: 
            case 58: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleable";
                break;
            }
            case 5: 
            case 12: 
            case 16: 
            case 20: 
            case 30: 
            case 38: 
            case 44: 
            case 49: 
            case 52: 
            case 54: 
            case 57: 
            case 61: 
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skippedAttributes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 9: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrDef";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleableName";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipNames";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 27: 
            case 41: 
            case 46: 
            case 53: 
            case 55: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 29: 
            case 39: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipAttrNames";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiLayoutClass";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/AttributeProcessingUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/AttributeProcessingUtil";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "registerExistingAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLayoutAttributeRequired";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceUriByResourcePackage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerStyleableAttributes";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mustBeSoft";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerAttribute";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerAttributes";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerAttributesForClassAndSuperclasses";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalAttributesClasses";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getResourcePackage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclass";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processXmlAttributes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getViewClassMap";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getViewGroupClassMap";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutStyleablePrimary";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutStyleableSecondary";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "registerAttributesFromSuffixedStyleables";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processNavAttributes";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processLayoutAttributes";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processAttributes";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processRawAttributes";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processManifestAttributes";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "processMenuItemAttributes";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "registerToolsAttribute";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "registerExistingAttributes";
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getXmlName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 68: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AttributeProcessor {
        @Nullable
        public DomExtension processAttribute(@NotNull XmlName var1, @NotNull AttributeDefinition var2, @Nullable String var3);
    }
}

