/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.support.AndroidxName;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlName;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.ToolsAttributeDefinitionsImpl;
import org.jetbrains.android.dom.converters.AndroidConstraintIdsConverter;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.DimensionConverter;
import org.jetbrains.android.dom.converters.FlagConverter;
import org.jetbrains.android.dom.converters.FragmentClassConverter;
import org.jetbrains.android.dom.converters.IntegerConverter;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.converters.StaticEnumConverter;
import org.jetbrains.android.dom.converters.StringResourceAdapterConverter;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.manifest.Action;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Category;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Provider;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.dom.menu.MenuItem;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class AndroidDomUtil {
    private static final Logger LOG = Logger.getInstance(AndroidDomUtil.class);
    private static final AndroidxName RECYCLER_VIEW_LAYOUT_MANAGER_NAME = AndroidxName.of((String)"android.support.v7.widget.", (String)"RecyclerView$LayoutManager");
    private static final String[] RECYCLER_VIEW_LAYOUT_MANAGER_NAMES = new String[]{RECYCLER_VIEW_LAYOUT_MANAGER_NAME.oldName(), RECYCLER_VIEW_LAYOUT_MANAGER_NAME.newName()};
    private static final String[] RECYCLER_VIEW_LAYOUT_MANAGER_BASE_PACKAGES = new String[]{"android.support.v7.widget.", "androidx.recyclerview.widget."};
    private static final AndroidxName COORDINATOR_LAYOUT_BEHAVIOR_NAME = AndroidxName.of((String)"android.support.design.widget.", (String)"CoordinatorLayout$Behavior");
    private static final String[] COORDINATOR_LAYOUT_BEHAVIOR_NAMES = new String[]{COORDINATOR_LAYOUT_BEHAVIOR_NAME.oldName(), COORDINATOR_LAYOUT_BEHAVIOR_NAME.newName()};
    public static final StaticEnumConverter BOOLEAN_CONVERTER = new StaticEnumConverter("true", "false");
    private static final Multimap<String, ResourceType> SPECIAL_RESOURCE_TYPES = ArrayListMultimap.create();
    private static final PackageClassConverter ACTIVITY_CONVERTER = new PackageClassConverter("android.app.Activity");
    private static final Converter RECYCLER_VIEW_LAYOUT_MANAGER_CONVERTER = new StringResourceAdapterConverter(new PackageClassConverter.Builder().useManifestBasePackage(true).withExtraBasePackages(RECYCLER_VIEW_LAYOUT_MANAGER_BASE_PACKAGES).completeLibraryClasses(true).withExtendClassNames(RECYCLER_VIEW_LAYOUT_MANAGER_NAMES).build());
    private static final Converter COORDINATOR_LAYOUT_BEHAVIOR_CONVERTER = new StringResourceAdapterConverter(new PackageClassConverter.Builder().useManifestBasePackage(true).completeLibraryClasses(true).withExtendClassNames(COORDINATOR_LAYOUT_BEHAVIOR_NAMES).build());
    private static final FragmentClassConverter FRAGMENT_CLASS_CONVERTER = new FragmentClassConverter();
    private static final AndroidConstraintIdsConverter CONSTRAINT_REFERENCED_IDS_CONVERTER = new AndroidConstraintIdsConverter();
    private static final ToolsAttributeDefinitionsImpl TOOLS_ATTRIBUTE_DEFINITIONS = new ToolsAttributeDefinitionsImpl();
    public static final List<String> AVAILABLE_FAMILIES = ImmutableList.of((Object)"sans-serif", (Object)"sans-serif-thin", (Object)"sans-serif-light", (Object)"sans-serif-medium", (Object)"sans-serif-black", (Object)"sans-serif-condensed", (Object)"sans-serif-condensed-light", (Object)"sans-serif-condensed-medium", (Object)"serif", (Object)"monospace", (Object)"serif-monospace", (Object)"casual", (Object[])new String[]{"cursive", "sans-serif-smallcaps"});
    private static final boolean CHECK_THREADING = false;

    private AndroidDomUtil() {
    }

    @Nullable
    public static ResourceType getResourceType(@NotNull AttributeFormat format) {
        if (format == null) {
            AndroidDomUtil.$$$reportNull$$$0(0);
        }
        switch (format) {
            case COLOR: {
                return ResourceType.COLOR;
            }
            case DIMENSION: {
                return ResourceType.DIMEN;
            }
            case STRING: {
                return ResourceType.STRING;
            }
            case FLOAT: 
            case INTEGER: {
                return ResourceType.INTEGER;
            }
            case FRACTION: {
                return ResourceType.FRACTION;
            }
            case BOOLEAN: {
                return ResourceType.BOOL;
            }
        }
        return null;
    }

    @Nullable
    public static ResolvingConverter<String> getStringConverter(@NotNull AttributeFormat format, @NotNull String[] values) {
        if (format == null) {
            AndroidDomUtil.$$$reportNull$$$0(1);
        }
        if (values == null) {
            AndroidDomUtil.$$$reportNull$$$0(2);
        }
        switch (format) {
            case ENUM: {
                return new StaticEnumConverter(values);
            }
            case BOOLEAN: {
                return BOOLEAN_CONVERTER;
            }
            case INTEGER: {
                return IntegerConverter.INSTANCE;
            }
            case DIMENSION: {
                return DimensionConverter.INSTANCE;
            }
        }
        return null;
    }

    @Nullable
    public static ResourceReferenceConverter getResourceReferenceConverter(@NotNull AttributeDefinition attr) {
        if (attr == null) {
            AndroidDomUtil.$$$reportNull$$$0(3);
        }
        boolean containsReference = false;
        boolean containsNotReference = false;
        EnumSet<ResourceType> resourceTypes = EnumSet.noneOf(ResourceType.class);
        Set<AttributeFormat> formats = attr.getFormats();
        for (AttributeFormat format : formats) {
            ResourceType type;
            if (format == AttributeFormat.REFERENCE) {
                containsReference = true;
            } else {
                containsNotReference = true;
            }
            if ((type = AndroidDomUtil.getResourceType(format)) == null) continue;
            resourceTypes.add(type);
        }
        resourceTypes.addAll(AndroidDomUtil.getSpecialResourceTypes(attr.getName()));
        if (containsReference) {
            if (resourceTypes.contains(ResourceType.COLOR)) {
                resourceTypes.add(ResourceType.DRAWABLE);
            }
            if (resourceTypes.contains(ResourceType.DRAWABLE)) {
                resourceTypes.add(ResourceType.MIPMAP);
            }
            if (resourceTypes.isEmpty()) {
                resourceTypes.addAll((Collection<ResourceType>)ResourceType.REFERENCEABLE_TYPES);
            }
        }
        if (!resourceTypes.isEmpty()) {
            ResourceReferenceConverter converter = new ResourceReferenceConverter(resourceTypes, attr);
            converter.setAllowLiterals(containsNotReference);
            return converter;
        }
        return null;
    }

    @Nullable
    public static Converter getSpecificConverter(@NotNull XmlName attrName, DomElement context) {
        if (attrName == null) {
            AndroidDomUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            return null;
        }
        XmlTag xmlTag = context.getXmlTag();
        if (xmlTag == null) {
            return null;
        }
        String localName = attrName.getLocalName();
        String tagName = xmlTag.getName();
        if ("http://schemas.android.com/apk/res/android".equals(attrName.getNamespaceKey())) {
            if (context instanceof XmlResourceElement) {
                if ("configure".equals(localName) && "appwidget-provider".equals(tagName)) {
                    return ACTIVITY_CONVERTER;
                }
                if ("fragment".equals(localName)) {
                    return FRAGMENT_CLASS_CONVERTER;
                }
            } else if ((context instanceof LayoutViewElement || context instanceof MenuItem) && "onClick".equals(localName)) {
                return context instanceof LayoutViewElement ? OnClickConverter.CONVERTER_FOR_LAYOUT : OnClickConverter.CONVERTER_FOR_MENU;
            }
        } else {
            if (localName.equals("layoutManager") && AndroidDomUtil.isInheritor(xmlTag, SdkConstants.RECYCLER_VIEW)) {
                return RECYCLER_VIEW_LAYOUT_MANAGER_CONVERTER;
            }
            if (localName.equals("layout_behavior")) {
                XmlTag parentTag = xmlTag.getParentTag();
                if (parentTag != null && AndroidDomUtil.isInheritor(parentTag, SdkConstants.COORDINATOR_LAYOUT)) {
                    return COORDINATOR_LAYOUT_BEHAVIOR_CONVERTER;
                }
            } else if (localName.equals("constraint_referenced_ids")) {
                return CONSTRAINT_REFERENCED_IDS_CONVERTER;
            }
        }
        return null;
    }

    @Nullable
    public static ResolvingConverter getConverter(@NotNull AttributeDefinition attr) {
        if (attr == null) {
            AndroidDomUtil.$$$reportNull$$$0(5);
        }
        Set<AttributeFormat> formats = attr.getFormats();
        CompositeConverter.Builder compositeBuilder = new CompositeConverter.Builder();
        String[] values = attr.getValues();
        boolean containsUnsupportedFormats = false;
        if ("fontFamily".equals(attr.getName())) {
            compositeBuilder.addConverter(new StaticEnumConverter(AVAILABLE_FAMILIES).setContainsAllValues(false));
        }
        for (AttributeFormat format : formats) {
            ResolvingConverter<String> converter = AndroidDomUtil.getStringConverter(format, values);
            if (converter != null) {
                compositeBuilder.addConverter(converter);
                continue;
            }
            containsUnsupportedFormats = true;
        }
        if (formats.contains(AttributeFormat.FLAGS)) {
            return new FlagConverter(compositeBuilder.build(), values);
        }
        ResourceReferenceConverter resConverter = AndroidDomUtil.getResourceReferenceConverter(attr);
        if (resConverter == null && formats.contains(AttributeFormat.ENUM)) {
            resConverter = new ResourceReferenceConverter(EnumSet.of(ResourceType.INTEGER), attr);
            resConverter.setQuiet(true);
        }
        ResolvingConverter<String> stringConverter = compositeBuilder.build();
        if (resConverter != null) {
            resConverter.setAdditionalConverter(stringConverter, containsUnsupportedFormats);
            return resConverter;
        }
        return stringConverter;
    }

    @NotNull
    public static Collection<ResourceType> getSpecialResourceTypes(String attrName) {
        Collection type = SPECIAL_RESOURCE_TYPES.get((Object)attrName);
        if (!type.isEmpty()) {
            Collection collection2 = type;
            if (collection2 == null) {
                AndroidDomUtil.$$$reportNull$$$0(6);
            }
            return collection2;
        }
        if (attrName.endsWith("Animation")) {
            ImmutableList immutableList = ImmutableList.of((Object)ResourceType.ANIM);
            if (immutableList == null) {
                AndroidDomUtil.$$$reportNull$$$0(7);
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            AndroidDomUtil.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @TestOnly
    @NotNull
    public static Stream<String> getSpecialAttributeNamesByType(@NotNull ResourceType type) {
        if (type == null) {
            AndroidDomUtil.$$$reportNull$$$0(9);
        }
        Stream<String> stream = SPECIAL_RESOURCE_TYPES.entries().stream().filter(entry -> entry.getValue() == type).map(entry -> (String)entry.getKey());
        if (stream == null) {
            AndroidDomUtil.$$$reportNull$$$0(10);
        }
        return stream;
    }

    static void addSpecialResourceType(ResourceType type, String ... attrs) {
        for (String attr : attrs) {
            SPECIAL_RESOURCE_TYPES.put((Object)attr, (Object)type);
        }
    }

    public static boolean containsAction(@NotNull IntentFilter filter2, @NotNull String name) {
        if (filter2 == null) {
            AndroidDomUtil.$$$reportNull$$$0(11);
        }
        if (name == null) {
            AndroidDomUtil.$$$reportNull$$$0(12);
        }
        for (Action action2 : filter2.getActions()) {
            if (!name.equals(action2.getName().getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCategory(@NotNull IntentFilter filter2, @NotNull String name) {
        if (filter2 == null) {
            AndroidDomUtil.$$$reportNull$$$0(13);
        }
        if (name == null) {
            AndroidDomUtil.$$$reportNull$$$0(14);
        }
        for (Category category : filter2.getCategories()) {
            if (!name.equals(category.getName().getValue())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull AndroidFacet facet2, @NotNull XmlAttribute attribute) {
        if (facet2 == null) {
            AndroidDomUtil.$$$reportNull$$$0(15);
        }
        if (attribute == null) {
            AndroidDomUtil.$$$reportNull$$$0(16);
        }
        AndroidDomUtil.checkThreading();
        String localName = attribute.getLocalName();
        ResourceNamespace namespace = null;
        String namespaceUri = attribute.getNamespace();
        if (!namespaceUri.isEmpty() && (namespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri)) == null) {
            return null;
        }
        if (namespace != null) {
            AttributeDefinition definition;
            AttributeDefinitions attrDefs;
            ResourceManager manager;
            if (namespace.equals((Object)ResourceNamespace.TOOLS)) {
                namespace = ResourceNamespace.ANDROID;
                AttributeDefinition toolsAttr = TOOLS_ATTRIBUTE_DEFINITIONS.getAttrDefinition(ResourceReference.attr((ResourceNamespace)ResourceNamespace.TOOLS, (String)localName));
                if (toolsAttr != null) {
                    return toolsAttr;
                }
            }
            if ((manager = ModuleResourceManagers.getInstance(facet2).getResourceManager(null)) != null && (attrDefs = manager.getAttributeDefinitions()) != null && (definition = attrDefs.getAttrDefinition(ResourceReference.attr((ResourceNamespace)namespace, (String)localName))) != null) {
                return definition;
            }
        }
        return null;
    }

    @NotNull
    public static Collection<String> removeUnambiguousNames(@NotNull Map<String, PsiClass> viewClassMap) {
        if (viewClassMap == null) {
            AndroidDomUtil.$$$reportNull$$$0(17);
        }
        HashMap<String, String> class2Name = new HashMap<String, String>();
        for (String tagName : viewClassMap.keySet()) {
            String qName;
            String prevTagName;
            PsiClass viewClass = viewClassMap.get(tagName);
            if (AndroidUtils.isAbstract(viewClass) || (prevTagName = (String)class2Name.get(qName = viewClass.getQualifiedName())) != null && tagName.indexOf(46) >= 0) continue;
            class2Name.put(qName, tagName);
        }
        Collection<String> collection2 = class2Name.values();
        if (collection2 == null) {
            AndroidDomUtil.$$$reportNull$$$0(18);
        }
        return collection2;
    }

    @Nullable
    public static AndroidResourceReferenceBase getAndroidResourceReference(@Nullable GenericAttributeValue<ResourceValue> attribute, boolean localOnly) {
        if (attribute == null) {
            return null;
        }
        ResourceValue resValue = (ResourceValue)attribute.getValue();
        if (resValue == null || localOnly && resValue.getPackage() != null) {
            return null;
        }
        XmlAttributeValue value2 = attribute.getXmlAttributeValue();
        if (value2 == null) {
            return null;
        }
        for (PsiReference reference2 : value2.getReferences()) {
            if (!(reference2 instanceof AndroidResourceReferenceBase)) continue;
            return (AndroidResourceReferenceBase)reference2;
        }
        return null;
    }

    @Nullable
    public static AndroidAttributeValue<PsiClass> findComponentDeclarationInManifest(@NotNull PsiClass aClass) {
        AndroidFacet facet2;
        if (aClass == null) {
            AndroidDomUtil.$$$reportNull$$$0(19);
        }
        if ((facet2 = AndroidFacet.getInstance((PsiElement)aClass)) == null) {
            return null;
        }
        boolean isActivity = InheritanceUtil.isInheritor((PsiClass)aClass, (String)"android.app.Activity");
        boolean isService = InheritanceUtil.isInheritor((PsiClass)aClass, (String)"android.app.Service");
        boolean isReceiver = InheritanceUtil.isInheritor((PsiClass)aClass, (String)"android.content.BroadcastReceiver");
        boolean isProvider = InheritanceUtil.isInheritor((PsiClass)aClass, (String)"android.content.ContentProvider");
        if (!(isActivity || isService || isReceiver || isProvider)) {
            return null;
        }
        Manifest manifest = Manifest.getMainManifest(facet2);
        if (manifest == null) {
            return null;
        }
        Application application = manifest.getApplication();
        if (application == null) {
            return null;
        }
        if (isActivity) {
            for (Activity activity : application.getActivities()) {
                AndroidAttributeValue<PsiClass> activityClass = activity.getActivityClass();
                if (activityClass.getValue() != aClass) continue;
                return activityClass;
            }
        } else if (isService) {
            for (Service service : application.getServices()) {
                AndroidAttributeValue<PsiClass> serviceClass = service.getServiceClass();
                if (serviceClass.getValue() != aClass) continue;
                return serviceClass;
            }
        } else if (isReceiver) {
            for (Receiver receiver : application.getReceivers()) {
                AndroidAttributeValue<PsiClass> receiverClass = receiver.getReceiverClass();
                if (receiverClass.getValue() != aClass) continue;
                return receiverClass;
            }
        } else {
            for (Provider provider2 : application.getProviders()) {
                AndroidAttributeValue<PsiClass> providerClass = provider2.getProviderClass();
                if (providerClass.getValue() != aClass) continue;
                return providerClass;
            }
        }
        return null;
    }

    private static boolean isInheritor(@NotNull XmlTag tag, @NotNull AndroidxName baseClass) {
        String qualifiedName;
        if (tag == null) {
            AndroidDomUtil.$$$reportNull$$$0(20);
        }
        if (baseClass == null) {
            AndroidDomUtil.$$$reportNull$$$0(21);
        }
        if (StringUtil.isEmpty((String)(qualifiedName = tag.getName()))) {
            return false;
        }
        PsiClass tagClass = JavaPsiFacade.getInstance((Project)tag.getProject()).findClass(qualifiedName, tag.getResolveScope());
        return InheritanceUtil.isInheritor((PsiClass)tagClass, (String)MigrateToAndroidxUtil.getNameInProject(baseClass, tag.getProject()));
    }

    public static void checkThreading() {
    }

    static {
        AndroidDomUtil.addSpecialResourceType(ResourceType.STRING, "label", "description", "title");
        AndroidDomUtil.addSpecialResourceType(ResourceType.DRAWABLE, "icon", "src");
        AndroidDomUtil.addSpecialResourceType(ResourceType.COLOR, "src");
        AndroidDomUtil.addSpecialResourceType(ResourceType.STYLE, "theme", "style");
        AndroidDomUtil.addSpecialResourceType(ResourceType.ANIM, "animation", "showMotionSpec", "hideMotionSpec");
        AndroidDomUtil.addSpecialResourceType(ResourceType.ID, "id", "layout_toRightOf", "layout_toLeftOf", "layout_above", "layout_below", "layout_alignBaseline", "layout_alignLeft", "layout_alignTop", "layout_alignRight", "layout_alignBottom", "layout_alignStart", "layout_alignEnd", "layout_toStartOf", "layout_toEndOf", "checkedButton", "accessibilityTraversalBefore", "accessibilityTraversalAfter", "labelFor", "checkedChip", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_constraintBaseline_toBaselineOf", "layout_constraintStart_toEndOf", "layout_constraintStart_toStartOf", "layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "constraintSetStart", "constraintSetEnd", "deriveConstraintsFrom", "targetId");
        AndroidDomUtil.addSpecialResourceType(ResourceType.LAYOUT, "listitem", "layout");
        AndroidDomUtil.addSpecialResourceType(ResourceType.FONT, "fontFamily");
        AndroidDomUtil.addSpecialResourceType(ResourceType.MENU, "menu");
        AndroidDomUtil.addSpecialResourceType(ResourceType.ID, "destination");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/AndroidDomUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewClassMap";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/AndroidDomUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialResourceTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialAttributeNamesByType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "removeUnambiguousNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResourceType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStringConverter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResourceReferenceConverter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificConverter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConverter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialAttributeNamesByType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsAction";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsCategory";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeDefinition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeUnambiguousNames";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findComponentDeclarationInManifest";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

