/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import java.lang.reflect.Type;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.dom.SubtagsProcessingUtil;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDomExtender
extends DomExtender<AndroidDomElement> {
    public boolean supportsStubs() {
        return false;
    }

    @NotNull
    private static Class getValueClass(@Nullable AttributeFormat format) {
        if (format == null) {
            return String.class;
        }
        switch (format) {
            case BOOLEAN: {
                Class<Boolean> clazz = Boolean.TYPE;
                if (clazz == null) {
                    AndroidDomExtender.$$$reportNull$$$0(0);
                }
                return clazz;
            }
            case REFERENCE: 
            case DIMENSION: 
            case COLOR: {
                return ResourceValue.class;
            }
        }
        return String.class;
    }

    public void registerExtensions(@NotNull AndroidDomElement element, @NotNull DomExtensionsRegistrar registrar) {
        if (element == null) {
            AndroidDomExtender.$$$reportNull$$$0(1);
        }
        if (registrar == null) {
            AndroidDomExtender.$$$reportNull$$$0(2);
        }
        if (!AndroidDomExtender.areExtensionsKnown()) {
            return;
        }
        AndroidDomUtil.checkThreading();
        AndroidFacet facet2 = AndroidFacet.getInstance((DomElement)element);
        if (facet2 == null) {
            return;
        }
        AttributeProcessingUtil.processAttributes(element, facet2, true, (xmlName, attrDef, parentStyleableName) -> {
            Set<AttributeFormat> formats = attrDef.getFormats();
            Class valueClass = formats.size() == 1 ? AndroidDomExtender.getValueClass(formats.iterator().next()) : String.class;
            registrar.registerAttributeChildExtension(xmlName, GenericAttributeValue.class);
            return registrar.registerGenericAttributeValueChildExtension(xmlName, (Type)valueClass);
        });
        SubtagsProcessingUtil.processSubtags(facet2, element, (arg_0, arg_1) -> ((DomExtensionsRegistrar)registrar).registerCollectionChildrenExtension(arg_0, arg_1));
    }

    public static boolean areExtensionsKnown() {
        return (Boolean)StudioFlags.RUN_DOM_EXTENDER.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/AndroidDomExtender";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/AndroidDomExtender";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

