/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ExecutionStatus;
import org.jetbrains.android.util.StringBuildingOutputProcessor;
import org.jetbrains.android.util.WaitingStrategies;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public final class AndroidMavenExecutor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.tools.AndroidMavenExecutor");
    private static final String BUILD_ERROR_INDICATOR = "[error]";

    private AndroidMavenExecutor() {
    }

    public static Map<CompilerMessageCategory, List<String>> generateResources(final Module module) {
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance((Project)module.getProject());
        MavenProject mavenProject = projectsManager.findProject(module);
        final MavenRunnerParameters parameters2 = new MavenRunnerParameters(true, mavenProject.getDirectory(), mavenProject.getFile().getName(), Collections.singletonList("process-resources"), projectsManager.getExplicitProfiles());
        final HashMap<CompilerMessageCategory, List<String>> result2 = new HashMap<CompilerMessageCategory, List<String>>();
        result2.put(CompilerMessageCategory.ERROR, new ArrayList());
        try {
            StringBuildingOutputProcessor processor;
            JavaParameters javaParams = (JavaParameters)ApplicationManager.getApplication().runReadAction((Computable)new Computable<JavaParameters>(){

                @Nullable
                public JavaParameters compute() {
                    try {
                        return MavenExternalParameters.createJavaParameters((Project)module.getProject(), (MavenRunnerParameters)parameters2);
                    }
                    catch (ExecutionException e) {
                        LOG.info((Throwable)e);
                        ((List)result2.get(CompilerMessageCategory.ERROR)).add(e.getMessage());
                        return null;
                    }
                }
            });
            if (javaParams == null) {
                return result2;
            }
            GeneralCommandLine commandLine = javaParams.toCommandLine();
            boolean success2 = AndroidUtils.executeCommand(commandLine, processor = new StringBuildingOutputProcessor(), WaitingStrategies.WaitForever.getInstance()) == ExecutionStatus.SUCCESS;
            String message2 = processor.getMessage();
            if (!success2) {
                LOG.info(message2);
                String lcmessage = StringUtil.toLowerCase((String)message2);
                int buildErrorIndex = lcmessage.indexOf(BUILD_ERROR_INDICATOR);
                if (buildErrorIndex >= 0) {
                    ((List)result2.get(CompilerMessageCategory.ERROR)).add(message2.substring(buildErrorIndex));
                }
            }
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            ((List)result2.get(CompilerMessageCategory.ERROR)).add(e.getMessage());
        }
        return result2;
    }
}

