/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.tools.AndroidDxRunner;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.annotations.NotNull;

public final class AndroidDxWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.tools.AndroidDx");

    private AndroidDxWrapper() {
    }

    public static Map<AndroidCompilerMessageKind, List<String>> execute(@NotNull Module module, @NotNull IAndroidTarget target, @NotNull String outputDir, @NotNull String[] compileTargets, @NotNull String additionalVmParams, int maxHeapSize, boolean optimize) {
        BuildToolInfo buildToolInfo;
        if (module == null) {
            AndroidDxWrapper.$$$reportNull$$$0(0);
        }
        if (target == null) {
            AndroidDxWrapper.$$$reportNull$$$0(1);
        }
        if (outputDir == null) {
            AndroidDxWrapper.$$$reportNull$$$0(2);
        }
        if (compileTargets == null) {
            AndroidDxWrapper.$$$reportNull$$$0(3);
        }
        if (additionalVmParams == null) {
            AndroidDxWrapper.$$$reportNull$$$0(4);
        }
        if ((buildToolInfo = target.getBuildToolInfo()) == null) {
            return Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
        }
        String outFile = outputDir + File.separatorChar + "classes.dex";
        HashMap<AndroidCompilerMessageKind, List<String>> messages = new HashMap<AndroidCompilerMessageKind, List<String>>(2);
        messages.put(AndroidCompilerMessageKind.ERROR, new ArrayList());
        messages.put(AndroidCompilerMessageKind.INFORMATION, new ArrayList());
        messages.put(AndroidCompilerMessageKind.WARNING, new ArrayList());
        String dxJarPath = buildToolInfo.getPath(BuildToolInfo.PathId.DX_JAR);
        File dxJar = new File(dxJarPath);
        if (!dxJar.isFile()) {
            ((List)messages.get(AndroidCompilerMessageKind.ERROR)).add(AndroidBundle.message("android.file.not.exist.error", dxJarPath));
            return messages;
        }
        JavaParameters parameters2 = new JavaParameters();
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        assert (sdk != null);
        parameters2.setJdk(sdk);
        parameters2.setMainClass(AndroidDxRunner.class.getName());
        ParametersList programParamList = parameters2.getProgramParametersList();
        programParamList.add(dxJarPath);
        programParamList.add(outFile);
        programParamList.add("--optimize", Boolean.toString(optimize));
        programParamList.addAll(compileTargets);
        programParamList.add("--exclude");
        ParametersList vmParamList = parameters2.getVMParametersList();
        if (!additionalVmParams.isEmpty()) {
            vmParamList.addParametersString(additionalVmParams);
        }
        if (!AndroidBuildCommonUtils.hasXmxParam((List)vmParamList.getParameters())) {
            vmParamList.add("-Xmx" + maxHeapSize + "M");
        }
        PathsList classPath = parameters2.getClassPath();
        classPath.add(PathUtil.getJarPathForClass(AndroidDxRunner.class));
        classPath.add(PathUtil.getJarPathForClass(FileUtilRt.class));
        if (!new File(outFile).delete()) {
            LOG.info("Cannot delete file " + outFile);
        }
        try {
            parameters2.setUseDynamicClasspath(true);
            GeneralCommandLine commandLine = parameters2.toCommandLine();
            LOG.info(commandLine.getCommandLineString());
            Process process2 = commandLine.createProcess();
            AndroidBuildCommonUtils.handleDexCompilationResult((Process)process2, (String)commandLine.getCommandLineString(), (String)outFile, messages, (boolean)false);
        }
        catch (ExecutionException e) {
            ((List)messages.get(AndroidCompilerMessageKind.ERROR)).add("ExecutionException: " + e.getMessage());
            LOG.info((Throwable)e);
            return messages;
        }
        return messages;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "outputDir";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "compileTargets";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "additionalVmParams";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/android/compiler/tools/AndroidDxWrapper";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

