/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidFinalPackageElementType
extends PackagingElementType<AndroidFinalPackageElement> {
    @NonNls
    public static final String TYPE_ID = "android-final-package";

    protected AndroidFinalPackageElementType() {
        super(TYPE_ID, AndroidBundle.messagePointer("android.final.package.element.type.name", new Object[0]));
    }

    public static AndroidFinalPackageElementType getInstance() {
        return (AndroidFinalPackageElementType)AndroidFinalPackageElementType.getInstance(AndroidFinalPackageElementType.class);
    }

    public Icon getCreateElementIcon() {
        return AndroidIcons.Android;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            AndroidFinalPackageElementType.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            AndroidFinalPackageElementType.$$$reportNull$$$0(1);
        }
        return !AndroidFinalPackageElementType.getAndroidApplicationFacets(context, context.getModulesProvider().getModules()).isEmpty() && !AndroidArtifactUtil.containsAndroidPackage(context, artifact);
    }

    @NotNull
    private static List<AndroidFacet> getAndroidApplicationFacets(@NotNull ArtifactEditorContext context, @NotNull Module[] modules) {
        if (context == null) {
            AndroidFinalPackageElementType.$$$reportNull$$$0(2);
        }
        if (modules == null) {
            AndroidFinalPackageElementType.$$$reportNull$$$0(3);
        }
        ArrayList<AndroidFacet> result2 = new ArrayList<AndroidFacet>();
        for (Module module : modules) {
            for (AndroidFacet facet2 : context.getFacetsProvider().getFacetsByType(module, AndroidFacet.ID)) {
                if (!((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) continue;
                result2.add(facet2);
            }
        }
        ArrayList<AndroidFacet> arrayList = result2;
        if (arrayList == null) {
            AndroidFinalPackageElementType.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            AndroidFinalPackageElementType.$$$reportNull$$$0(5);
        }
        if (artifact == null) {
            AndroidFinalPackageElementType.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            AndroidFinalPackageElementType.$$$reportNull$$$0(7);
        }
        List<AndroidFacet> facets = AndroidFinalPackageElementType.getAndroidApplicationFacets(context, context.getModulesProvider().getModules());
        AndroidFacet facet2 = AndroidArtifactUtil.chooseAndroidApplicationModule(context.getProject(), facets);
        if (facet2 == null) {
            List list = Collections.emptyList();
            if (list == null) {
                AndroidFinalPackageElementType.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<AndroidFinalPackageElement> list = Collections.singletonList(new AndroidFinalPackageElement(context.getProject(), facet2));
        if (list == null) {
            AndroidFinalPackageElementType.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public AndroidFinalPackageElement createEmpty(@NotNull Project project) {
        if (project == null) {
            AndroidFinalPackageElementType.$$$reportNull$$$0(10);
        }
        return new AndroidFinalPackageElement(project, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/artifact/AndroidFinalPackageElementType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidApplicationFacets";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAndCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidApplicationFacets";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndCreate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEmpty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

