/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleSourceAutogenerating {
    private final Set<AndroidAutogeneratorMode> myDirtyModes;
    private Sdk myPrevSdk;
    @GuardedBy(value="myAutogeneratedFiles")
    private final Map<AndroidAutogeneratorMode, Set<String>> myAutogeneratedFiles;

    @Nullable
    public static ModuleSourceAutogenerating getInstance(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(0);
        }
        return (ModuleSourceAutogenerating)facet2.getModule().getService(ModuleSourceAutogenerating.class);
    }

    private ModuleSourceAutogenerating(final @NotNull Module module) {
        if (module == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(1);
        }
        this.myDirtyModes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
        this.myAutogeneratedFiles = new HashMap<AndroidAutogeneratorMode, Set<String>>();
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 == null) {
            throw new IllegalArgumentException(module.getName() + " is not an Android module");
        }
        if (!ModuleSourceAutogenerating.requiresAutoSourceGeneration(facet2)) {
            throw new IllegalArgumentException(module.getName() + " is built by an external build system and should not require the IDE to generate sources");
        }
        this.scheduleSourceRegenerating(AndroidAutogeneratorMode.AIDL);
        this.scheduleSourceRegenerating(AndroidAutogeneratorMode.RENDERSCRIPT);
        this.scheduleSourceRegenerating(AndroidAutogeneratorMode.BUILDCONFIG);
        this.myPrevSdk = ModuleRootManager.getInstance((Module)module).getSdk();
        module.getMessageBus().connect((Disposable)facet2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Sdk newSdk;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((newSdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && newSdk.getSdkType() instanceof AndroidSdkType && !newSdk.equals(ModuleSourceAutogenerating.this.myPrevSdk)) {
                    ModuleSourceAutogenerating.this.myPrevSdk = newSdk;
                    ModuleSourceAutogenerating.this.resetRegeneratingState();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/compiler/ModuleSourceAutogenerating$1", "rootsChanged"));
            }
        });
    }

    public static boolean requiresAutoSourceGeneration(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(2);
        }
        return !AndroidModel.isRequired(facet2) && ApkFacet.getInstance(facet2.getModule()) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGeneratedFileRemoved(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(3);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        synchronized (map2) {
            Set<String> filePaths = this.myAutogeneratedFiles.get((Object)mode);
            if (filePaths != null) {
                for (String path2 : filePaths) {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path2);
                    if (file != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(4);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        synchronized (map2) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set != null) {
                set.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileAutogenerated(@NotNull AndroidAutogeneratorMode mode, @NotNull VirtualFile file) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(6);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        synchronized (map2) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set == null) {
                set = new HashSet<String>();
                this.myAutogeneratedFiles.put(mode, set);
            }
            set.add(file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<String> getAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(7);
        }
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        // MONITORENTER : map2
        Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
        HashSet<String> hashSet = set != null ? new HashSet<String>(set) : Collections.emptySet();
        // MONITOREXIT : map2
        if (hashSet != null) return hashSet;
        ModuleSourceAutogenerating.$$$reportNull$$$0(8);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSourceRegenerating(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(9);
        }
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            this.myDirtyModes.add(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanRegeneratingState(@NotNull AndroidAutogeneratorMode mode) {
        if (mode == null) {
            ModuleSourceAutogenerating.$$$reportNull$$$0(10);
        }
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            return this.myDirtyModes.remove((Object)mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRegeneratingState() {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            Collections.addAll(this.myDirtyModes, AndroidAutogeneratorMode.values());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/ModuleSourceAutogenerating";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/ModuleSourceAutogenerating";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutogeneratedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "requiresAutoSourceGeneration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedFileRemoved";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearAutogeneratedFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markFileAutogenerated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAutogeneratedFiles";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "scheduleSourceRegenerating";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cleanRegeneratingState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

