/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.lang.aidl.AidlFileType;
import com.android.tools.idea.lang.rs.AndroidRenderscriptFileType;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.Facet;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.compiler.AndroidAutogenerator;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.ProguardRunningOptions;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesProvider;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class AndroidCompileUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidCompileUtil");
    private static final Key<Boolean> RELEASE_BUILD_KEY = new Key("RELEASE_BUILD_KEY");
    @NonNls
    private static final String RESOURCES_CACHE_DIR_NAME = "res-cache";
    @NonNls
    private static final String GEN_MODULE_PREFIX = "~generated_";
    @NonNls
    public static final String OLD_PROGUARD_CFG_FILE_NAME = "proguard.cfg";
    public static final String UNSIGNED_SUFFIX = ".unsigned";
    public static Key<String> PROGUARD_CFG_PATHS_KEY = Key.create((String)"ANDROID_PROGUARD_CFG_PATHS");

    private AndroidCompileUtil() {
    }

    @NotNull
    public static <T> Map<CompilerMessageCategory, T> toCompilerMessageCategoryKeys(@NotNull Map<AndroidCompilerMessageKind, T> map2) {
        if (map2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(0);
        }
        HashMap<CompilerMessageCategory, T> result2 = new HashMap<CompilerMessageCategory, T>();
        for (Map.Entry<AndroidCompilerMessageKind, T> entry : map2.entrySet()) {
            AndroidCompilerMessageKind key = entry.getKey();
            T value2 = entry.getValue();
            switch (key) {
                case ERROR: {
                    result2.put(CompilerMessageCategory.ERROR, value2);
                    break;
                }
                case INFORMATION: {
                    result2.put(CompilerMessageCategory.INFORMATION, value2);
                    break;
                }
                case WARNING: {
                    result2.put(CompilerMessageCategory.WARNING, value2);
                }
            }
        }
        HashMap<CompilerMessageCategory, T> hashMap = result2;
        if (hashMap == null) {
            AndroidCompileUtil.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @Nullable
    public static Pair<VirtualFile, Boolean> getDefaultProguardConfigFile(@NotNull AndroidFacet facet2) {
        VirtualFile root2;
        if (facet2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(2);
        }
        if ((root2 = AndroidRootUtil.getMainContentRoot(facet2)) == null) {
            return null;
        }
        VirtualFile proguardCfg = root2.findChild("proguard-project.txt");
        if (proguardCfg != null) {
            return new Pair((Object)proguardCfg, (Object)true);
        }
        VirtualFile oldProguardCfg = root2.findChild(OLD_PROGUARD_CFG_FILE_NAME);
        if (oldProguardCfg != null) {
            return new Pair((Object)oldProguardCfg, (Object)false);
        }
        return null;
    }

    public static void addMessages(CompileContext context, Map<CompilerMessageCategory, List<String>> messages, @Nullable Module module) {
        AndroidCompileUtil.addMessages(context, messages, null, module);
    }

    static void addMessages(final CompileContext context, final Map<CompilerMessageCategory, List<String>> messages, final @Nullable Map<VirtualFile, VirtualFile> presentableFilesMap, final @Nullable Module module) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (context.getProject().isDisposed()) {
                    return;
                }
                for (CompilerMessageCategory category : messages.keySet()) {
                    List messageList = (List)messages.get(category);
                    for (String message2 : messageList) {
                        String fileName;
                        String url = null;
                        int line = -1;
                        Matcher matcher = AndroidBuildCommonUtils.COMPILER_MESSAGE_PATTERN.matcher(message2);
                        if (matcher.matches() && new File(fileName = matcher.group(1)).exists()) {
                            url = AndroidCompileUtil.getPresentableFile("file://" + fileName, presentableFilesMap);
                            line = Integer.parseInt(matcher.group(2));
                        }
                        context.addMessage(category, (String)(module != null ? "[" + module.getName() + "] " : "") + message2, url, line, -1);
                    }
                }
            }
        });
    }

    @NotNull
    private static String getPresentableFile(@NotNull String url, @Nullable Map<VirtualFile, VirtualFile> presentableFilesMap) {
        VirtualFile file;
        if (url == null) {
            AndroidCompileUtil.$$$reportNull$$$0(3);
        }
        if ((file = VirtualFileManager.getInstance().findFileByUrl(url)) == null) {
            String string = url;
            if (string == null) {
                AndroidCompileUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (presentableFilesMap == null) {
            String string = url;
            if (string == null) {
                AndroidCompileUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        for (Map.Entry<VirtualFile, VirtualFile> entry : presentableFilesMap.entrySet()) {
            if (!Comparing.equal((Object)file, (Object)entry.getValue())) continue;
            String string = entry.getKey().getUrl();
            if (string == null) {
                AndroidCompileUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            AndroidCompileUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static void collectChildrenRecursively(@NotNull VirtualFile root2, @NotNull VirtualFile anchor, @NotNull Collection<VirtualFile> result2) {
        if (root2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(8);
        }
        if (anchor == null) {
            AndroidCompileUtil.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(10);
        }
        if (Comparing.equal((Object)root2, (Object)anchor)) {
            return;
        }
        VirtualFile parent = anchor.getParent();
        if (parent == null) {
            return;
        }
        for (VirtualFile child : parent.getChildren()) {
            if (Comparing.equal((Object)child, (Object)anchor)) continue;
            result2.add(child);
        }
        if (!Comparing.equal((Object)parent, (Object)root2)) {
            AndroidCompileUtil.collectChildrenRecursively(root2, parent, result2);
        }
    }

    private static void unexcludeRootIfNecessary(@NotNull VirtualFile root2, @NotNull ModifiableRootModel model2, @NotNull Ref<Boolean> modelChangedFlag) {
        VirtualFile excludedRoot;
        if (root2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(11);
        }
        if (model2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(12);
        }
        if (modelChangedFlag == null) {
            AndroidCompileUtil.$$$reportNull$$$0(13);
        }
        HashSet<VirtualFile> excludedRoots = new HashSet<VirtualFile>(Arrays.asList(model2.getExcludeRoots()));
        for (excludedRoot = root2; excludedRoot != null && !excludedRoots.contains(excludedRoot); excludedRoot = excludedRoot.getParent()) {
        }
        if (excludedRoot == null) {
            return;
        }
        HashSet<VirtualFile> rootsToExclude = new HashSet<VirtualFile>();
        AndroidCompileUtil.collectChildrenRecursively(excludedRoot, root2, rootsToExclude);
        ContentEntry contentEntry = AndroidCompileUtil.findContentEntryForRoot(model2, excludedRoot);
        if (contentEntry != null) {
            if (contentEntry.removeExcludeFolder(excludedRoot.getUrl())) {
                modelChangedFlag.set((Object)true);
            }
            for (VirtualFile rootToExclude : rootsToExclude) {
                if (excludedRoots.contains(rootToExclude)) continue;
                contentEntry.addExcludeFolder(rootToExclude);
                modelChangedFlag.set((Object)true);
            }
        }
    }

    @NotNull
    private static String getGenModuleName(@NotNull Module module) {
        if (module == null) {
            AndroidCompileUtil.$$$reportNull$$$0(14);
        }
        String string = GEN_MODULE_PREFIX + module.getName();
        if (string == null) {
            AndroidCompileUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    public static VirtualFile createSourceRootIfNotExist(@NotNull String path2, @NotNull ModifiableRootModel model2, @NotNull Ref<Boolean> modelChangedFlag) {
        boolean created;
        if (path2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(16);
        }
        if (model2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(17);
        }
        if (modelChangedFlag == null) {
            AndroidCompileUtil.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        File rootFile = new File(path2);
        if (!rootFile.exists()) {
            if (!rootFile.mkdirs()) {
                return null;
            }
            created = true;
        } else {
            created = false;
        }
        Module module = model2.getModule();
        Project project = module.getProject();
        if (project.isDisposed() || module.isDisposed()) {
            return null;
        }
        VirtualFile root2 = created ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(rootFile) : LocalFileSystem.getInstance().findFileByIoFile(rootFile);
        if (root2 != null) {
            AndroidCompileUtil.unexcludeRootIfNecessary(root2, model2, modelChangedFlag);
            boolean markedAsSource = false;
            for (VirtualFile existingRoot : model2.getSourceRoots()) {
                if (!Comparing.equal((Object)existingRoot, (Object)root2)) continue;
                markedAsSource = true;
                break;
            }
            if (markedAsSource) {
                AndroidCompileUtil.markRootAsGenerated(model2, root2, modelChangedFlag);
            } else {
                AndroidCompileUtil.addSourceRoot(model2, root2);
                modelChangedFlag.set((Object)true);
            }
        }
        return root2;
    }

    private static void markRootAsGenerated(ModifiableRootModel model2, VirtualFile root2, Ref<Boolean> modelChangedFlag) {
        ContentEntry contentEntry = AndroidCompileUtil.findContentEntryForRoot(model2, root2);
        if (contentEntry == null) {
            return;
        }
        for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
            JavaSourceRootProperties props;
            if (!root2.equals(sourceFolder.getFile()) || (props = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) == null) continue;
            props.setForGeneratedSources(true);
            modelChangedFlag.set((Object)true);
            break;
        }
    }

    private static void excludeFromCompilation(@NotNull Project project, @NotNull VirtualFile sourceRoot, @NotNull String aPackage) {
        if (project == null) {
            AndroidCompileUtil.$$$reportNull$$$0(19);
        }
        if (sourceRoot == null) {
            AndroidCompileUtil.$$$reportNull$$$0(20);
        }
        if (aPackage == null) {
            AndroidCompileUtil.$$$reportNull$$$0(21);
        }
        String buildConfigPath = sourceRoot.getPath() + "/" + aPackage.replace('.', '/') + "/BuildConfig.java";
        String url = VfsUtilCore.pathToUrl((String)buildConfigPath);
        ExcludesConfiguration configuration = CompilerConfiguration.getInstance((Project)project).getExcludedEntriesConfiguration();
        for (ExcludeEntryDescription description : configuration.getExcludeEntryDescriptions()) {
            if (!Objects.equals(description.getUrl(), url)) continue;
            return;
        }
        configuration.addExcludeEntryDescription(new ExcludeEntryDescription(url, true, false, (Disposable)project));
    }

    private static void excludeFromCompilation(@NotNull Project project, @NotNull VirtualFile dir) {
        if (project == null) {
            AndroidCompileUtil.$$$reportNull$$$0(22);
        }
        if (dir == null) {
            AndroidCompileUtil.$$$reportNull$$$0(23);
        }
        ExcludesConfiguration configuration = CompilerConfiguration.getInstance((Project)project).getExcludedEntriesConfiguration();
        for (ExcludeEntryDescription description : configuration.getExcludeEntryDescriptions()) {
            if (!Comparing.equal((Object)description.getVirtualFile(), (Object)dir)) continue;
            return;
        }
        configuration.addExcludeEntryDescription(new ExcludeEntryDescription(dir, true, false, (Disposable)project));
    }

    private static void removeGenModule(@NotNull ModifiableRootModel model2, @NotNull Ref<Boolean> modelChangedFlag) {
        if (model2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(24);
        }
        if (modelChangedFlag == null) {
            AndroidCompileUtil.$$$reportNull$$$0(25);
        }
        String genModuleName = AndroidCompileUtil.getGenModuleName(model2.getModule());
        final Project project = model2.getProject();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module genModule = moduleManager.findModuleByName(genModuleName);
        if (genModule == null) {
            return;
        }
        for (OrderEntry entry : model2.getOrderEntries()) {
            if (!(entry instanceof ModuleOrderEntry) || !genModuleName.equals(((ModuleOrderEntry)entry).getModuleName())) continue;
            model2.removeOrderEntry(entry);
            modelChangedFlag.set((Object)true);
        }
        final VirtualFile moduleFile = genModule.getModuleFile();
        moduleManager.disposeModule(genModule);
        if (moduleFile != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                moduleFile.delete((Object)project);
                            }
                            catch (IOException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
    }

    @Nullable
    public static SourceFolder addSourceRoot(final ModifiableRootModel model2, @NotNull VirtualFile root2) {
        ContentEntry contentEntry;
        if (root2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(26);
        }
        if ((contentEntry = AndroidCompileUtil.findContentEntryForRoot(model2, root2)) == null) {
            final Project project = model2.getProject();
            String message2 = "Cannot mark directory '" + FileUtil.toSystemDependentName((String)root2.getPath()) + "' as source root, because it is not located under content root of module '" + model2.getModule().getName() + "'\n<a href='fix'>Open Project Structure</a>";
            Notification notification = new Notification(NotificationGroup.createIdWithTitle((String)"Android Autogeneration", (String)AndroidBundle.message("android.autogeneration.notification.group", new Object[0])), "Autogeneration Error", message2, NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    notification.expire();
                    final ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance((Project)project);
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, new Runnable(){

                        @Override
                        public void run() {
                            Module module = model2.getModule();
                            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
                            if (facet2 != null) {
                                configurable.select((Facet)facet2, true);
                            }
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/android/compiler/AndroidCompileUtil$3";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            Notifications.Bus.notify((Notification)notification, (Project)project);
            LOG.debug(message2);
            return null;
        }
        return contentEntry.addSourceFolder(root2, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, (JpsElement)JpsJavaExtensionService.getInstance().createSourceRootProperties("", true));
    }

    @Nullable
    public static ContentEntry findContentEntryForRoot(@NotNull ModifiableRootModel model2, @NotNull VirtualFile root2) {
        if (model2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(27);
        }
        if (root2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(28);
        }
        ContentEntry contentEntry = null;
        for (ContentEntry candidate : model2.getContentEntries()) {
            VirtualFile contentRoot = candidate.getFile();
            if (contentRoot == null || !VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)root2, (boolean)false)) continue;
            contentEntry = candidate;
        }
        return contentEntry;
    }

    public static boolean doGenerate(AndroidFacet facet2, AndroidAutogeneratorMode mode) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        final CompileContext[] contextWrapper = new CompileContext[1];
        final Module module = facet2.getModule();
        final Project project = module.getProject();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                CompilerTask task2 = new CompilerTask(project, "Android auto-generation", true, false, true, true);
                ModuleCompileScope scope = new ModuleCompileScope(module, false);
                contextWrapper[0] = new CompileContextImpl(project, task2, (CompileScope)scope, false, false);
            }
        });
        CompileContext context = contextWrapper[0];
        if (context == null) {
            return false;
        }
        AndroidCompileUtil.generate(facet2, mode, context, false);
        return context.getMessages(CompilerMessageCategory.ERROR).length == 0;
    }

    public static boolean isModuleAffected(CompileContext context, Module module) {
        return ArrayUtilRt.find((Object[])context.getCompileScope().getAffectedModules(), (Object)module) >= 0;
    }

    public static void generate(AndroidFacet facet2, AndroidAutogeneratorMode mode, CompileContext context, boolean force) {
        if (context == null) {
            return;
        }
        AndroidAutogenerator.run(mode, facet2, context, force);
    }

    public static void removeDuplicatingClasses(Module module, @NotNull String packageName, @NotNull String className, @Nullable File classFile, String sourceRootPath) {
        if (packageName == null) {
            AndroidCompileUtil.$$$reportNull$$$0(29);
        }
        if (className == null) {
            AndroidCompileUtil.$$$reportNull$$$0(30);
        }
        if (sourceRootPath == null) {
            return;
        }
        VirtualFile sourceRoot = LocalFileSystem.getInstance().findFileByPath(sourceRootPath);
        if (sourceRoot == null) {
            return;
        }
        final Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        String interfaceQualifiedName = packageName + "." + className;
        PsiClass[] classes2 = facade.findClasses(interfaceQualifiedName, GlobalSearchScope.moduleScope((Module)module));
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiClass c : classes2) {
            File f;
            VirtualFile virtualFile;
            PsiFile psiFile2 = c.getContainingFile();
            if (!className.equals(FileUtil.getNameWithoutExtension((String)psiFile2.getName())) || (virtualFile = psiFile2.getVirtualFile()) == null || !Comparing.equal((Object)projectFileIndex.getSourceRootForFile(virtualFile), (Object)sourceRoot) || FileUtil.filesEqual((File)(f = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile)), (File)classFile) || !f.exists()) continue;
            if (f.delete()) {
                virtualFile.refresh(true, false);
                continue;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)("Can't delete file " + virtualFile.getPresentableUrl()), (String)CommonBundle.getErrorTitle());
                }
            }, project.getDisposed());
        }
    }

    @Nullable
    public static String findResourcesCacheDirectory(@NotNull Module module, boolean createIfNotFound, @Nullable CompileContext context) {
        Project project;
        CompilerProjectExtension extension;
        if (module == null) {
            AndroidCompileUtil.$$$reportNull$$$0(31);
        }
        if ((extension = CompilerProjectExtension.getInstance((Project)(project = module.getProject()))) == null) {
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot get compiler settings for project " + project.getName(), null, -1, -1);
            }
            return null;
        }
        String projectOutputDirUrl = extension.getCompilerOutputUrl();
        if (projectOutputDirUrl == null) {
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot find output directory for project " + project.getName(), null, -1, -1);
            }
            return null;
        }
        String pngCacheDirPath = VfsUtil.urlToPath((String)projectOutputDirUrl) + "/res-cache/" + module.getName();
        String pngCacheDirOsPath = FileUtil.toSystemDependentName((String)pngCacheDirPath);
        File pngCacheDir = new File(pngCacheDirOsPath);
        if (pngCacheDir.exists()) {
            if (pngCacheDir.isDirectory()) {
                return pngCacheDirOsPath;
            }
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot create directory " + pngCacheDirOsPath + " because file already exists", null, -1, -1);
            }
            return null;
        }
        if (!createIfNotFound) {
            return null;
        }
        if (!pngCacheDir.mkdirs()) {
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot create directory " + pngCacheDirOsPath, null, -1, -1);
            }
            return null;
        }
        return pngCacheDirOsPath;
    }

    public static boolean isFullBuild(@NotNull CompileContext context) {
        if (context == null) {
            AndroidCompileUtil.$$$reportNull$$$0(32);
        }
        return AndroidCompileUtil.isFullBuild(context.getCompileScope());
    }

    public static boolean isFullBuild(@NotNull CompileScope scope) {
        RunConfiguration c;
        if (scope == null) {
            AndroidCompileUtil.$$$reportNull$$$0(33);
        }
        return (c = CompileStepBeforeRun.getRunConfiguration((CompileScope)scope)) == null || !AndroidBuildCommonUtils.isTestConfiguration((String)c.getType().getId());
    }

    public static boolean isReleaseBuild(@NotNull CompileContext context) {
        Boolean value2;
        if (context == null) {
            AndroidCompileUtil.$$$reportNull$$$0(34);
        }
        if ((value2 = (Boolean)context.getCompileScope().getUserData(RELEASE_BUILD_KEY)) != null && value2.booleanValue()) {
            return true;
        }
        Project project = context.getProject();
        Set artifacts = ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)context.getCompileScope(), (boolean)false);
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                AndroidArtifactSigningMode signingMode;
                ArtifactProperties properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance());
                if (!(properties instanceof AndroidApplicationArtifactProperties) || (signingMode = ((AndroidApplicationArtifactProperties)properties).getSigningMode()) == AndroidArtifactSigningMode.DEBUG || signingMode == AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) continue;
                return true;
            }
        }
        return false;
    }

    public static void setReleaseBuild(@NotNull CompileScope compileScope) {
        if (compileScope == null) {
            AndroidCompileUtil.$$$reportNull$$$0(35);
        }
        compileScope.putUserData(RELEASE_BUILD_KEY, (Object)Boolean.TRUE);
    }

    public static boolean createGenModulesAndSourceRoots(@NotNull AndroidFacet facet2, @NotNull ModifiableRootModel model2) {
        String aidlGenRootPath;
        String aptGenRootPath;
        String renderscriptGenRootPath;
        if (facet2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(36);
        }
        if (model2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(37);
        }
        if (AndroidModel.isRequired(facet2) || !facet2.getProperties().ENABLE_SOURCES_AUTOGENERATION) {
            return false;
        }
        GlobalSearchScope moduleScope = facet2.getModule().getModuleScope();
        Ref modelChangedFlag = Ref.create((Object)false);
        if (((AndroidFacetConfiguration)facet2.getConfiguration()).isLibraryProject()) {
            AndroidCompileUtil.removeGenModule(model2, (Ref<Boolean>)modelChangedFlag);
        }
        HashSet<String> genRootsToCreate = new HashSet<String>();
        HashSet<String> genRootsToInit = new HashSet<String>();
        String buildConfigGenRootPath = AndroidRootUtil.getBuildconfigGenSourceRootPath(facet2);
        if (buildConfigGenRootPath != null) {
            genRootsToCreate.add(buildConfigGenRootPath);
        }
        if ((renderscriptGenRootPath = AndroidRootUtil.getRenderscriptGenSourceRootPath(facet2)) != null) {
            boolean createIfNotExist = !FileTypeIndex.getFiles((FileType)AndroidRenderscriptFileType.INSTANCE, (GlobalSearchScope)moduleScope).isEmpty();
            (createIfNotExist ? genRootsToCreate : genRootsToInit).add(renderscriptGenRootPath);
        }
        if ((aptGenRootPath = AndroidRootUtil.getAptGenSourceRootPath(facet2)) != null) {
            genRootsToCreate.add(aptGenRootPath);
        }
        if ((aidlGenRootPath = AndroidRootUtil.getAidlGenSourceRootPath(facet2)) != null) {
            boolean createIfNotExist = !FileTypeIndex.getFiles((FileType)AidlFileType.INSTANCE, (GlobalSearchScope)moduleScope).isEmpty();
            (createIfNotExist ? genRootsToCreate : genRootsToInit).add(aidlGenRootPath);
        }
        genRootsToInit.addAll(genRootsToCreate);
        for (String genRootPath : genRootsToInit) {
            AndroidCompileUtil.initializeGenSourceRoot(model2, genRootPath, genRootsToCreate.contains(genRootPath), true, (Ref<Boolean>)modelChangedFlag);
        }
        return (Boolean)modelChangedFlag.get();
    }

    private static void excludeAllBuildConfigsFromCompilation(AndroidFacet facet2, VirtualFile sourceRoot) {
        String aPackage;
        Module module = facet2.getModule();
        Project project = module.getProject();
        HashSet<String> packages = new HashSet<String>();
        Manifest manifest = Manifest.getMainManifest(facet2);
        String string = aPackage = manifest != null ? manifest.getPackage().getStringValue() : null;
        if (aPackage != null) {
            packages.add(aPackage);
        }
        packages.addAll(AndroidUtils.getDepLibsPackages(module));
        for (String p : packages) {
            AndroidCompileUtil.excludeFromCompilation(project, sourceRoot, p);
        }
    }

    private static void includeAaptGenSourceRootToCompilation(AndroidFacet facet2) {
        Project project = facet2.getModule().getProject();
        ExcludesConfiguration configuration = ((CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project)).getExcludedEntriesConfiguration();
        ExcludeEntryDescription[] descriptions = configuration.getExcludeEntryDescriptions();
        configuration.removeAllExcludeEntryDescriptions();
        for (ExcludeEntryDescription description : descriptions) {
            VirtualFile vFile = description.getVirtualFile();
            if (Comparing.equal((Object)vFile, (Object)AndroidRootUtil.getAaptGenDir(facet2))) continue;
            configuration.addExcludeEntryDescription(description);
        }
    }

    @Nullable
    private static VirtualFile initializeGenSourceRoot(@NotNull ModifiableRootModel model2, @Nullable String sourceRootPath, boolean createIfNotExist, boolean excludeInNonExternalMode, @NotNull Ref<Boolean> modelChangedFlag) {
        VirtualFile root2;
        if (model2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(38);
        }
        if (modelChangedFlag == null) {
            AndroidCompileUtil.$$$reportNull$$$0(39);
        }
        if (sourceRootPath == null) {
            return null;
        }
        VirtualFile sourceRoot = null;
        if (createIfNotExist && (root2 = AndroidCompileUtil.createSourceRootIfNotExist(sourceRootPath, model2, modelChangedFlag)) != null) {
            sourceRoot = root2;
        }
        if (sourceRoot == null) {
            sourceRoot = LocalFileSystem.getInstance().findFileByPath(sourceRootPath);
        }
        if (sourceRoot != null && excludeInNonExternalMode) {
            Module module = model2.getModule();
            CompilerWorkspaceConfiguration compilerWorkspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)module.getProject());
        }
        return sourceRoot;
    }

    @NotNull
    public static String[] toOsPaths(@NotNull VirtualFile[] classFilesDirs) {
        if (classFilesDirs == null) {
            AndroidCompileUtil.$$$reportNull$$$0(40);
        }
        String[] classFilesDirOsPaths = new String[classFilesDirs.length];
        for (int i2 = 0; i2 < classFilesDirs.length; ++i2) {
            classFilesDirOsPaths[i2] = FileUtil.toSystemDependentName((String)classFilesDirs[i2].getPath());
        }
        if (classFilesDirOsPaths == null) {
            AndroidCompileUtil.$$$reportNull$$$0(41);
        }
        return classFilesDirOsPaths;
    }

    @NotNull
    public static Map<CompilerMessageCategory, List<String>> execute(String ... argv) throws IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        Map messages = AndroidExecutionUtil.doExecute((String[])argv);
        return AndroidCompileUtil.toCompilerMessageCategoryKeys(messages);
    }

    public static String getApkName(Module module) {
        return module.getName() + ".apk";
    }

    @Nullable
    public static String getOutputPackage(@NotNull Module module) {
        VirtualFile compilerOutput;
        if (module == null) {
            AndroidCompileUtil.$$$reportNull$$$0(42);
        }
        if ((compilerOutput = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath()) == null) {
            return null;
        }
        return new File(compilerOutput.getPath(), AndroidCompileUtil.getApkName(module)).getPath();
    }

    public static boolean isExcludedFromCompilation(@NotNull File file, @Nullable Project project) {
        VirtualFile vFile;
        if (file == null) {
            AndroidCompileUtil.$$$reportNull$$$0(43);
        }
        return (vFile = LocalFileSystem.getInstance().findFileByIoFile(file)) != null && AndroidCompileUtil.isExcludedFromCompilation(vFile, project);
    }

    public static boolean isExcludedFromCompilation(VirtualFile child, @Nullable Project project) {
        CompilerManager compilerManager;
        CompilerManager compilerManager2 = compilerManager = project != null ? CompilerManager.getInstance((Project)project) : null;
        if (compilerManager == null) {
            return false;
        }
        if (!compilerManager.isExcludedFromCompilation(child)) {
            return false;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)child, (Project)project);
        if (module == null) {
            return true;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 == null || ((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()) {
            return true;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(facet2.getModule());
        if (platform == null) {
            return true;
        }
        return platform.getSdkData().getPlatformToolsRevision() > 7;
    }

    @Nullable
    public static ProguardRunningOptions getProguardConfigFilePathIfShouldRun(@NotNull AndroidFacet facet2, CompileContext context) {
        String[] paths;
        String pathsStr;
        if (facet2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(44);
        }
        if ((pathsStr = (String)context.getCompileScope().getUserData(PROGUARD_CFG_PATHS_KEY)) != null && (paths = pathsStr.split(File.pathSeparator)).length > 0) {
            return new ProguardRunningOptions(Arrays.asList(paths));
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(facet2.getModule());
        String sdkHomePath = platform != null ? FileUtil.toCanonicalPath((String)platform.getSdkData().getPath()) : null;
        Project project = context.getProject();
        Set artifacts = ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)context.getCompileScope(), (boolean)false);
        for (Artifact artifact : artifacts) {
            AndroidApplicationArtifactProperties p;
            ArtifactProperties properties;
            if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType) || !facet2.equals((Object)AndroidArtifactUtil.getPackagedFacet(project, artifact)) || !((properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance())) instanceof AndroidApplicationArtifactProperties) || !(p = (AndroidApplicationArtifactProperties)properties).isRunProGuard()) continue;
            List<String> paths2 = AndroidUtils.urlsToOsPaths(p.getProGuardCfgFiles(), sdkHomePath);
            return new ProguardRunningOptions(paths2);
        }
        AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet2.getConfiguration();
        AndroidFacetProperties properties = configuration.getState();
        if (properties != null && properties.RUN_PROGUARD) {
            List urls = properties.myProGuardCfgFiles;
            List<String> paths3 = AndroidUtils.urlsToOsPaths(urls, sdkHomePath);
            return new ProguardRunningOptions(paths3);
        }
        return null;
    }

    @Nullable
    public static Module findCircularDependencyOnLibraryWithSamePackage(@NotNull AndroidFacet facet2) {
        Manifest manifest;
        String aPackage;
        if (facet2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(45);
        }
        String string = aPackage = (manifest = Manifest.getMainManifest(facet2)) != null ? (String)manifest.getPackage().getValue() : null;
        if (aPackage == null) {
            return null;
        }
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(facet2.getModule(), true)) {
            List<AndroidFacet> depDependencies;
            Manifest depManifest = Manifest.getMainManifest(depFacet);
            String depPackage = depManifest != null ? (String)depManifest.getPackage().getValue() : null;
            if (!aPackage.equals(depPackage) || !(depDependencies = AndroidUtils.getAllAndroidDependencies(depFacet.getModule(), false)).contains(facet2)) continue;
            return depFacet.getModule();
        }
        return null;
    }

    @NotNull
    public static String[] getLibPackages(@NotNull Module module, @NotNull String packageName) {
        if (module == null) {
            AndroidCompileUtil.$$$reportNull$$$0(46);
        }
        if (packageName == null) {
            AndroidCompileUtil.$$$reportNull$$$0(47);
        }
        HashSet<String> packageSet = new HashSet<String>();
        packageSet.add(packageName);
        ArrayList<String> result2 = new ArrayList<String>();
        for (String libPackage : AndroidUtils.getDepLibsPackages(module)) {
            if (!packageSet.add(libPackage)) continue;
            result2.add(libPackage);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result2);
        if (stringArray == null) {
            AndroidCompileUtil.$$$reportNull$$$0(48);
        }
        return stringArray;
    }

    public static boolean isLibraryWithBadCircularDependency(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(49);
        }
        if (!((AndroidFacetConfiguration)facet2.getConfiguration()).canBeDependency()) {
            return false;
        }
        List<AndroidFacet> dependencies2 = AndroidUtils.getAllAndroidDependencies(facet2.getModule(), false);
        Manifest manifest = Manifest.getMainManifest(facet2);
        if (manifest == null) {
            return false;
        }
        String aPackage = (String)manifest.getPackage().getValue();
        if (aPackage == null || aPackage.isEmpty()) {
            return false;
        }
        for (AndroidFacet depFacet : dependencies2) {
            List<AndroidFacet> depDependencies = AndroidUtils.getAllAndroidDependencies(depFacet.getModule(), true);
            if (!depDependencies.contains(facet2) || !dependencies2.contains(depFacet) || depFacet.getModule().getName().compareTo(facet2.getModule().getName()) >= 0 && ((AndroidFacetConfiguration)depFacet.getConfiguration()).canBeDependency()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getUnsignedApkPath(@NotNull AndroidFacet facet2) {
        String path2;
        if (facet2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(50);
        }
        if ((path2 = facet2.getProperties().APK_PATH).isEmpty()) {
            return AndroidCompileUtil.getOutputPackage(facet2.getModule());
        }
        @SystemIndependent String moduleDirPath = AndroidRootUtil.getModuleDirPath(facet2.getModule());
        return moduleDirPath != null ? FileUtilRt.toSystemDependentName((String)(moduleDirPath + path2)) : null;
    }

    public static void reportException(@NotNull CompileContext context, @NotNull String messagePrefix, @NotNull Exception e) {
        if (context == null) {
            AndroidCompileUtil.$$$reportNull$$$0(51);
        }
        if (messagePrefix == null) {
            AndroidCompileUtil.$$$reportNull$$$0(52);
        }
        if (e == null) {
            AndroidCompileUtil.$$$reportNull$$$0(53);
        }
        context.addMessage(CompilerMessageCategory.ERROR, messagePrefix + e.getClass().getSimpleName() + ": " + e.getMessage(), null, -1, -1);
    }

    @Nullable
    public static String getAaptManifestPackage(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidCompileUtil.$$$reportNull$$$0(54);
        }
        if (facet2.getProperties().USE_CUSTOM_MANIFEST_PACKAGE) {
            return facet2.getProperties().CUSTOM_MANIFEST_PACKAGE;
        }
        Manifest manifest = Manifest.getMainManifest(facet2);
        return manifest != null ? manifest.getPackage().getStringValue() : null;
    }

    public static void createGenModulesAndSourceRoots(@NotNull Project project, final @NotNull Collection<AndroidFacet> facets) {
        if (project == null) {
            AndroidCompileUtil.$$$reportNull$$$0(55);
        }
        if (facets == null) {
            AndroidCompileUtil.$$$reportNull$$$0(56);
        }
        if (project.isDisposed()) {
            return;
        }
        final ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project).getModifiableModel();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ArrayList<ModifiableRootModel> modelsToCommit = new ArrayList<ModifiableRootModel>();
                for (AndroidFacet facet2 : facets) {
                    Module module;
                    if (AndroidModel.isRequired(facet2) || (module = facet2.getModule()).isDisposed()) continue;
                    ModifiableRootModel model2 = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    if (AndroidCompileUtil.createGenModulesAndSourceRoots(facet2, model2)) {
                        modelsToCommit.add(model2);
                        continue;
                    }
                    model2.dispose();
                }
                if (modelsToCommit.isEmpty()) {
                    return;
                }
                ModifiableModelCommitter.multiCommit(modelsToCommit, (ModifiableModuleModel)moduleModel);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 41: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 41: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/AndroidCompileUtil";
                break;
            }
            case 2: 
            case 36: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: 
            case 11: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 17: 
            case 24: 
            case 27: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 13: 
            case 18: 
            case 25: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelChangedFlag";
                break;
            }
            case 14: 
            case 31: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: 
            case 22: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoot";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 29: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 32: 
            case 34: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileScope";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFilesDirs";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePrefix";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/AndroidCompileUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toCompilerMessageCategoryKeys";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenModuleName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "toOsPaths";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toCompilerMessageCategoryKeys";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 41: 
            case 48: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProguardConfigFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectChildrenRecursively";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "unexcludeRootIfNecessary";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getGenModuleName";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSourceRootIfNotExist";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "excludeFromCompilation";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeGenModule";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoot";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findContentEntryForRoot";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatingClasses";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findResourcesCacheDirectory";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isFullBuild";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isReleaseBuild";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setReleaseBuild";
                break;
            }
            case 36: 
            case 37: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createGenModulesAndSourceRoots";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "initializeGenSourceRoot";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "toOsPaths";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getOutputPackage";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedFromCompilation";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getProguardConfigFilePathIfShouldRun";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findCircularDependencyOnLibraryWithSamePackage";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getLibPackages";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryWithBadCircularDependency";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getUnsignedApkPath";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "reportException";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getAaptManifestPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 41: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

