/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.prefs.AndroidLocation;
import com.android.tools.pixelprobe.util.Strings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import com.google.gson.Gson;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.istack.XMLStreamReaderToContentHandler;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;

public class AndroidBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    @NotNull
    private static final Logger LOG = Logger.getInstance(AndroidBuildProcessParametersProvider.class);

    @NotNull
    public List<String> getClassPath() {
        List<String> list = this.getJarsContainingClasses(Gson.class, ImmutableList.class, InternalFutureFailureAccess.class, BouncyCastleProvider.class, X509CertificateHolder.class, JAXBContext.class, JAXBContextImpl.class, XMLStreamReaderToContentHandler.class, DataSource.class, AndroidLocation.class, BuildException.class);
        if (list == null) {
            AndroidBuildProcessParametersProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    @VisibleForTesting
    List<String> getJarsContainingClasses(Class<?> ... classes2) {
        ArrayList<String> foundItems = new ArrayList<String>(classes2.length);
        ArrayList missingItems = new ArrayList(classes2.length);
        for (Class<?> aClass : classes2) {
            String path2 = PathManager.getJarPathForClass(aClass);
            if (path2 != null) {
                foundItems.add(path2);
                continue;
            }
            missingItems.add(aClass);
        }
        this.reportMissingClasses(missingItems);
        return foundItems;
    }

    @VisibleForTesting
    void reportMissingClasses(@NotNull List<Class<?>> classesWithMissingJars) {
        if (classesWithMissingJars == null) {
            AndroidBuildProcessParametersProvider.$$$reportNull$$$0(1);
        }
        if (!classesWithMissingJars.isEmpty()) {
            boolean unitTestMode;
            String message2 = "Could not find JARs for classes:" + Strings.join(classesWithMissingJars, (String)", ");
            LOG.warn(message2);
            boolean bl = unitTestMode = ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode();
            if (unitTestMode) {
                LOG.error("There is a problem with JPS classpath configuration: " + message2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/compiler/AndroidBuildProcessParametersProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesWithMissingJars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/compiler/AndroidBuildProcessParametersProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reportMissingClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

