/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import java.io.File;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateResourceDirectoryDialogBase;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.actions.NewResourceCreationHandler;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceDirectoryAction
extends CreateResourceActionBase {
    private final ResourceFolderType myResourceFolderType;

    public CreateResourceDirectoryAction() {
        this(null);
    }

    public CreateResourceDirectoryAction(@Nullable ResourceFolderType resourceFolderType) {
        super(AndroidBundle.messagePointer("new.resource.dir.action.title", new Object[0]), AndroidBundle.messagePointer("new.resource.action.description", new Object[0]), PlatformIcons.FOLDER_ICON);
        this.myResourceFolderType = resourceFolderType;
    }

    @NotNull
    public PsiElement[] invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory) {
        if (project == null) {
            CreateResourceDirectoryAction.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            CreateResourceDirectoryAction.$$$reportNull$$$0(1);
        }
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceDirectoryDialogBase dialog2 = newResourceHandler.createNewResourceDirectoryDialog(project, AndroidPsiUtils.getModuleSafely((PsiElement)directory), this.myResourceFolderType, directory, null, resDirectory -> new CreateResourceActionBase.MyInputValidator(project, resDirectory));
        dialog2.setTitle(AndroidBundle.message("new.resource.dir.dialog.title", new Object[0]));
        if (!dialog2.showAndGet()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CreateResourceDirectoryAction.$$$reportNull$$$0(2);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = dialog2.getCreatedElements();
        if (psiElementArray == null) {
            CreateResourceDirectoryAction.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiElement[] invokeDialog(@NotNull Project project, @NotNull DataContext dataContext) {
        ResourceFolderType folderType;
        if (project == null) {
            CreateResourceDirectoryAction.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            CreateResourceDirectoryAction.$$$reportNull$$$0(5);
        }
        if ((folderType = this.myResourceFolderType) == null) {
            VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            folderType = CreateResourceFileAction.getUniqueFolderType(files2);
        }
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceDirectoryDialogBase dialog2 = newResourceHandler.createNewResourceDirectoryDialog(project, (Module)LangDataKeys.MODULE.getData(dataContext), folderType, CreateResourceDialogUtils.findResourceDirectory(dataContext), dataContext, resDirectory -> new CreateResourceActionBase.MyInputValidator(project, resDirectory));
        dialog2.setTitle(AndroidBundle.message("new.resource.dir.dialog.title", new Object[0]));
        if (!dialog2.showAndGet()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CreateResourceDirectoryAction.$$$reportNull$$$0(6);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = dialog2.getCreatedElements();
        if (psiElementArray == null) {
            CreateResourceDirectoryAction.$$$reportNull$$$0(7);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    protected PsiElement[] create(String newName2, PsiDirectory directory) throws Exception {
        PsiElement[] psiElementArray = new PsiElement[]{directory.createSubdirectory(newName2)};
        if (psiElementArray == null) {
            CreateResourceDirectoryAction.$$$reportNull$$$0(8);
        }
        return psiElementArray;
    }

    @Override
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    @Override
    protected String getCommandName() {
        return AndroidBundle.message("new.resource.dir.command.name", new Object[0]);
    }

    @Override
    @Nullable
    protected String getActionName(PsiDirectory directory, String newName2) {
        return AndroidBundle.message("new.resource.dir.action.name", directory.getName() + File.separator + newName2);
    }

    @Override
    protected boolean isAvailable(DataContext context) {
        if (!super.isAvailable(context)) {
            return false;
        }
        return CreateResourceFileAction.isOutsideResourceTypeFolder(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/actions/CreateResourceDirectoryAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/actions/CreateResourceDirectoryAction";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialog";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

