/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.android.tools.idea.psi.TagToClassMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.annotations.NotNull;

class TagToClassMapperImpl
implements TagToClassMapper {
    private static final Logger LOG = Logger.getInstance(TagToClassMapper.class);
    private final Map<String, Map<String, SmartPsiElementPointer<PsiClass>>> myInitialClassMaps;
    private final Map<String, CachedValue<Map<String, PsiClass>>> myClassMaps;
    private final Module myModule;

    TagToClassMapperImpl(@NotNull Module module) {
        if (module == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(0);
        }
        this.myInitialClassMaps = new HashMap<String, Map<String, SmartPsiElementPointer<PsiClass>>>();
        this.myClassMaps = Maps.newConcurrentMap();
        this.myModule = module;
        MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                TagToClassMapperImpl.this.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/TagToClassMapperImpl$1", "rootsChanged"));
            }
        });
    }

    @Override
    @NotNull
    public Map<String, PsiClass> getClassMap(String className) {
        CachedValue value2 = this.myClassMaps.get(className);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager((Project)this.myModule.getProject()).createCachedValue(() -> {
                Map<String, PsiClass> map2 = this.computeClassMap(className);
                return CachedValueProvider.Result.create(map2, (Object[])new Object[]{AndroidPsiUtils.getPsiModificationTrackerIgnoringXml((Project)this.myModule.getProject())});
            }, false);
            this.myClassMaps.put(className, (CachedValue<Map<String, PsiClass>>)value2);
        }
        Map<String, PsiClass> map2 = Collections.unmodifiableMap((Map)value2.getValue());
        if (map2 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @NotNull
    private Map<String, PsiClass> computeClassMap(@NotNull String className) {
        PsiClass aClass;
        SmartPsiElementPointer<PsiClass> pointer;
        if (className == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(2);
        }
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.getInitialClassMap(className, false);
        HashMap<String, PsiClass> result2 = new HashMap<String, PsiClass>();
        boolean shouldRebuildInitialMap = false;
        int apiLevel = this.getMinApiLevel();
        for (String key : classMap.keySet()) {
            pointer = classMap.get(key);
            aClass = (PsiClass)pointer.getElement();
            if (aClass == null) continue;
            if (!TagToClassMapperImpl.isUpToDate(aClass, key, apiLevel)) {
                shouldRebuildInitialMap = true;
                break;
            }
            result2.put(key, aClass);
        }
        if (shouldRebuildInitialMap) {
            result2.clear();
            classMap = this.getInitialClassMap(className, true);
            for (String key : classMap.keySet()) {
                pointer = classMap.get(key);
                aClass = (PsiClass)pointer.getElement();
                if (aClass == null) continue;
                result2.put(key, aClass);
            }
        }
        this.fillMap(className, this.projectClassesScope(), result2);
        HashMap<String, PsiClass> hashMap = result2;
        if (hashMap == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    private static boolean isUpToDate(@NotNull PsiClass aClass, @NotNull String tagName, int apiLevel) {
        if (aClass == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(4);
        }
        if (tagName == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(5);
        }
        return ArrayUtil.contains((String)tagName, (String[])LayoutViewClassUtils.getTagNamesByClass(aClass, apiLevel));
    }

    @NotNull
    private Map<String, SmartPsiElementPointer<PsiClass>> getInitialClassMap(@NotNull String className, boolean forceRebuild) {
        Map<String, SmartPsiElementPointer<PsiClass>> viewClassMap;
        if (className == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(6);
        }
        if ((viewClassMap = this.myInitialClassMaps.get(className)) != null && !forceRebuild) {
            Map<String, SmartPsiElementPointer<PsiClass>> map2 = viewClassMap;
            if (map2 == null) {
                TagToClassMapperImpl.$$$reportNull$$$0(7);
            }
            return map2;
        }
        Map<String, SmartPsiElementPointer<PsiClass>> map3 = this.computeInitialClassMap(className);
        if (map3 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(8);
        }
        return map3;
    }

    @VisibleForTesting
    @NotNull
    Map<String, SmartPsiElementPointer<PsiClass>> computeInitialClassMap(@NotNull String className) {
        if (className == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(9);
        }
        LOG.info("Building initial class map for " + className);
        Map<String, SmartPsiElementPointer<PsiClass>> viewClassMap = null;
        HashMap<String, PsiClass> map2 = new HashMap<String, PsiClass>();
        if (this.fillMap(className, this.dependenciesClassesScope(), map2)) {
            viewClassMap = new HashMap(map2.size());
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myModule.getProject());
            for (Map.Entry entry : map2.entrySet()) {
                viewClassMap.put((String)entry.getKey(), (SmartPsiElementPointer<PsiClass>)manager.createSmartPsiElementPointer((PsiElement)((PsiClass)entry.getValue())));
            }
            this.myInitialClassMaps.put(className, viewClassMap);
        }
        Map<String, SmartPsiElementPointer<PsiClass>> map3 = viewClassMap != null ? viewClassMap : Collections.emptyMap();
        if (map3 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(10);
        }
        return map3;
    }

    @NotNull
    private GlobalSearchScope moduleResolveScope() {
        GlobalSearchScope globalSearchScope = ProjectSystemUtil.getModuleSystem(this.myModule).getResolveScope(ScopeType.MAIN);
        if (globalSearchScope == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope allLibrariesScope() {
        GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)this.myModule.getProject());
        if (globalSearchScope == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope projectClassesScope() {
        GlobalSearchScope globalSearchScope = this.moduleResolveScope().intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.allLibrariesScope()));
        if (globalSearchScope == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope dependenciesClassesScope() {
        GlobalSearchScope globalSearchScope = this.moduleResolveScope().intersectWith(this.allLibrariesScope());
        if (globalSearchScope == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(14);
        }
        return globalSearchScope;
    }

    private boolean fillMap(@NotNull String className, @NotNull GlobalSearchScope scope, @NotNull Map<String, PsiClass> map2) {
        String[] baseClassTagNames;
        if (className == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(16);
        }
        if (map2 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(17);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
        PsiClass baseClass = (PsiClass)ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass aClass;
            try {
                aClass = facade.findClass(className, this.moduleResolveScope());
            }
            catch (IndexNotReadyException e) {
                aClass = null;
            }
            return aClass;
        });
        if (baseClass == null) {
            return false;
        }
        int api = this.getMinApiLevel();
        for (String tagName : baseClassTagNames = LayoutViewClassUtils.getTagNamesByClass(baseClass, api)) {
            map2.put(tagName, baseClass);
        }
        try {
            ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true).forEach(c -> {
                String[] tagNames;
                for (String tagName : tagNames = LayoutViewClassUtils.getTagNamesByClass(c, api)) {
                    map2.put(tagName, (PsiClass)c);
                }
                return true;
            });
        }
        catch (IndexNotReadyException e) {
            Logger.getInstance(this.getClass()).info((Throwable)e);
            return false;
        }
        return !map2.isEmpty();
    }

    private int getMinApiLevel() {
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(this.myModule);
        return androidModuleInfo == null ? 1 : androidModuleInfo.getModuleMinApi();
    }

    public void clear() {
        this.myInitialClassMaps.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/TagToClassMapperImpl";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/TagToClassMapperImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeClassMap";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialClassMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInitialClassMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleResolveScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "allLibrariesScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "projectClassesScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "dependenciesClassesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeClassMap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInitialClassMap";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeInitialClassMap";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fillMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

