/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.databinding.DataBindingModuleComponent;
import com.android.tools.idea.lang.databinding.DataBindingCompletionUtil;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.AttributeProcessingUtil;
import org.jetbrains.android.dom.animation.AndroidAnimationUtils;
import org.jetbrains.android.dom.animator.AndroidAnimatorUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.color.AndroidColorDomUtil;
import org.jetbrains.android.dom.converters.FlagConverter;
import org.jetbrains.android.dom.drawable.AndroidDrawableDomUtil;
import org.jetbrains.android.dom.font.FontFamilyDomFileDescription;
import org.jetbrains.android.dom.layout.AndroidLayoutUtil;
import org.jetbrains.android.dom.layout.Data;
import org.jetbrains.android.dom.layout.DataBindingDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.raw.RawDomFileDescription;
import org.jetbrains.android.dom.transition.TransitionDomFileDescription;
import org.jetbrains.android.dom.transition.TransitionDomUtil;
import org.jetbrains.android.dom.xml.AndroidXmlResourcesUtil;
import org.jetbrains.android.dom.xml.XmlResourceDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidXmlCompletionContributor
extends CompletionContributor {
    private static final String LAYOUT_ATTRIBUTE_PREFIX = "layout_";

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet resultSet) {
        PsiElement originalParent;
        if (parameters2 == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(0);
        }
        if (resultSet == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(1);
        }
        PsiElement position = parameters2.getPosition();
        PsiElement originalPosition = parameters2.getOriginalPosition();
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)position);
        if (facet2 == null) {
            return;
        }
        PsiElement parent = position.getParent();
        PsiElement psiElement = originalParent = originalPosition != null ? originalPosition.getParent() : null;
        if (parent instanceof XmlTag) {
            int refOffset;
            PsiElement element;
            XmlTag tag = (XmlTag)parent;
            if (tag.getParentTag() != null) {
                return;
            }
            ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode());
            if (startTagName == null || startTagName.getPsi() != position) {
                return;
            }
            PsiFile file = tag.getContainingFile();
            if (!(file instanceof XmlFile)) {
                return;
            }
            PsiReference reference2 = file.findReferenceAt(parameters2.getOffset());
            if (reference2 != null && (element = reference2.getElement()) != null && (refOffset = element.getTextRange().getStartOffset() + reference2.getRangeInElement().getStartOffset()) != position.getTextRange().getStartOffset()) {
                return;
            }
            if (!AndroidXmlCompletionContributor.completeRootTagNames(facet2, (XmlFile)file, resultSet)) {
                resultSet.stopHere();
            }
        } else if (parent instanceof XmlAttribute) {
            ASTNode attrName = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(parent.getNode());
            if (attrName == null || attrName.getPsi() != position) {
                return;
            }
            XmlAttribute attribute = (XmlAttribute)parent;
            String namespace = attribute.getNamespace();
            if ("http://schemas.android.com/tools".equals(namespace)) {
                AndroidXmlCompletionContributor.addDesignTimeAttributes(attribute.getNamespacePrefix(), position, facet2, attribute, resultSet);
            }
            AndroidXmlCompletionContributor.addDataBindingAttributes(attribute.getNamespacePrefix(), position, facet2, attribute, parameters2, resultSet);
            AndroidXmlCompletionContributor.customizeAddedAttributes(facet2, parameters2, attribute, resultSet);
        } else if (originalParent instanceof XmlAttributeValue) {
            AndroidXmlCompletionContributor.completeTailsInFlagAttribute(parameters2, resultSet, (XmlAttributeValue)originalParent);
            AndroidXmlCompletionContributor.completeDataBindingTypeAttr(parameters2, resultSet, (XmlAttributeValue)originalParent);
        }
    }

    private static void addAll(Collection<String> collection2, CompletionResultSet set) {
        for (String s : collection2) {
            set.addElement((LookupElement)LookupElementBuilder.create((String)s));
        }
    }

    private static boolean completeRootTagNames(@NotNull AndroidFacet facet2, @NotNull XmlFile xmlFile, @NotNull CompletionResultSet resultSet) {
        if (facet2 == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(2);
        }
        if (xmlFile == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(3);
        }
        if (resultSet == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(4);
        }
        if (ManifestDomFileDescription.isManifestFile(xmlFile, facet2)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"manifest"));
            return false;
        }
        if (LayoutDomFileDescription.isLayoutFile(xmlFile)) {
            Map<String, PsiClass> classMap = AttributeProcessingUtil.getViewClassMap(facet2);
            for (String rootTag : AndroidLayoutUtil.getPossibleRoots(facet2)) {
                LookupElementBuilder builder2;
                PsiClass aClass = classMap.get(rootTag);
                if (aClass != null) {
                    String name;
                    builder2 = LookupElementBuilder.create((Object)aClass, (String)rootTag);
                    String qualifiedName = aClass.getQualifiedName();
                    String string = name = qualifiedName == null ? null : AndroidUtils.getUnqualifiedName(qualifiedName);
                    if (name != null) {
                        builder2 = builder2.withLookupString(name);
                    }
                } else {
                    builder2 = LookupElementBuilder.create((String)rootTag);
                }
                Icon icon2 = AndroidDomElementDescriptorProvider.getIconForViewTag(rootTag);
                if (icon2 != null) {
                    builder2 = builder2.withIcon(icon2);
                }
                resultSet.addElement((LookupElement)builder2);
            }
            return false;
        }
        if (AndroidResourceDomFileDescription.isFileInResourceFolderType(xmlFile, ResourceFolderType.ANIM)) {
            AndroidXmlCompletionContributor.addAll(AndroidAnimationUtils.getPossibleRoots(), resultSet);
            return false;
        }
        if (AndroidResourceDomFileDescription.isFileInResourceFolderType(xmlFile, ResourceFolderType.ANIMATOR)) {
            AndroidXmlCompletionContributor.addAll(AndroidAnimatorUtil.getPossibleRoots(), resultSet);
            return false;
        }
        if (XmlResourceDomFileDescription.isXmlResourceFile(xmlFile)) {
            AndroidXmlCompletionContributor.addAll(AndroidXmlResourcesUtil.getPossibleRoots(facet2), resultSet);
            return false;
        }
        if (AndroidDrawableDomUtil.isDrawableResourceFile(xmlFile)) {
            AndroidXmlCompletionContributor.addAll(AndroidDrawableDomUtil.getPossibleRoots(facet2), resultSet);
            return false;
        }
        if (TransitionDomFileDescription.isTransitionFile(xmlFile)) {
            AndroidXmlCompletionContributor.addAll(TransitionDomUtil.getPossibleRoots(), resultSet);
            return false;
        }
        if (AndroidColorDomUtil.isColorResourceFile(xmlFile)) {
            AndroidXmlCompletionContributor.addAll(AndroidColorDomUtil.getPossibleRoots(), resultSet);
            return false;
        }
        if (RawDomFileDescription.isRawFile(xmlFile)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"resources"));
            return false;
        }
        if (AndroidResourceDomFileDescription.isFileInResourceFolderType(xmlFile, ResourceFolderType.MIPMAP)) {
            AndroidXmlCompletionContributor.addAll(AndroidDrawableDomUtil.getPossibleRoots(facet2, ResourceFolderType.MIPMAP), resultSet);
            return false;
        }
        if (FontFamilyDomFileDescription.isFontFamilyFile(xmlFile)) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)"font-family"));
            return false;
        }
        return true;
    }

    private static void addDesignTimeAttributes(@NotNull String namespacePrefix, @NotNull PsiElement psiElement, @NotNull AndroidFacet facet2, @NotNull XmlAttribute attribute, @NotNull CompletionResultSet resultSet) {
        if (namespacePrefix == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(5);
        }
        if (psiElement == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(6);
        }
        if (facet2 == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(7);
        }
        if (attribute == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(8);
        }
        if (resultSet == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(9);
        }
        XmlTag tag = attribute.getParent();
        DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        HashSet<XmlName> registeredAttributes = new HashSet<XmlName>();
        if (element instanceof LayoutElement) {
            AttributeProcessingUtil.processLayoutAttributes(facet2, tag, (LayoutElement)element, registeredAttributes, (xmlName, attrDef, parentStyleableName) -> {
                if ("http://schemas.android.com/apk/res/android".equals(xmlName.getNamespaceKey())) {
                    String localName = xmlName.getLocalName();
                    LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)psiElement, (String)localName).withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE);
                    resultSet.addElement((LookupElement)lookupElement);
                }
                return null;
            });
        }
    }

    private static void customizeAddedAttributes(AndroidFacet facet2, CompletionParameters parameters2, XmlAttribute attribute, CompletionResultSet resultSet) {
        boolean localNameCompletion;
        XmlTag gp = attribute.getParent();
        if (gp == null) {
            return;
        }
        XmlTag tag = gp;
        DomElement element = DomManager.getDomManager((Project)gp.getProject()).getDomElement(tag);
        if (!(element instanceof LayoutElement)) {
            return;
        }
        if (attribute.getName().contains(":")) {
            String nsPrefix = attribute.getNamespacePrefix();
            if (nsPrefix.isEmpty()) {
                return;
            }
            if (!"http://schemas.android.com/apk/res/android".equals(tag.getNamespaceByPrefix(nsPrefix))) {
                return;
            }
            localNameCompletion = true;
        } else {
            localNameCompletion = false;
        }
        HashMap prefix2ns = new HashMap();
        resultSet.runRemainingContributors(parameters2, result2 -> {
            LookupElement lookupElement = result2.getLookupElement();
            Object obj = lookupElement.getObject();
            if (obj instanceof String) {
                String s = (String)obj;
                int index = s.indexOf(58);
                String attributeName = s.substring(index + 1);
                if (index > 0) {
                    String prefix = s.substring(0, index);
                    String ns = (String)prefix2ns.get(prefix);
                    if (ns == null) {
                        ns = tag.getNamespaceByPrefix(prefix);
                        prefix2ns.put(prefix, ns);
                    }
                    if ("http://schemas.android.com/apk/res/android".equals(ns)) {
                        boolean deprecated = AndroidXmlCompletionContributor.isFrameworkAttributeDeprecated(facet2, attribute, attributeName);
                        result2 = AndroidXmlCompletionContributor.customizeLayoutAttributeLookupElement(lookupElement, result2, attributeName, deprecated);
                    }
                } else if (localNameCompletion) {
                    result2 = AndroidXmlCompletionContributor.customizeLayoutAttributeLookupElement(lookupElement, result2, attributeName, false);
                }
            }
            resultSet.passResult(result2);
        });
    }

    private static boolean isFrameworkAttributeDeprecated(AndroidFacet facet2, XmlAttribute attribute, String attributeName) {
        ResourceManager manager = ModuleResourceManagers.getInstance(facet2).getResourceManager("android", (PsiElement)attribute.getParent());
        if (manager == null) {
            return false;
        }
        AttributeDefinitions attributes = manager.getAttributeDefinitions();
        if (attributes == null) {
            return false;
        }
        AttributeDefinition attributeDefinition = attributes.getAttrDefByName(attributeName);
        return attributeDefinition != null && attributeDefinition.isAttributeDeprecated();
    }

    private static CompletionResult customizeLayoutAttributeLookupElement(LookupElement lookupElement, CompletionResult result2, String localName, final boolean markDeprecated) {
        if (!localName.startsWith(LAYOUT_ATTRIBUTE_PREFIX)) {
            if (markDeprecated) {
                return result2.withLookupElement(PrioritizedLookupElement.withPriority((LookupElement)new LookupElementDecorator<LookupElement>(lookupElement){

                    public void renderElement(LookupElementPresentation presentation) {
                        super.renderElement(presentation);
                        presentation.setStrikeout(true);
                    }
                }, (double)-1.0));
            }
            return result2;
        }
        String localSuffix = localName.substring(LAYOUT_ATTRIBUTE_PREFIX.length());
        if (!localSuffix.isEmpty()) {
            final HashSet<String> lookupStrings = new HashSet<String>(lookupElement.getAllLookupStrings());
            lookupStrings.add(localSuffix);
            lookupElement = new LookupElementDecorator<LookupElement>(lookupElement){

                public Set<String> getAllLookupStrings() {
                    return lookupStrings;
                }

                public void renderElement(LookupElementPresentation presentation) {
                    super.renderElement(presentation);
                    presentation.setStrikeout(markDeprecated);
                }
            };
        }
        return result2.withLookupElement(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)100.0));
    }

    private static void addDataBindingAttributes(@NotNull String prefix, @NotNull PsiElement position, @NotNull AndroidFacet facet2, @NotNull XmlAttribute attribute, @NotNull CompletionParameters parameters2, @NotNull CompletionResultSet resultSet) {
        PsiFile containingFile;
        if (prefix == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(10);
        }
        if (position == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(11);
        }
        if (facet2 == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(12);
        }
        if (attribute == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(13);
        }
        if (parameters2 == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(14);
        }
        if (resultSet == null) {
            AndroidXmlCompletionContributor.$$$reportNull$$$0(15);
        }
        if (!((containingFile = attribute.getContainingFile()) instanceof XmlFile) || !DataBindingDomFileDescription.hasDataBindingRootTag((XmlFile)containingFile)) {
            return;
        }
        Module module = facet2.getModule();
        DataBindingModuleComponent dataBindingComponent = (DataBindingModuleComponent)module.getService(DataBindingModuleComponent.class);
        if (dataBindingComponent == null) {
            return;
        }
        Set alreadyDeclared = resultSet.runRemainingContributors(parameters2, true).stream().map(CompletionResult::getLookupElement).map(LookupElement::getLookupString).collect(Collectors.toSet());
        dataBindingComponent.getBindingAdapterAttributes().forEach(dataBindingAttribute -> {
            if (!prefix.isEmpty()) {
                dataBindingAttribute = StringUtil.trimStart((String)dataBindingAttribute, (String)(prefix + ":"));
            }
            if (!alreadyDeclared.contains(dataBindingAttribute)) {
                resultSet.addElement((LookupElement)LookupElementBuilder.create((Object)position, (String)dataBindingAttribute).withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE));
            }
        });
    }

    private static void completeDataBindingTypeAttr(CompletionParameters parameters2, CompletionResultSet resultSet, XmlAttributeValue originalParent) {
        PsiElement gp = originalParent.getParent();
        if (!(gp instanceof XmlAttribute)) {
            return;
        }
        GenericAttributeValue domElement = DomManager.getDomManager((Project)gp.getProject()).getDomElement((XmlAttribute)gp);
        if (domElement == null) {
            return;
        }
        if (DomUtil.getParentOfType((DomElement)domElement, Data.class, (boolean)true) != null && ((XmlAttribute)gp).getName().equals("type")) {
            DataBindingCompletionUtil.addCompletions(parameters2, resultSet);
        }
    }

    private static void completeTailsInFlagAttribute(CompletionParameters parameters2, CompletionResultSet resultSet, XmlAttributeValue parent) {
        String prefix;
        Set<String> valueSet;
        Converter converter;
        String currentValue = parent.getValue();
        if (currentValue == null || currentValue.isEmpty() || currentValue.endsWith("|")) {
            return;
        }
        PsiElement grandparent = parent.getParent();
        if (!(grandparent instanceof XmlAttribute)) {
            return;
        }
        GenericAttributeValue domValue = DomManager.getDomManager((Project)grandparent.getProject()).getDomElement((XmlAttribute)grandparent);
        Converter converter2 = converter = domValue != null ? domValue.getConverter() : null;
        if (!(converter instanceof FlagConverter)) {
            return;
        }
        TextRange valueRange = parent.getValueTextRange();
        if (valueRange != null && valueRange.getEndOffset() == parameters2.getOffset() && !(valueSet = ((FlagConverter)converter).getValues()).isEmpty() && valueSet.contains(prefix = resultSet.getPrefixMatcher().getPrefix())) {
            ArrayList<String> filteredValues = new ArrayList<String>(valueSet);
            DelimitedListConverter.filterVariants(filteredValues, (GenericDomValue)domValue);
            for (String variant : filteredValues) {
                resultSet.addElement((LookupElement)LookupElementBuilder.create((String)(prefix + "|" + variant)));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidXmlCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "completeRootTagNames";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addDesignTimeAttributes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addDataBindingAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

