/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Color;
import org.jetbrains.android.AndroidResourceExternalAnnotatorBase;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXMLResourceExternalAnnotator
extends AndroidResourceExternalAnnotatorBase {
    @Override
    @Nullable
    protected AndroidResourceExternalAnnotatorBase.FileAnnotationInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor2) {
        AndroidFacet facet2;
        if (file == null) {
            AndroidXMLResourceExternalAnnotator.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            AndroidXMLResourceExternalAnnotator.$$$reportNull$$$0(1);
        }
        if ((facet2 = AndroidFacet.getInstance((PsiElement)file)) == null) {
            return null;
        }
        final AndroidResourceExternalAnnotatorBase.FileAnnotationInfo annotationInfo = new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo(facet2, file, editor2);
        if (AndroidResourceUtil.isInResourceSubdirectory(file, "values")) {
            file.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement annotatableElement = AndroidXMLResourceExternalAnnotator.getAnnotatableElement(tag.getValue().getText().trim(), (XmlElement)tag);
                    if (annotatableElement != null) {
                        annotationInfo.getElements().add(annotatableElement);
                    }
                }
            });
        } else if (AndroidResourceUtil.isInResourceSubdirectory(file, null) || ManifestDomFileDescription.isManifestFile((XmlFile)file)) {
            file.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                    super.visitXmlAttributeValue(attributeValue);
                    AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement annotatableElement = AndroidXMLResourceExternalAnnotator.getAnnotatableElement(attributeValue.getValue(), (XmlElement)attributeValue);
                    if (annotatableElement != null) {
                        annotationInfo.getElements().add(annotatableElement);
                    }
                }
            });
        }
        if (annotationInfo.getElements().isEmpty()) {
            return null;
        }
        return annotationInfo;
    }

    @Nullable
    private static AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement getAnnotatableElement(@NotNull String value2, @NotNull XmlElement element) {
        if (value2 == null) {
            AndroidXMLResourceExternalAnnotator.$$$reportNull$$$0(2);
        }
        if (element == null) {
            AndroidXMLResourceExternalAnnotator.$$$reportNull$$$0(3);
        }
        if ((value2 = value2.trim()).isEmpty()) {
            return null;
        }
        if (value2.charAt(0) != '@' && value2.charAt(0) != '#') {
            return null;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)value2);
        if (resourceUrl == null) {
            if (value2.startsWith("#")) {
                Color color = ResourceHelper.parseColor(value2);
                if (color == null) {
                    return null;
                }
                return new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement(color, (PsiElement)element);
            }
        } else {
            ResourceReference reference2 = ResourceHelper.resolve(resourceUrl, element);
            if (reference2 == null) {
                return null;
            }
            ResourceType type = reference2.getResourceType();
            if (type != ResourceType.COLOR && type != ResourceType.DRAWABLE && type != ResourceType.MIPMAP) {
                return null;
            }
            return new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement(reference2, (PsiElement)element);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidXMLResourceExternalAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotatableElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

