/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.templates.TemplateManager;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.AndroidPrecompileTask;
import org.jetbrains.android.compiler.AndroidResourceFilesListener;
import org.jetbrains.android.compiler.ModuleSourceAutogenerating;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Service
public final class AndroidProjectComponent
implements Disposable {
    private final Project myProject;
    private static boolean ourDynamicTemplateMenuCreated;

    private AndroidProjectComponent(@NotNull Project project) {
        if (project == null) {
            AndroidProjectComponent.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    private static AndroidProjectComponent getService(Project project) {
        return (AndroidProjectComponent)ServiceManager.getService((Project)project, AndroidProjectComponent.class);
    }

    private void registerTemplatesAutoRefresh() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
            if (result2.isSuccessful()) {
                Runnable runnable2 = () -> {
                    if (this.myProject.isDisposed() || !ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(AndroidFacet.ID)) {
                        return;
                    }
                    TemplateManager.getInstance().refreshDynamicTemplateMenu(this.myProject);
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    runnable2.run();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(runnable2);
                }
            }
        });
    }

    private void createAndroidSpecificComponents() {
        AndroidResourceFilesListener listener2 = new AndroidResourceFilesListener(this.myProject);
        Disposer.register((Disposable)this, (Disposable)listener2);
        AndroidProjectComponent.createDynamicTemplateMenu();
        this.createAlarmForAutogeneration();
    }

    public void dispose() {
    }

    private static void createDynamicTemplateMenu() {
        if (ourDynamicTemplateMenuCreated) {
            return;
        }
        ourDynamicTemplateMenuCreated = true;
        new Task.Backgroundable(null, "Loading Dynamic Templates", false, PerformInBackgroundOption.ALWAYS_BACKGROUND){
            ActionGroup menu;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                this.menu = TemplateManager.getInstance().getTemplateCreationMenu(null);
            }

            public void onFinished() {
                DefaultActionGroup newGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("NewGroup");
                newGroup.addSeparator();
                if (this.menu != null) {
                    newGroup.add((AnAction)this.menu, new Constraints(Anchor.AFTER, "NewFromTemplate"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/AndroidProjectComponent$1", "run"));
            }
        }.queue();
    }

    private void createAlarmForAutogeneration() {
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!AndroidProjectComponent.this.myProject.isOpen()) {
                    return;
                }
                try {
                    DumbService service = DumbService.getInstance((Project)AndroidProjectComponent.this.myProject);
                    Map facetsToProcess = (Map)service.runReadActionInSmartMode(() -> AndroidProjectComponent.this.checkGenerate());
                    if (!facetsToProcess.isEmpty()) {
                        AndroidProjectComponent.this.generate(facetsToProcess);
                    }
                }
                finally {
                    if (!alarm.isDisposed()) {
                        alarm.addRequest((Runnable)this, 2000);
                    }
                }
            }
        }, 2000);
    }

    private Map<AndroidFacet, Collection<AndroidAutogeneratorMode>> checkGenerate() {
        if (this.myProject.isDisposed()) {
            return Collections.emptyMap();
        }
        HashMap<AndroidFacet, Collection<AndroidAutogeneratorMode>> facetsToProcess = new HashMap<AndroidFacet, Collection<AndroidAutogeneratorMode>>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
            if (facet2 == null || !ModuleSourceAutogenerating.requiresAutoSourceGeneration(facet2)) continue;
            ModuleSourceAutogenerating autogenerator = ModuleSourceAutogenerating.getInstance(facet2);
            assert (autogenerator != null);
            EnumSet<AndroidAutogeneratorMode> modes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
            for (AndroidAutogeneratorMode mode : AndroidAutogeneratorMode.values()) {
                if (!autogenerator.cleanRegeneratingState(mode) && !autogenerator.isGeneratedFileRemoved(mode)) continue;
                modes.add(mode);
            }
            if (modes.isEmpty()) continue;
            facetsToProcess.put(facet2, modes);
        }
        return facetsToProcess;
    }

    private void generate(Map<AndroidFacet, Collection<AndroidAutogeneratorMode>> facetsToProcess) {
        ApplicationManager.getApplication().invokeAndWait(() -> AndroidCompileUtil.createGenModulesAndSourceRoots(this.myProject, facetsToProcess.keySet()));
        for (Map.Entry<AndroidFacet, Collection<AndroidAutogeneratorMode>> entry : facetsToProcess.entrySet()) {
            AndroidFacet facet2 = entry.getKey();
            Collection<AndroidAutogeneratorMode> modes = entry.getValue();
            for (AndroidAutogeneratorMode mode : modes) {
                AndroidCompileUtil.doGenerate(facet2, mode);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidProjectComponent", "<init>"));
    }

    public static class AndroidProjectStartupActivity
    implements StartupActivity.DumbAware {
        public void runActivity(final @NotNull Project project) {
            if (project == null) {
                AndroidProjectStartupActivity.$$$reportNull$$$0(0);
            }
            CompilerManager manager = CompilerManager.getInstance((Project)project);
            manager.addBeforeTask((CompileTask)new AndroidPrecompileTask());
            if (ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
                AndroidProjectComponent.getService(project).createAndroidSpecificComponents();
            } else {
                final MessageBusConnection connection = project.getMessageBus().connect();
                connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

                    public void facetAdded(@NotNull Facet facet2) {
                        if (facet2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (facet2 instanceof AndroidFacet) {
                            AndroidProjectComponent.getService(project).createAndroidSpecificComponents();
                            connection.disconnect();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/AndroidProjectComponent$AndroidProjectStartupActivity$1", "facetAdded"));
                    }
                });
            }
            AndroidProjectComponent.getService(project).registerTemplatesAutoRefresh();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/AndroidProjectComponent$AndroidProjectStartupActivity", "runActivity"));
        }
    }
}

