/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.annotations.concurrency.WorkerThread;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.google.common.collect.ObjectArrays;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.android.dom.resources.ResourcesDomFileDescription;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    @WorkerThread
    public boolean canFindUsages(@NotNull PsiElement element) {
        AndroidFacet facet2;
        XmlAttributeValue value2;
        if (element == null) {
            AndroidFindUsagesHandlerFactory.$$$reportNull$$$0(0);
        }
        if (((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue()) {
            return false;
        }
        if (element instanceof ResourceReferencePsiElement) {
            return true;
        }
        if (element instanceof LazyValueResourceElementWrapper) {
            return true;
        }
        if (element instanceof XmlAttributeValue && AndroidResourceUtil.isIdDeclaration(value2 = (XmlAttributeValue)element)) {
            return true;
        }
        if ((element = AndroidFindUsagesHandlerFactory.correctResourceElement(element)) instanceof PsiField) {
            return AndroidResourceUtil.isResourceField((PsiField)element);
        }
        if ((element instanceof PsiFile || element instanceof XmlTag) && (facet2 = AndroidFacet.getInstance((PsiElement)element)) != null) {
            LocalResourceManager resourceManager = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager();
            if (element instanceof PsiFile) {
                return resourceManager.getFileResourceFolderType((PsiFile)element) != null;
            }
            ResourceFolderType fileResType = resourceManager.getFileResourceFolderType(element.getContainingFile());
            if (ResourceFolderType.VALUES == fileResType) {
                return AndroidResourceUtil.getResourceTypeForResourceTag((XmlTag)element) != null;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement correctResourceElement(PsiElement element) {
        if (element instanceof XmlElement && !(element instanceof XmlFile)) {
            PsiFile file;
            XmlTag tag;
            XmlTag xmlTag = tag = element instanceof XmlTag ? (XmlTag)element : (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag != null && (file = tag.getContainingFile()) instanceof XmlFile && ResourcesDomFileDescription.isResourcesFile((XmlFile)file)) {
                return tag;
            }
            return null;
        }
        return element;
    }

    private static XmlAttributeValue wrapIfNecessary(XmlAttributeValue value2) {
        if (value2 instanceof ResourceElementWrapper) {
            return value2;
        }
        return new ValueResourceElementWrapper(value2);
    }

    @WorkerThread
    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        XmlAttributeValue value2;
        if (element == null) {
            AndroidFindUsagesHandlerFactory.$$$reportNull$$$0(1);
        }
        if (element instanceof ResourceReferencePsiElement) {
            return new MyFindUsagesHandler(element, PsiElement.EMPTY_ARRAY);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)element.getContainingFile());
        if (facet2 == null) {
            return null;
        }
        if (element instanceof LazyValueResourceElementWrapper) {
            ValueResourceInfo resourceInfo = ((LazyValueResourceElementWrapper)element).getResourceInfo();
            PsiField[] resourceFields = forHighlightUsages ? PsiField.EMPTY_ARRAY : AndroidResourceUtil.findResourceFields(facet2, resourceInfo.getType().getName(), resourceInfo.getName(), true);
            return new MyFindUsagesHandler(element, (PsiElement[])resourceFields);
        }
        if (element instanceof XmlAttributeValue && AndroidResourceUtil.isIdDeclaration(value2 = (XmlAttributeValue)element)) {
            element = AndroidFindUsagesHandlerFactory.wrapIfNecessary(value2);
            PsiField[] fields = forHighlightUsages ? PsiField.EMPTY_ARRAY : AndroidResourceUtil.findIdFields(value2);
            return new MyFindUsagesHandler(element, (PsiElement[])fields);
        }
        if ((element = AndroidFindUsagesHandlerFactory.correctResourceElement(element)) instanceof PsiFile) {
            PsiField[] fields;
            PsiField[] psiFieldArray = fields = forHighlightUsages ? PsiField.EMPTY_ARRAY : AndroidResourceUtil.findResourceFieldsForFileResource((PsiFile)element, true);
            if (fields.length == 0) {
                return null;
            }
            return new MyFindUsagesHandler(element, (PsiElement[])fields);
        }
        if (element instanceof XmlTag) {
            XmlAttributeValue nameValue;
            XmlTag tag = (XmlTag)element;
            XmlAttribute nameAttr = tag.getAttribute("name");
            XmlAttributeValue xmlAttributeValue = nameValue = nameAttr != null ? nameAttr.getValueElement() : null;
            assert (nameValue != null);
            Object[] fields = PsiField.EMPTY_ARRAY;
            if (!forHighlightUsages) {
                fields = AndroidResourceUtil.findResourceFieldsForValueResource(tag, true);
                if (fields.length == 0) {
                    return null;
                }
                Object[] styleableFields = AndroidResourceUtil.findStyleableAttributeFields(tag, true);
                if (styleableFields.length > 0) {
                    fields = (PsiField[])ObjectArrays.concat((Object[])fields, (Object[])styleableFields, PsiField.class);
                }
            }
            return new MyFindUsagesHandler((PsiElement)nameValue, (PsiElement[])fields);
        }
        if (element instanceof PsiField) {
            PsiField field2 = (PsiField)element;
            List<PsiElement> resources = AndroidResourceUtil.findResourcesByField(field2);
            if (resources.isEmpty()) {
                return new MyFindUsagesHandler(element, new PsiElement[0]);
            }
            PsiElement resource = resources.get(0);
            return this.createFindUsagesHandler(resource, forHighlightUsages);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "org/jetbrains/android/AndroidFindUsagesHandlerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canFindUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFindUsagesHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyFindUsagesHandler
    extends FindUsagesHandler {
        private final PsiElement[] myAdditionalElements;

        protected MyFindUsagesHandler(@NotNull PsiElement element, PsiElement ... additionalElements) {
            if (element == null) {
                MyFindUsagesHandler.$$$reportNull$$$0(0);
            }
            super(element);
            this.myAdditionalElements = additionalElements;
        }

        @NotNull
        public PsiElement[] getSecondaryElements() {
            if (this.myAdditionalElements == null) {
                MyFindUsagesHandler.$$$reportNull$$$0(1);
            }
            return this.myAdditionalElements;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/AndroidFindUsagesHandlerFactory$MyFindUsagesHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/AndroidFindUsagesHandlerFactory$MyFindUsagesHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSecondaryElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

