/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.structure.IdeSdksConfigurable;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizard;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizardStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkSetupStep
extends FirstRunWizardStep {
    private ComboboxWithBrowseButton myJdkLocationComboBox;
    private JBLabel myJdkLocationHelp;
    private JBScrollPane myContents;
    private boolean myIsJavaHomeValid;

    public JdkSetupStep() {
        super("Select default JDK Location");
        this.$$$setupUI$$$();
        this.setUpJdkLocationComboBox();
        this.setComponent((JComponent)this.myContents);
        this.createUIComponents();
    }

    private void setUpJdkLocationComboBox() {
        String javaHomePath;
        File validatedPath;
        FileChooserDescriptor descriptor2 = JdkSetupStep.createSingleFolderDescriptor((Function<? super File, Void>)((Function)file -> {
            File validatedFile = this.validateJdkPath((File)file);
            if (validatedFile == null) {
                throw new IllegalArgumentException(IdeSdksConfigurable.generateChooseValidJdkDirectoryError());
            }
            this.setJdkLocationComboBox((File)file);
            return null;
        }));
        this.myJdkLocationComboBox.addBrowseFolderListener(this.getProject(), descriptor2);
        JComboBox comboBox = this.myJdkLocationComboBox.getComboBox();
        IdeSdks ideSdks = IdeSdks.getInstance();
        File embeddedPath = ideSdks.getEmbeddedJdkPath();
        if (embeddedPath != null && (validatedPath = this.validateJdkPath(embeddedPath)) != null) {
            comboBox.addItem(new IdeSdksConfigurable.LabelAndFileForLocation("Embedded JDK", validatedPath));
        }
        if ((javaHomePath = IdeSdks.getJdkFromJavaHome()) != null) {
            File validatedPath2 = this.validateJdkPath(new File(javaHomePath));
            boolean bl = this.myIsJavaHomeValid = validatedPath2 != null;
            if (this.myIsJavaHomeValid) {
                comboBox.addItem(new IdeSdksConfigurable.LabelAndFileForLocation("JAVA_HOME", validatedPath2));
            }
        }
        comboBox.setEditable(true);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Object selectedItem;
                if (event.getStateChange() == 1 && (selectedItem = event.getItem()) instanceof IdeSdksConfigurable.LabelAndFileForLocation) {
                    ApplicationManager.getApplication().invokeLater(() -> JdkSetupStep.this.setJdkLocationComboBox(((IdeSdksConfigurable.LabelAndFileForLocation)selectedItem).getFile()));
                }
            }
        });
        this.setJdkLocationComboBox(embeddedPath);
    }

    private void setJdkLocationComboBox(@Nullable File path2) {
        if (path2 == null) {
            this.myJdkLocationComboBox.getComboBox().setSelectedItem(null);
        } else {
            this.myJdkLocationComboBox.getComboBox().setSelectedItem(FileUtilRt.toSystemDependentName((String)path2.getPath()));
        }
        this.updateIsValidPath();
    }

    private void createUIComponents() {
        this.myJdkLocationHelp = ContextHelpLabel.createWithLink(null, (String)"To share the same Gradle daemon between Android Studio and other external processes, create a JAVA_HOME environment variable with a valid JDK location and select it from the dropdown below.", (String)"Learn more", () -> BrowserUtil.browse((String)"https://docs.gradle.org/current/userguide/gradle_daemon.html#sec:why_is_there_more_than_one_daemon_process_on_my_machine"));
    }

    @NotNull
    private static FileChooserDescriptor createSingleFolderDescriptor(final @NotNull Function<? super File, Void> validation2) {
        if (validation2 == null) {
            JdkSetupStep.$$$reportNull$$$0(0);
        }
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(VirtualFile[] files2) {
                for (VirtualFile virtualFile : files2) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    validation2.fun((Object)file);
                }
            }
        };
        if (SystemInfo.isMac) {
            descriptor2.withShowHiddenFiles(true);
        }
        descriptor2.setTitle("Choose JDK Location");
        FileChooserDescriptor fileChooserDescriptor2 = descriptor2;
        if (fileChooserDescriptor2 == null) {
            JdkSetupStep.$$$reportNull$$$0(1);
        }
        return fileChooserDescriptor2;
    }

    private void updateIsValidPath() {
        this.invokeUpdate(null);
    }

    @Nullable
    private File validateJdkPath(@NotNull File file) {
        File possiblePath;
        if (file == null) {
            JdkSetupStep.$$$reportNull$$$0(2);
        }
        if ((possiblePath = IdeSdks.getInstance().validateJdkPath(file)) != null) {
            this.setJdkLocationComboBox(possiblePath);
            return possiblePath;
        }
        return null;
    }

    @Override
    public void init() {
        IdeSdks ideSdks = IdeSdks.getInstance();
        File embeddedPath = ideSdks.getEmbeddedJdkPath();
        this.setJdkLocationComboBox(embeddedPath);
    }

    @Override
    @Nullable
    public JLabel getMessageLabel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJdkLocationComboBox;
    }

    @Override
    public boolean validate() {
        if (!this.isValidJdkPath()) {
            return false;
        }
        return super.validate();
    }

    private boolean isValidJdkPath() {
        return this.validateJdkPath(this.getJdkLocation()) != null;
    }

    @Override
    public boolean commitStep() {
        if (!this.isValidJdkPath()) {
            return false;
        }
        File path2 = FilePaths.toSystemDependentPath((String)this.getJdkLocation().getPath());
        ApplicationManager.getApplication().runWriteAction(() -> IdeSdks.getInstance().setJdkPath(path2));
        this.myState.put(WizardConstants.KEY_JDK_LOCATION, path2.getPath());
        return true;
    }

    @NotNull
    private File getJdkLocation() {
        File file = IdeSdksConfigurable.getLocationFromComboBoxWithBrowseButton(this.myJdkLocationComboBox);
        if (file == null) {
            JdkSetupStep.$$$reportNull$$$0(3);
        }
        return file;
    }

    @Override
    public boolean isStepVisible() {
        return (Boolean)StudioFlags.NPW_SHOW_JDK_STEP.get() != false && Boolean.TRUE.equals(this.myState.get(FirstRunWizard.KEY_CUSTOM_INSTALL));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validation";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/wizard/deprecated/JdkSetupStep";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/wizard/deprecated/JdkSetupStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingleFolderDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSingleFolderDescriptor";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validateJdkPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JBScrollPane jBScrollPane;
        this.createUIComponents();
        this.myContents = jBScrollPane = new JBScrollPane();
        jBScrollPane.setPreferredSize(new Dimension(548, 315));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Select the Java Development Kit (JDK) you want Gradle to use when building your project.");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JBLabel jBLabel2 = this.myJdkLocationHelp;
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 10, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myJdkLocationComboBox = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(2, 0, 1, 1, 9, 0, 3, 3, new Dimension(518, -1), new Dimension(518, -1), new Dimension(518, -1)));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContents;
    }
}

