/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.Uninstaller;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.installer.BasicInstallerFactory;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.ThrottledProgressWrapper;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ComponentInstaller {
    private final AndroidSdkHandler mySdkHandler;

    public ComponentInstaller(@NotNull AndroidSdkHandler sdkHandler) {
        if (sdkHandler == null) {
            ComponentInstaller.$$$reportNull$$$0(0);
        }
        this.mySdkHandler = sdkHandler;
    }

    public List<RemotePackage> getPackagesToInstall(@NotNull Iterable<? extends InstallableComponent> components) throws SdkQuickfixUtils.PackageResolutionException {
        if (components == null) {
            ComponentInstaller.$$$reportNull$$$0(1);
        }
        HashSet<UpdatablePackage> requests = new HashSet<UpdatablePackage>();
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = this.mySdkHandler.getSdkManager((ProgressIndicator)progress);
        for (InstallableComponent installableComponent : components) {
            requests.addAll(installableComponent.getPackagesToInstall());
        }
        ArrayList<UpdatablePackage> resolved = new ArrayList<UpdatablePackage>();
        resolved.addAll(SdkQuickfixUtils.resolve(requests, sdkManager.getPackages()));
        ArrayList<RemotePackage> arrayList = new ArrayList<RemotePackage>();
        for (UpdatablePackage p : resolved) {
            arrayList.add(p.getRemote());
        }
        return arrayList;
    }

    public void installPackages(@NotNull List<RemotePackage> packages, @NotNull Downloader downloader, @NotNull ProgressIndicator progress) throws WizardException {
        if (packages == null) {
            ComponentInstaller.$$$reportNull$$$0(2);
        }
        if (downloader == null) {
            ComponentInstaller.$$$reportNull$$$0(3);
        }
        if (progress == null) {
            ComponentInstaller.$$$reportNull$$$0(4);
        }
        progress = new ThrottledProgressWrapper((ProgressIndicator)progress);
        RepoManager sdkManager = this.mySdkHandler.getSdkManager(progress);
        double progressMax = 0.0;
        double progressIncrement = 0.9 / ((double)packages.size() * 2.0);
        Iterator<RemotePackage> iterator = packages.iterator();
        while (iterator.hasNext()) {
            BasicInstallerFactory factory = new BasicInstallerFactory();
            RemotePackage request = iterator.next();
            Installer installer = factory.createInstaller(request, sdkManager, downloader, this.mySdkHandler.getFileOp());
            if (installer.prepare(progress.createSubProgress(progressMax += progressIncrement))) {
                installer.complete(progress.createSubProgress(progressMax + progressIncrement));
            }
            progress.setFraction(progressMax += progressIncrement);
        }
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progress.createSubProgress(1.0), null, null);
    }

    public void ensureSdkPackagesUninstalled(@NotNull Collection<String> packageNames, @NotNull ProgressIndicator progress) throws WizardException {
        if (packageNames == null) {
            ComponentInstaller.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            ComponentInstaller.$$$reportNull$$$0(6);
        }
        RepoManager sdkManager = this.mySdkHandler.getSdkManager(progress);
        RepositoryPackages packages = sdkManager.getPackages();
        Map localPackages = packages.getLocalPackages();
        ArrayList<LocalPackage> packagesToUninstall = new ArrayList<LocalPackage>();
        for (String packageName : packageNames) {
            LocalPackage p = (LocalPackage)localPackages.get(packageName);
            if (p != null) {
                packagesToUninstall.add(p);
                continue;
            }
            progress.logInfo(String.format("Package '%1$s' does not appear to be installed - ignoring", packageName));
        }
        double progressMax = 0.0;
        double progressIncrement = 0.9 / ((double)packagesToUninstall.size() * 2.0);
        Iterator iterator = packagesToUninstall.iterator();
        while (iterator.hasNext()) {
            BasicInstallerFactory factory = new BasicInstallerFactory();
            LocalPackage request = (LocalPackage)iterator.next();
            Uninstaller uninstaller = factory.createUninstaller(request, sdkManager, this.mySdkHandler.getFileOp());
            if (uninstaller.prepare(progress.createSubProgress(progressMax += progressIncrement))) {
                uninstaller.complete(progress.createSubProgress(progressMax + progressIncrement));
            }
            progress.setFraction(progressMax += progressIncrement);
        }
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progress.createSubProgress(1.0), null, null);
        progress.setFraction(1.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/welcome/install/ComponentInstaller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackagesToInstall";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "installPackages";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureSdkPackagesUninstalled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

