/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.config;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.google.common.base.MoreObjects;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.BuildNumber;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0006J\b\u0010\u0014\u001a\u00020\bH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/welcome/config/InstallerData;", "", "androidSrc", "Ljava/io/File;", "androidDest", "createAvd", "", "timestamp", "", "version", "(Ljava/io/File;Ljava/io/File;ZLjava/lang/String;Ljava/lang/String;)V", "getAndroidDest", "()Ljava/io/File;", "getAndroidSrc", "isCurrentVersion", "()Z", "getTimestamp", "()Ljava/lang/String;", "hasValidSdkLocation", "shouldCreateAvd", "toString", "intellij.android.core"})
public final class InstallerData {
    @Nullable
    private final File androidSrc;
    @Nullable
    private final File androidDest;
    private final boolean createAvd;
    @Nullable
    private final String timestamp;
    private final String version;

    public final boolean isCurrentVersion() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        int[] nArray = buildNumber.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"ApplicationInfo.getInstance().build.components");
        Integer n = ArraysKt.lastOrNull((int[])nArray);
        return Intrinsics.areEqual((Object)String.valueOf(n != null ? n : 0), (Object)this.version);
    }

    public final boolean shouldCreateAvd() {
        return this.createAvd;
    }

    @NotNull
    public String toString() {
        String string = MoreObjects.toStringHelper((Object)this).add("androidsdk.repo", (Object)this.androidSrc).add("androidsdk.dir", (Object)this.androidDest).add("create.avd", this.createAvd).add("install.timestamp", (Object)this.timestamp).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MoreObjects.toStringHelp\u2026imestamp)\n    .toString()");
        return string;
    }

    public final boolean hasValidSdkLocation() {
        if (this.androidDest == null) {
            return false;
        }
        Validator.Severity severity = PathValidator.Companion.forAndroidSdkLocation().validate(this.androidDest).getSeverity();
        return severity != Validator.Severity.ERROR;
    }

    @Nullable
    public final File getAndroidSrc() {
        return this.androidSrc;
    }

    @Nullable
    public final File getAndroidDest() {
        return this.androidDest;
    }

    @Nullable
    public final String getTimestamp() {
        return this.timestamp;
    }

    public InstallerData(@Nullable File androidSrc, @Nullable File androidDest, boolean createAvd, @Nullable String timestamp, @Nullable String version2) {
        this.androidSrc = androidSrc;
        this.androidDest = androidDest;
        this.createAvd = createAvd;
        this.timestamp = timestamp;
        this.version = version2;
    }
}

