/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.SettingsController;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.SourcesTableModel;
import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class UpdateSitesPanel {
    private JPanel myRootPanel;
    private TableView myUpdateSitesTable;
    private JPanel mySourcesPanel;
    private JPanel mySourcesLoadingPanel;
    private AsyncProcessIcon mySourcesLoadingIcon;
    private JCheckBox myForceHttp;
    private JCheckBox myDisableSdkPatches;
    private SourcesTableModel mySourcesTableModel;
    private static SettingsController ourSettingsController = StudioSettingsController.getInstance();

    public UpdateSitesPanel(@NotNull Runnable refreshCallback) {
        if (refreshCallback == null) {
            UpdateSitesPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.init(refreshCallback);
    }

    private void init(@NotNull Runnable refreshCallback) {
        if (refreshCallback == null) {
            UpdateSitesPanel.$$$reportNull$$$0(1);
        }
        this.mySourcesTableModel.setRefreshCallback(refreshCallback);
    }

    private void createUIComponents() {
        this.mySourcesLoadingIcon = new AsyncProcessIcon(CommonBundle.getLoadingTreeNodeText());
        this.mySourcesTableModel = new SourcesTableModel(() -> this.mySourcesLoadingPanel.setVisible(true), () -> this.mySourcesLoadingPanel.setVisible(false), ModalityState.current());
        this.myUpdateSitesTable = new TableView((ListTableModel)this.mySourcesTableModel);
        ToolbarDecorator userDefinedDecorator = ToolbarDecorator.createDecorator((JTable)this.myUpdateSitesTable);
        this.mySourcesPanel = this.addExtraActions(userDefinedDecorator).createPanel();
        SdkUpdaterConfigPanel.setTableProperties((JTable)this.myUpdateSitesTable, null);
    }

    private ToolbarDecorator addExtraActions(ToolbarDecorator decorator) {
        return decorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                UpdateSitesPanel.this.mySourcesTableModel.editRow(UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRow());
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                return UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRowCount() == 1 && UpdateSitesPanel.this.mySourcesTableModel.isEditable(UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRow());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/updater/configure/UpdateSitesPanel$5", "isEnabled"));
            }
        }).setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                return UpdateSitesPanel.this.mySourcesTableModel.isEditable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/updater/configure/UpdateSitesPanel$4", "isEnabled"));
            }
        }).addExtraAction(new AnActionButton(AndroidBundle.messagePointer("action.AnActionButton.update.sites.text.select.all", new Object[0]), AllIcons.Actions.Selectall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                UpdateSitesPanel.this.mySourcesTableModel.setAllEnabled(true);
            }

            public boolean isEnabled() {
                return UpdateSitesPanel.this.mySourcesTableModel.hasEditableRows();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/updater/configure/UpdateSitesPanel$3", "actionPerformed"));
            }
        }).addExtraAction(new AnActionButton(AndroidBundle.messagePointer("action.AnActionButton.update.sites.text.deselect.all", new Object[0]), AllIcons.Actions.Unselectall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                UpdateSitesPanel.this.mySourcesTableModel.setAllEnabled(false);
            }

            public boolean isEnabled() {
                return UpdateSitesPanel.this.mySourcesTableModel.hasEditableRows();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/updater/configure/UpdateSitesPanel$2", "actionPerformed"));
            }
        }).setMoveDownAction(null).setMoveUpAction(null).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRowCount() < 1) {
                    return false;
                }
                for (int i2 : UpdateSitesPanel.this.myUpdateSitesTable.getSelectedRows()) {
                    if (UpdateSitesPanel.this.mySourcesTableModel.isEditable(i2)) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/updater/configure/UpdateSitesPanel$1", "isEnabled"));
            }
        });
    }

    public boolean isModified() {
        return this.mySourcesTableModel.isSourcesModified() || ourSettingsController.getForceHttp() != this.myForceHttp.isSelected() || ourSettingsController.getDisableSdkPatches() != this.myDisableSdkPatches.isSelected();
    }

    public void reset() {
        this.mySourcesTableModel.reset();
        this.myForceHttp.setSelected(ourSettingsController.getForceHttp());
        this.myDisableSdkPatches.setSelected(ourSettingsController.getDisableSdkPatches());
    }

    public void setConfigurable(@NotNull SdkUpdaterConfigurable configurable) {
        if (configurable == null) {
            UpdateSitesPanel.$$$reportNull$$$0(2);
        }
        this.mySourcesTableModel.setConfigurable(configurable);
    }

    public void save() {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                UpdateSitesPanel.this.mySourcesTableModel.save(ProgressManager.getInstance().getProgressIndicator());
                ourSettingsController.setForceHttp(UpdateSitesPanel.this.myForceHttp.isSelected());
                ourSettingsController.setDisableSdkPatches(UpdateSitesPanel.this.myDisableSdkPatches.isSelected());
            }
        }, "Saving Sources", false, null, (JComponent)this.myRootPanel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshCallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/updater/configure/UpdateSitesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setConfigurable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/AndroidBundle", UpdateSitesPanel.class).getString("label.these.are.the.sites"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, new Dimension(600, -1), new Dimension(600, -1)));
        JPanel jPanel3 = this.mySourcesPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.mySourcesLoadingPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/AndroidBundle", UpdateSitesPanel.class).getString("label.loading.sources"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.mySourcesLoadingIcon;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myForceHttp = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/AndroidBundle", UpdateSitesPanel.class).getString("checkbox.force.https.sources"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDisableSdkPatches = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/AndroidBundle", UpdateSitesPanel.class).getString("checkbox.disable.sdk.diff.patching"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("messages/AndroidBundle").getString("tooltip.disabling.sdk.diff.patching"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jPanel2.add((Component)jBLabel3, new GridConstraints(3, 1, 1, 2, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

