/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater;

import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.RepoProgressIndicatorAdapter;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.updater.UpdatablePackage;
import com.android.tools.idea.updater.UpdateInfoDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkComponentSource
implements ExternalComponentSource {
    public static final String NAME = "Android SDK";
    public static final String PREVIEW_CHANNEL = "Preview Channel";
    public static final String STABLE_CHANNEL = "Stable Channel";
    private RepositoryPackages myPackages;
    private static final StudioLoggerProgressIndicator LOGGER = new StudioLoggerProgressIndicator(SdkComponentSource.class);

    private void initIfNecessary(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        RepoManager mgr = this.getRepoManager();
        Object progress = indicator != null ? new RepoProgressIndicatorAdapter(indicator) : LOGGER;
        if (mgr.loadSynchronously(TimeUnit.MINUTES.toMillis(1L), (ProgressIndicator)progress, this.getDownloader(), this.getSettingsController())) {
            this.myPackages = mgr.getPackages();
        }
    }

    @VisibleForTesting
    @NotNull
    SettingsController getSettingsController() {
        SettingsController settingsController = StudioSettingsController.getInstance();
        if (settingsController == null) {
            SdkComponentSource.$$$reportNull$$$0(0);
        }
        return settingsController;
    }

    @VisibleForTesting
    @NotNull
    Downloader getDownloader() {
        return new StudioDownloader();
    }

    @VisibleForTesting
    @NotNull
    RepoManager getRepoManager() {
        RepoManager repoManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getSdkManager((ProgressIndicator)LOGGER);
        if (repoManager == null) {
            SdkComponentSource.$$$reportNull$$$0(1);
        }
        return repoManager;
    }

    public void installUpdates(@NotNull Collection<UpdatableExternalComponent> request) {
        if (request == null) {
            SdkComponentSource.$$$reportNull$$$0(2);
        }
        ArrayList<RemotePackage> packages = new ArrayList<RemotePackage>();
        for (UpdatableExternalComponent p : request) {
            packages.add((RemotePackage)p.getKey());
        }
        new UpdateInfoDialog(true, packages).show();
    }

    @NotNull
    public Collection<UpdatableExternalComponent> getAvailableVersions(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator, @Nullable UpdateSettings updateSettings) {
        return this.getComponents(indicator, updateSettings, true);
    }

    @NotNull
    public Collection<UpdatableExternalComponent> getCurrentVersions() {
        return this.getComponents(null, null, false);
    }

    @NotNull
    private Collection<UpdatableExternalComponent> getComponents(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator, @Nullable UpdateSettings settings, boolean remote) {
        ArrayList<UpdatableExternalComponent> result2 = new ArrayList<UpdatableExternalComponent>();
        this.initIfNecessary(indicator);
        ImmutableSet ignored = settings != null ? Sets.newHashSet((Iterable)settings.getIgnoredBuildNumbers()) : ImmutableSet.of();
        for (com.android.repository.api.UpdatablePackage p : this.myPackages.getConsolidatedPkgs().values()) {
            if (remote) {
                RemotePackage remotePackage;
                if (!p.hasRemote() || ignored.contains(SdkComponentSource.getPackageRevisionId((RepoPackage)(remotePackage = p.getRemote())))) continue;
                result2.add(new UpdatablePackage((RepoPackage)remotePackage));
                continue;
            }
            if (!p.hasLocal()) continue;
            result2.add(new UpdatablePackage((RepoPackage)p.getLocal()));
        }
        ArrayList<UpdatableExternalComponent> arrayList = result2;
        if (arrayList == null) {
            SdkComponentSource.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    static String getPackageRevisionId(@NotNull RepoPackage p) {
        if (p == null) {
            SdkComponentSource.$$$reportNull$$$0(4);
        }
        String string = String.format("%1$s#%2$s", p.getPath(), p.getVersion().toString());
        if (string == null) {
            SdkComponentSource.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public Collection<? extends Pair<String, String>> getStatuses() {
        Revision platformToolsRevision = null;
        LocalPackage platformTools = (LocalPackage)this.getRepoManager().getPackages().getLocalPackages().get("platform-tools");
        if (platformTools != null) {
            platformToolsRevision = platformTools.getVersion();
        }
        Revision platformRevision = null;
        AndroidVersion platformVersion = null;
        for (LocalPackage info : this.getRepoManager().getPackages().getLocalPackagesForPrefix("platforms")) {
            if (!(info.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType)) continue;
            DetailsTypes.PlatformDetailsType details = (DetailsTypes.PlatformDetailsType)info.getTypeDetails();
            AndroidVersion testVersion = new AndroidVersion(details.getApiLevel(), details.getCodename());
            if (platformVersion != null && platformVersion.compareTo(testVersion) >= 0) continue;
            platformRevision = info.getVersion();
            platformVersion = testVersion;
        }
        ArrayList<Pair> result2 = new ArrayList<Pair>();
        if (platformToolsRevision != null) {
            result2.add(Pair.create((Object)"Android Platform Tools:", (Object)platformToolsRevision.toString()));
        }
        if (platformVersion != null) {
            result2.add(Pair.create((Object)"Android Platform Version:", (Object)String.format("%1$s revision %2$s", platformVersion.getCodename() != null ? platformVersion.getCodename() : SdkVersionInfo.getAndroidName((int)platformVersion.getApiLevel()), platformRevision)));
        }
        ArrayList<Pair> arrayList = result2;
        if (arrayList == null) {
            SdkComponentSource.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public List<String> getAllChannels() {
        return ImmutableList.of((Object)STABLE_CHANNEL, (Object)PREVIEW_CHANNEL);
    }

    public boolean isEnabled() {
        return AndroidSdkUtils.isAndroidSdkManagerEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/updater/SdkComponentSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsController";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/updater/SdkComponentSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageRevisionId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatuses";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installUpdates";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPackageRevisionId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

