/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionHandlerBase;
import com.android.tools.idea.common.surface.InteractionHandlerKt;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.CanvasResizeInteraction;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.MarqueeInteraction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.UnmodifiableIterator;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\bH\u0016J\"\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\"\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\bH\u0016J$\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\bH\u0016J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\"\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlInteractionHandler;", "Lcom/android/tools/idea/common/surface/InteractionHandlerBase;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "clickPreview", "", "x", "", "y", "needsFocusEditor", "", "createInteractionOnDrag", "Lcom/android/tools/idea/common/surface/Interaction;", "mouseX", "mouseY", "modifiersEx", "createInteractionOnPressed", "doubleClick", "getCursorWhenNoInteraction", "Ljava/awt/Cursor;", "isInResizeZone", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "singleClick", "intellij.android.designer"})
public final class NlInteractionHandler
extends InteractionHandlerBase {
    private final DesignSurface surface;

    @Override
    @Nullable
    public Interaction createInteractionOnPressed(int mouseX, int mouseY, int modifiersEx) {
        SceneView view;
        SceneView sceneView = this.surface.getSceneView(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sceneView, (String)"surface.getSceneView(mou\u2026X, mouseY) ?: return null");
        SceneView sceneView2 = view = sceneView;
        if (sceneView2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.ScreenView");
        }
        ScreenView screenView = (ScreenView)sceneView2;
        Scene scene = ((ScreenView)view).getScene();
        Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"view.scene");
        if (scene.isResizeAvailable() && this.isInResizeZone(view, mouseX, mouseY)) {
            LayoutlibSceneManager layoutlibSceneManager = ((ScreenView)view).getSceneManager();
            Intrinsics.checkNotNullExpressionValue((Object)layoutlibSceneManager, (String)"view.sceneManager");
            NlModel nlModel = layoutlibSceneManager.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"view.sceneManager.model");
            Configuration configuration = nlModel.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"view.sceneManager.model.configuration");
            Configuration configuration2 = configuration;
            DesignSurface designSurface = this.surface;
            if (designSurface == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.NlDesignSurface");
            }
            return new CanvasResizeInteraction((NlDesignSurface)designSurface, screenView, configuration2);
        }
        SelectionModel selectionModel = screenView.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"screenView.selectionModel");
        SelectionModel selectionModel2 = selectionModel;
        NlComponent component3 = Coordinates.findComponent(screenView, mouseX, mouseY);
        if (component3 == null) {
            if (!selectionModel2.isEmpty()) {
                component3 = selectionModel2.getPrimary();
            } else {
                return null;
            }
        }
        Interaction interaction = null;
        if (!selectionModel2.isEmpty()) {
            ViewGroupHandler handler;
            NlComponent parent;
            NlComponent primary;
            SelectionModel selectionModel3 = screenView.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel3, (String)"screenView.selectionModel");
            NlComponent nlComponent = primary = selectionModel3.getPrimary();
            NlComponent nlComponent2 = parent = nlComponent != null ? nlComponent.getParent() : null;
            if (parent != null && (handler = NlComponentHelperKt.getViewGroupHandler(parent)) != null) {
                interaction = handler.createInteraction(screenView, mouseX, mouseY, primary);
            }
        }
        if (interaction == null) {
            ViewGroupHandler viewGroupHandler;
            NlComponent nlComponent = component3;
            ViewGroupHandler viewGroupHandler2 = viewGroupHandler = nlComponent != null ? NlComponentHelperKt.getViewGroupHandler(nlComponent) : null;
            if (viewGroupHandler != null) {
                NlComponent nlComponent3 = component3;
                Intrinsics.checkNotNull((Object)nlComponent3);
                interaction = viewGroupHandler.createInteraction(screenView, mouseX, mouseY, nlComponent3);
            }
        }
        if (interaction == null) {
            interaction = new SceneInteraction(screenView);
        }
        return interaction;
    }

    private final boolean isInResizeZone(SceneView sceneView, int mouseX, int mouseY) {
        Dimension dimension2 = sceneView.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"sceneView.size");
        Dimension size = dimension2;
        Rectangle resizeZone = new Rectangle(sceneView.getX() + size.width, sceneView.getY() + size.height, 48, 48);
        return resizeZone.contains(mouseX, mouseY);
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        NlComponent primarySelectedComponent;
        SceneComponent primary;
        SceneView sceneView = this.surface.getSceneView(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sceneView, (String)"surface.getSceneView(mou\u2026X, mouseY) ?: return null");
        SceneView sceneView2 = sceneView;
        Scene scene = sceneView2.getScene();
        Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"sceneView.scene");
        Scene scene2 = scene;
        SelectionModel selectionModel = sceneView2.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"sceneView.selectionModel");
        SelectionModel selectionModel2 = selectionModel;
        int xDp = Coordinates.getAndroidXDip(sceneView2, mouseX);
        int yDp = Coordinates.getAndroidYDip(sceneView2, mouseY);
        NlModel nlModel = sceneView2.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"sceneView.model");
        NlModel model2 = nlModel;
        SceneComponent component3 = null;
        if (selectionModel2.isEmpty() && !model2.getComponents().isEmpty()) {
            Object object = model2.getComponents().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"model.components[0]");
            NlComponent nlComponent = ((NlComponent)object).getRoot();
            Intrinsics.checkNotNull((Object)nlComponent);
            selectionModel2.setSelection(CollectionsKt.listOf((Object)nlComponent));
        }
        if ((primary = scene2.getSceneComponent(primarySelectedComponent = selectionModel2.getPrimary())) != null && primary.getParent() != null && primary.containsX(xDp) && primary.containsY(yDp)) {
            component3 = primary;
        }
        if (component3 == null) {
            component3 = scene2.findComponent(sceneView2.getContext(), xDp, yDp);
        }
        SceneComponent sceneComponent = component3;
        if ((sceneComponent != null ? sceneComponent.getParent() : null) == null) {
            return new MarqueeInteraction(sceneView2);
        }
        SceneComponent sceneComponent2 = primary;
        if (sceneComponent2 == null) {
            sceneComponent2 = component3;
        }
        SceneComponent primaryDraggedComponent = sceneComponent2;
        List dragged = null;
        if (this.surface.getSelectionModel().isSelected(component3.getNlComponent())) {
            boolean bl = false;
            List selectedDraggedComponents = new ArrayList();
            NlComponent primaryNlComponent = null;
            if (primaryDraggedComponent.getParent() == null) {
                primaryNlComponent = null;
            } else {
                primaryNlComponent = primaryDraggedComponent.getNlComponent();
                selectedDraggedComponents.add(primaryNlComponent);
            }
            SelectionModel selectionModel3 = this.surface.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel3, (String)"surface.selectionModel");
            UnmodifiableIterator unmodifiableIterator = selectionModel3.getSelection().iterator();
            while (unmodifiableIterator.hasNext()) {
                NlComponent selected;
                NlComponent nlComponent = selected = (NlComponent)unmodifiableIterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"selected");
                if (nlComponent.isRoot() || selected == primaryNlComponent) continue;
                selectedDraggedComponents.add(selected);
            }
            dragged = selectedDraggedComponents;
        } else {
            NlComponent nlComponent = primaryDraggedComponent.getNlComponent();
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"primaryDraggedComponent.nlComponent");
            dragged = CollectionsKt.listOf((Object)nlComponent);
        }
        return new DragDropInteraction(this.surface, dragged);
    }

    @Override
    public void singleClick(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        DesignSurface designSurface = this.surface;
        if (designSurface == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.NlDesignSurface");
        }
        if (((NlDesignSurface)designSurface).isPreviewSurface()) {
            this.clickPreview(x, y, false);
        } else {
            super.singleClick(x, y, modifiersEx);
        }
    }

    @Override
    public void doubleClick(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        DesignSurface designSurface = this.surface;
        if (designSurface == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.NlDesignSurface");
        }
        if (((NlDesignSurface)designSurface).isPreviewSurface()) {
            this.clickPreview(x, y, true);
        } else {
            super.doubleClick(x, y, modifiersEx);
        }
    }

    private final void clickPreview(int x, int y, boolean needsFocusEditor) {
        SceneView sceneView = this.surface.getSceneView(x, y);
        if (sceneView == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sceneView, (String)"surface.getSceneView(x, y) ?: return");
        SceneView sceneView2 = sceneView;
        NlComponent component3 = Coordinates.findComponent(sceneView2, x, y);
        DesignSurface designSurface = this.surface;
        if (designSurface == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.NlDesignSurface");
        }
        NlDesignSurface.NavigationHandler navigationHandler = ((NlDesignSurface)designSurface).getNavigationHandler();
        if (((NlDesignSurface)this.surface).getNavigationHandler() != null) {
            NlDesignSurface.NavigationHandler navigationHandler2 = navigationHandler;
            Intrinsics.checkNotNull((Object)navigationHandler2);
            navigationHandler2.handleNavigate(sceneView2, ((NlDesignSurface)this.surface).getModels(), needsFocusEditor, component3);
            return;
        }
        if (component3 != null) {
            InteractionHandlerKt.navigateToComponent(component3, needsFocusEditor);
        }
    }

    @Override
    @Nullable
    public Cursor getCursorWhenNoInteraction(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        SceneView sceneView = this.surface.getSceneView(mouseX, mouseY);
        if (sceneView != null) {
            Scene scene = sceneView.getScene();
            Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"sceneView.scene");
            if (scene.isResizeAvailable() && this.isInResizeZone(sceneView, mouseX, mouseY)) {
                return Cursor.getPredefinedCursor(5);
            }
        }
        return super.getCursorWhenNoInteraction(mouseX, mouseY, modifiersEx);
    }

    public NlInteractionHandler(@NotNull DesignSurface surface2) {
        Intrinsics.checkNotNullParameter((Object)((Object)surface2), (String)"surface");
        super(surface2);
        this.surface = surface2;
    }
}

