/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.actions.LayoutPreviewHandler;
import com.android.tools.idea.actions.LayoutPreviewHandlerKt;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.adaptiveicon.ShapeMenuAction;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.error.RenderIssueProvider;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.NlDesignSurfaceActionHandler;
import com.android.tools.idea.uibuilder.surface.NlInteractionHandler;
import com.android.tools.idea.uibuilder.surface.SceneMode;
import com.android.tools.idea.uibuilder.surface.SingleDirectionLayoutManager;
import com.android.tools.idea.uibuilder.surface.SurfaceLayoutManager;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDesignSurface
extends DesignSurface
implements ViewGroupHandler.AccessoryPanelVisibility,
LayoutPreviewHandler {
    private boolean myPreviewWithToolsAttributes;
    private static final double DEFAULT_MIN_SCALE = 0.1;
    private static final double DEFAULT_MAX_SCALE = 10.0;
    @NotNull
    private SceneMode mySceneMode;
    private boolean myIsCanvasResizing;
    private boolean myShowModelNames;
    private boolean myMockupVisible;
    private MockupEditor myMockupEditor;
    private boolean myCentered;
    private final boolean myIsInPreview;
    private ShapeMenuAction.AdaptiveIconShape myAdaptiveIconShape;
    private final RenderListener myRenderListener;
    private RenderIssueProvider myRenderIssueProvider;
    private AccessoryPanel myAccessoryPanel;
    @NotNull
    private final NlAnalyticsManager myAnalyticsManager;
    private final BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> mySceneManagerProvider;
    @NotNull
    private final SurfaceLayoutManager myLayoutManager;
    @Nullable
    private final NavigationHandler myNavigationHandler;
    private final double myMinScale;
    private final double myMaxScale;
    private boolean myIsRenderingSynchronously;
    private boolean myIsAnimationScrubbing;

    /*
     * WARNING - void declaration
     */
    private NlDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable, boolean isInPreview, boolean isEditable, boolean showModelNames, @NotNull BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> sceneManagerProvider, @NotNull SurfaceLayoutManager layoutManager, @NotNull Function<DesignSurface, ActionManager<? extends DesignSurface>> actionManagerProvider, @NotNull Function<DesignSurface, InteractionHandler> interactionHandlerProvider, @NotNull DesignSurface.State defaultSurfaceState, @Nullable NavigationHandler navigationHandler, double minScale, double d) {
        void maxScale;
        if (project == null) {
            NlDesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(1);
        }
        if (sceneManagerProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(2);
        }
        if (layoutManager == null) {
            NlDesignSurface.$$$reportNull$$$0(3);
        }
        if (actionManagerProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(4);
        }
        if (interactionHandlerProvider == null) {
            NlDesignSurface.$$$reportNull$$$0(5);
        }
        if (defaultSurfaceState == null) {
            NlDesignSurface.$$$reportNull$$$0(6);
        }
        super(project, parentDisposable, actionManagerProvider, interactionHandlerProvider, defaultSurfaceState, isEditable);
        this.myPreviewWithToolsAttributes = true;
        this.mySceneMode = SceneMode.Companion.loadPreferredMode();
        this.myIsCanvasResizing = false;
        this.myShowModelNames = false;
        this.myAdaptiveIconShape = ShapeMenuAction.AdaptiveIconShape.getDefaultShape();
        this.myRenderListener = this::modelRendered;
        this.myAccessoryPanel = new AccessoryPanel(AccessoryPanel.Type.SOUTH_PANEL, true);
        this.myIsRenderingSynchronously = false;
        this.myIsAnimationScrubbing = false;
        this.myAnalyticsManager = new NlAnalyticsManager(this);
        this.myAccessoryPanel.setSurface(this);
        this.myIsInPreview = isInPreview;
        this.myShowModelNames = showModelNames;
        this.myLayoutManager = layoutManager;
        this.mySceneManagerProvider = sceneManagerProvider;
        this.myNavigationHandler = navigationHandler;
        if (this.myNavigationHandler != null) {
            Disposer.register((Disposable)this, (Disposable)this.myNavigationHandler);
        }
        this.myMinScale = minScale;
        this.myMaxScale = maxScale;
    }

    @NotNull
    public static LayoutlibSceneManager defaultSceneManagerProvider(@NotNull NlDesignSurface surface2, @NotNull NlModel model2) {
        if (surface2 == null) {
            NlDesignSurface.$$$reportNull$$$0(7);
        }
        if (model2 == null) {
            NlDesignSurface.$$$reportNull$$$0(8);
        }
        return new LayoutlibSceneManager(model2, surface2, () -> RenderSettings.getProjectSettings(model2.getProject()));
    }

    @NotNull
    public static SurfaceLayoutManager createDefaultSurfaceLayoutManager() {
        return new SingleDirectionLayoutManager(50, 50, 48, 48);
    }

    @NotNull
    public static ActionManager<? extends NlDesignSurface> defaultActionManagerProvider(@NotNull DesignSurface surface2) {
        if (surface2 == null) {
            NlDesignSurface.$$$reportNull$$$0(9);
        }
        return new NlActionManager((NlDesignSurface)surface2);
    }

    @NotNull
    public static NlInteractionHandler defaultInteractionHandlerProvider(@NotNull DesignSurface surface2) {
        if (surface2 == null) {
            NlDesignSurface.$$$reportNull$$$0(10);
        }
        return new NlInteractionHandler(surface2);
    }

    @NotNull
    public static Builder builder(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NlDesignSurface.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(12);
        }
        return new Builder(project, parentDisposable);
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model2) {
        if (model2 == null) {
            NlDesignSurface.$$$reportNull$$$0(13);
        }
        LayoutlibSceneManager manager = this.mySceneManagerProvider.apply(this, model2);
        manager.addRenderListener(this.myRenderListener);
        LayoutlibSceneManager layoutlibSceneManager = manager;
        if (layoutlibSceneManager == null) {
            NlDesignSurface.$$$reportNull$$$0(14);
        }
        return layoutlibSceneManager;
    }

    @Override
    @NotNull
    public NlAnalyticsManager getAnalyticsManager() {
        NlAnalyticsManager nlAnalyticsManager = this.myAnalyticsManager;
        if (nlAnalyticsManager == null) {
            NlDesignSurface.$$$reportNull$$$0(15);
        }
        return nlAnalyticsManager;
    }

    public boolean isPreviewSurface() {
        return this.myIsInPreview;
    }

    public void setResizeMode(boolean isResizing) {
        this.myIsCanvasResizing = isResizing;
    }

    public boolean isCanvasResizing() {
        return this.myIsCanvasResizing;
    }

    @Override
    public boolean isLayoutDisabled() {
        return this.myIsCanvasResizing;
    }

    public boolean isShowModelNames() {
        return this.myShowModelNames;
    }

    @NotNull
    public SceneMode getSceneMode() {
        SceneMode sceneMode = this.mySceneMode;
        if (sceneMode == null) {
            NlDesignSurface.$$$reportNull$$$0(16);
        }
        return sceneMode;
    }

    @Nullable
    public NavigationHandler getNavigationHandler() {
        return this.myNavigationHandler;
    }

    public void setScreenMode(@NotNull SceneMode sceneMode, boolean setAsDefault) {
        if (sceneMode == null) {
            NlDesignSurface.$$$reportNull$$$0(17);
        }
        if (setAsDefault) {
            SceneMode.Companion.savePreferredMode(sceneMode);
        }
        if (sceneMode != this.mySceneMode) {
            this.mySceneMode = sceneMode;
            LayoutlibSceneManager manager = this.getSceneManager();
            if (manager != null) {
                manager.updateSceneView();
                manager.requestLayoutAndRender(false);
            }
            if (!this.contentResizeSkipped()) {
                this.zoomToFit();
            }
            this.layoutContent();
            this.updateScrolledAreaSize();
        }
    }

    @NotNull
    public static NlDesignSurface build(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NlDesignSurface.$$$reportNull$$$0(18);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(19);
        }
        NlDesignSurface nlDesignSurface = new Builder(project, parentDisposable).build();
        if (nlDesignSurface == null) {
            NlDesignSurface.$$$reportNull$$$0(20);
        }
        return nlDesignSurface;
    }

    @Override
    @Nullable
    public LayoutlibSceneManager getSceneManager() {
        return (LayoutlibSceneManager)super.getSceneManager();
    }

    public void forceLayersPaint(boolean value2) {
        for (Layer layer : this.getLayers()) {
            if (!(layer instanceof SceneLayer)) continue;
            SceneLayer sceneLayer = (SceneLayer)layer;
            sceneLayer.setTemporaryShow(value2);
            this.repaint();
        }
    }

    @Override
    @Nullable
    public SceneView getSceneView(int x, int y) {
        LayoutlibSceneManager manager;
        SceneView view = this.getHoverSceneView(x, y);
        if (view == null && (manager = this.getSceneManager()) != null) {
            view = manager.getSceneView();
        }
        return view;
    }

    @Override
    @NotNull
    public Rectangle getRenderableBoundsForInvisibleComponents(@NotNull SceneView sceneView, @Nullable Rectangle rectangle) {
        if (sceneView == null) {
            NlDesignSurface.$$$reportNull$$$0(21);
        }
        Rectangle rectangle2 = this.myLayoutManager.getRenderableBoundsForInvisibleComponents(sceneView, (List<? extends SceneView>)this.getSceneViews(), this.myScrollPane.getWidth(), this.myScrollPane.getHeight(), this.myScrollPane.getViewport().getViewRect(), rectangle);
        if (rectangle2 == null) {
            NlDesignSurface.$$$reportNull$$$0(22);
        }
        return rectangle2;
    }

    @Override
    @Nullable
    public SceneView getHoverSceneView(int x, int y) {
        ImmutableList<SceneView> sceneViews = this.getSceneViews();
        for (SceneView view : sceneViews) {
            if (view.getX() > x || x > view.getX() + view.getSize().width || view.getY() > y || y > view.getY() + view.getSize().height) continue;
            return view;
        }
        return null;
    }

    @NotNull
    private ImmutableList<SceneView> getSceneViews() {
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        for (SceneManager manager : this.getSceneManagers()) {
            SceneView view = manager.getSceneView();
            builder2.add((Object)view);
            SceneView secondarySceneView = ((LayoutlibSceneManager)manager).getSecondarySceneView();
            if (secondarySceneView == null) continue;
            builder2.add((Object)secondarySceneView);
        }
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            NlDesignSurface.$$$reportNull$$$0(23);
        }
        return immutableList;
    }

    @Override
    public Dimension getScrolledAreaSize() {
        ImmutableList<SceneView> sceneViews = this.getSceneViews();
        Dimension dimension2 = this.myLayoutManager.getRequiredSize((List<? extends SceneView>)sceneViews, this.myScrollPane.getWidth(), this.myScrollPane.getHeight(), null);
        if (dimension2.width <= 0 || dimension2.height <= 0) {
            return null;
        }
        dimension2.setSize(dimension2.width + 100, dimension2.height + 100);
        return dimension2;
    }

    public void setAdaptiveIconShape(@NotNull ShapeMenuAction.AdaptiveIconShape adaptiveIconShape) {
        if (adaptiveIconShape == null) {
            NlDesignSurface.$$$reportNull$$$0(24);
        }
        this.myAdaptiveIconShape = adaptiveIconShape;
    }

    @NotNull
    public ShapeMenuAction.AdaptiveIconShape getAdaptiveIconShape() {
        ShapeMenuAction.AdaptiveIconShape adaptiveIconShape = this.myAdaptiveIconShape;
        if (adaptiveIconShape == null) {
            NlDesignSurface.$$$reportNull$$$0(25);
        }
        return adaptiveIconShape;
    }

    @Override
    @NotNull
    public AccessoryPanel getAccessoryPanel() {
        AccessoryPanel accessoryPanel = this.myAccessoryPanel;
        if (accessoryPanel == null) {
            NlDesignSurface.$$$reportNull$$$0(26);
        }
        return accessoryPanel;
    }

    public void showInspectorAccessoryPanel(boolean show) {
        for (DesignSurfaceListener listener2 : ImmutableList.copyOf((Collection)this.myListeners)) {
            listener2.showAccessoryPanel(this, show);
        }
    }

    @Override
    public void show(@NotNull AccessoryPanel.Type type, boolean show) {
        if (type == null) {
            NlDesignSurface.$$$reportNull$$$0(27);
        }
        this.showInspectorAccessoryPanel(show);
    }

    public void setCentered(boolean centered) {
        this.myCentered = centered;
    }

    @Override
    public float getScreenScalingFactor() {
        return JBUIScale.sysScale((Component)((Object)this));
    }

    @Override
    @NotNull
    public ActionManager<NlDesignSurface> getActionManager() {
        ActionManager actionManager = super.getActionManager();
        if (actionManager == null) {
            NlDesignSurface.$$$reportNull$$$0(28);
        }
        return actionManager;
    }

    @Override
    public void layoutContent() {
        int availableWidth = this.myScrollPane.getWidth();
        int availableHeight = this.myScrollPane.getHeight();
        this.myLayoutManager.layout((List<? extends SceneView>)this.getSceneViews(), availableWidth, availableHeight, this.myIsCanvasResizing);
        this.revalidate();
        this.repaint();
    }

    @Override
    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        NlModel model2 = this.getModel();
        ImmutableList components = (ImmutableList)this.getSelectionModel().getSelection().stream().map(component3 -> new DnDTransferComponent(component3.getTagName(), component3.getTagDeprecated().getText(), NlComponentHelperKt.getW(component3), NlComponentHelperKt.getH(component3))).collect(ImmutableCollectors.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(model2 != null ? model2.getId() : 0L, (ImmutableList<DnDTransferComponent>)components));
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(100, 100);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        ImmutableList<SceneView> sceneViews = this.getSceneViews();
        Dimension dimension2 = this.myLayoutManager.getPreferredSize((List<? extends SceneView>)sceneViews, this.myScrollPane.getWidth(), this.myScrollPane.getHeight(), null);
        if (dimension2 == null) {
            NlDesignSurface.$$$reportNull$$$0(29);
        }
        return dimension2;
    }

    @Override
    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        this.myAccessoryPanel.setModel(model2);
        return super.setModel(model2);
    }

    @Override
    public void dispose() {
        this.myAccessoryPanel.setSurface(null);
        super.dispose();
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component3, int x, int y) {
        ViewHandler handler;
        if (component3 == null) {
            NlDesignSurface.$$$reportNull$$$0(30);
        }
        if ((handler = NlComponentHelperKt.getViewHandler(component3)) != null) {
            handler.onActivateInDesignSurface(component3, this.getSceneManager().getViewEditor(), x, y);
        }
        super.notifyComponentActivate(component3, x, y);
    }

    @Override
    @NotNull
    public Consumer<NlComponent> getComponentRegistrar() {
        Consumer<NlComponent> consumer = component3 -> NlComponentHelper.INSTANCE.registerComponent((NlComponent)component3);
        if (consumer == null) {
            NlDesignSurface.$$$reportNull$$$0(31);
        }
        return consumer;
    }

    public void setMockupVisible(boolean mockupVisible) {
        this.myMockupVisible = mockupVisible;
        this.repaint();
    }

    public boolean isMockupVisible() {
        return this.myMockupVisible;
    }

    public void setMockupEditor(@Nullable MockupEditor mockupEditor) {
        this.myMockupEditor = mockupEditor;
    }

    @Nullable
    public MockupEditor getMockupEditor() {
        return this.myMockupEditor;
    }

    public void updateErrorDisplay() {
        if (this.myIsRenderingSynchronously) {
            return;
        }
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock when calling updateErrorDisplay!";
        this.getErrorQueue().cancelAllUpdates();
        this.getErrorQueue().queue(new Update("errors"){

            public void run() {
                RenderResult result2;
                LayoutlibSceneManager sceneManager = NlDesignSurface.this.getSceneManager();
                RenderResult renderResult = result2 = sceneManager != null ? sceneManager.getRenderResult() : null;
                if (result2 == null) {
                    return;
                }
                Project project = NlDesignSurface.this.getProject();
                if (project.isDisposed()) {
                    return;
                }
                DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                    RenderErrorModel model2;
                    BuildMode gradleBuildMode = BuildSettings.getInstance(project).getBuildMode();
                    RenderErrorModel renderErrorModel = model2 = gradleBuildMode != null && result2.getLogger().hasErrors() ? RenderErrorModel.STILL_BUILDING_ERROR_MODEL : RenderErrorModelFactory.createErrorModel(NlDesignSurface.this, result2, DataManager.getInstance().getDataContext((Component)NlDesignSurface.this.getIssuePanel()));
                    if (NlDesignSurface.this.myRenderIssueProvider != null) {
                        NlDesignSurface.this.getIssueModel().removeIssueProvider(NlDesignSurface.this.myRenderIssueProvider);
                    }
                    NlDesignSurface.this.myRenderIssueProvider = new RenderIssueProvider(model2);
                    NlDesignSurface.this.getIssueModel().addIssueProvider(NlDesignSurface.this.myRenderIssueProvider);
                });
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    private void modelRendered() {
        this.updateErrorDisplay();
        this.repaint();
        this.layoutContent();
    }

    @Override
    @NotNull
    public CompletableFuture<Void> forceUserRequestedRefresh() {
        ArrayList<CompletableFuture<Void>> refreshFutures = new ArrayList<CompletableFuture<Void>>();
        for (SceneManager sceneManager : this.getSceneManagers()) {
            LayoutlibSceneManager layoutlibSceneManager = (LayoutlibSceneManager)sceneManager;
            refreshFutures.add(layoutlibSceneManager.requestUserInitiatedRender());
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(refreshFutures.toArray(new CompletableFuture[refreshFutures.size()]));
        if (completableFuture == null) {
            NlDesignSurface.$$$reportNull$$$0(32);
        }
        return completableFuture;
    }

    @Override
    protected boolean useSmallProgressIcon() {
        if (this.getFocusedSceneView() == null) {
            return false;
        }
        LayoutlibSceneManager manager = this.getSceneManager();
        assert (manager != null);
        return manager.getRenderResult() != null;
    }

    @Override
    protected double getMinScale() {
        return Math.max(this.getFitScale(true), this.myMinScale);
    }

    @Override
    protected double getMaxScale() {
        return this.myMaxScale;
    }

    @Override
    public boolean canZoomToFit() {
        double minZoomLevel = this.myMinScale / (double)this.getScreenScalingFactor();
        double maxZoomLevel = this.myMaxScale / (double)this.getScreenScalingFactor();
        double zoomToFitLevel = Math.max(minZoomLevel, Math.min(this.getFitScale(true), maxZoomLevel));
        return Math.abs(this.getScale() - zoomToFitLevel) > 0.01;
    }

    @Override
    public void scrollToCenter(@NotNull List<NlComponent> list) {
        if (list == null) {
            NlDesignSurface.$$$reportNull$$$0(33);
        }
        Scene scene = this.getScene();
        SceneView view = this.getFocusedSceneView();
        if (list.isEmpty() || scene == null || view == null) {
            return;
        }
        Rectangle componentsArea = new Rectangle(0, 0, -1, -1);
        Rectangle componentRect = new Rectangle();
        list.stream().filter(nlComponent -> !nlComponent.isRoot()).forEach(nlComponent -> {
            SceneComponent component3 = scene.getSceneComponent((NlComponent)nlComponent);
            if (component3 == null) {
                return;
            }
            component3.fillRect(componentRect);
            if (componentsArea.width < 0) {
                componentsArea.setBounds(componentRect);
            } else {
                componentsArea.add(componentRect);
            }
        });
        Rectangle areaToCenter = Coordinates.getSwingRectDip(view, componentsArea);
        if (areaToCenter.isEmpty() || this.getLayeredPane().getVisibleRect().contains(areaToCenter)) {
            return;
        }
        Dimension swingViewportSize = this.getScrollPane().getViewport().getExtentSize();
        int targetSwingX = (int)areaToCenter.getCenterX();
        int targetSwingY = (int)areaToCenter.getCenterY();
        this.setScrollPosition(targetSwingX - swingViewportSize.width / 2, targetSwingY - swingViewportSize.height / 2);
        double fitScale = this.getFitScale(areaToCenter.getSize(), false);
        if (this.getScale() > fitScale) {
            this.setScale(fitScale, targetSwingX, targetSwingY);
        }
    }

    @Override
    protected void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            NlDesignSurface.$$$reportNull$$$0(34);
        }
        super.notifySelectionListeners(newSelection);
        this.scrollToCenter(newSelection);
    }

    @Override
    @NotNull
    protected DesignSurfaceActionHandler createActionHandler() {
        return new NlDesignSurfaceActionHandler(this);
    }

    @Override
    @NotNull
    public List<NlComponent> getSelectableComponents() {
        NlModel model2 = this.getModel();
        if (model2 == null) {
            List<NlComponent> list = Collections.emptyList();
            if (list == null) {
                NlDesignSurface.$$$reportNull$$$0(35);
            }
            return list;
        }
        ImmutableList<NlComponent> roots = model2.getComponents();
        if (roots.isEmpty()) {
            List<NlComponent> list = Collections.emptyList();
            if (list == null) {
                NlDesignSurface.$$$reportNull$$$0(36);
            }
            return list;
        }
        NlComponent root2 = (NlComponent)roots.get(0);
        if (root2 == null) {
            List<NlComponent> list = Collections.emptyList();
            if (list == null) {
                NlDesignSurface.$$$reportNull$$$0(37);
            }
            return list;
        }
        List<NlComponent> list = root2.flatten().collect(Collectors.toList());
        if (list == null) {
            NlDesignSurface.$$$reportNull$$$0(38);
        }
        return list;
    }

    public void setRenderSynchronously(boolean enabled) {
        this.myIsRenderingSynchronously = enabled;
    }

    public boolean isRenderingSynchronously() {
        return this.myIsRenderingSynchronously;
    }

    public void setAnimationScrubbing(boolean value2) {
        this.myIsAnimationScrubbing = value2;
    }

    public boolean isInAnimationScrubbing() {
        return this.myIsAnimationScrubbing;
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            NlDesignSurface.$$$reportNull$$$0(39);
        }
        if (LayoutPreviewHandlerKt.LAYOUT_PREVIEW_HANDLER_KEY.is(dataId)) {
            return this;
        }
        return super.getData(dataId);
    }

    @Override
    public boolean getPreviewWithToolsAttributes() {
        return this.myPreviewWithToolsAttributes;
    }

    @Override
    public void setPreviewWithToolsAttributes(boolean isPreviewWithToolsAttributes) {
        if (this.myPreviewWithToolsAttributes != isPreviewWithToolsAttributes) {
            this.myPreviewWithToolsAttributes = isPreviewWithToolsAttributes;
            this.forceUserRequestedRefresh();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneManagerProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManagerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interactionHandlerProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSurfaceState";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneMode";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adaptiveIconShape";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createSceneManager";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyticsManager";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneMode";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderableBoundsForInvisibleComponents";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneViews";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdaptiveIconShape";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessoryPanel";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredContentSize";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentRegistrar";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "forceUserRequestedRefresh";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectableComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "defaultSceneManagerProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "defaultActionManagerProvider";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "defaultInteractionHandlerProvider";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "builder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSceneManager";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setScreenMode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRenderableBoundsForInvisibleComponents";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setAdaptiveIconShape";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCenter";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "notifySelectionListeners";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface NavigationHandler
    extends Disposable {
        @NotNull
        public boolean isFileHandled(String var1);

        public void handleNavigate(SceneView var1, ImmutableList<NlModel> var2, boolean var3, @Nullable NlComponent var4);
    }

    public static final class Builder {
        private final Project myProject;
        private final Disposable myParentDisposable;
        private boolean myIsPreview;
        private BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> mySceneManagerProvider;
        private boolean myShowModelName;
        private boolean myIsEditable;
        private SurfaceLayoutManager myLayoutManager;
        private NavigationHandler myNavigationHandler;
        @NotNull
        private DesignSurface.State myDefaultSurfaceState;
        private double myMinScale;
        private double myMaxScale;
        private Function<DesignSurface, ActionManager<? extends DesignSurface>> myActionManagerProvider;
        private Function<DesignSurface, InteractionHandler> myInteractionHandlerProvider;

        private Builder(@NotNull Project project, @NotNull Disposable parentDisposable) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myIsPreview = false;
            this.mySceneManagerProvider = NlDesignSurface::defaultSceneManagerProvider;
            this.myShowModelName = false;
            this.myIsEditable = true;
            this.myDefaultSurfaceState = DesignSurface.State.FULL;
            this.myMinScale = 0.1;
            this.myMaxScale = 10.0;
            this.myActionManagerProvider = NlDesignSurface::defaultActionManagerProvider;
            this.myInteractionHandlerProvider = NlDesignSurface::defaultInteractionHandlerProvider;
            this.myProject = project;
            this.myParentDisposable = parentDisposable;
        }

        @NotNull
        public Builder setIsPreview(boolean isPreview) {
            this.myIsPreview = isPreview;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder setSceneManagerProvider(@NotNull BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> sceneManagerProvider) {
            if (sceneManagerProvider == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.mySceneManagerProvider = sceneManagerProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder showModelNames() {
            this.myShowModelName = true;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder2;
        }

        @NotNull
        public Builder setLayoutManager(@NotNull SurfaceLayoutManager layoutManager) {
            if (layoutManager == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myLayoutManager = layoutManager;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        public Builder setActionManagerProvider(@NotNull Function<DesignSurface, ActionManager<? extends DesignSurface>> actionManagerProvider) {
            if (actionManagerProvider == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myActionManagerProvider = actionManagerProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @NotNull
        public Builder setEditable(boolean editable) {
            this.myIsEditable = editable;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        public Builder setInteractionHandlerProvider(@NotNull Function<DesignSurface, InteractionHandler> interactionHandlerProvider) {
            if (interactionHandlerProvider == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myInteractionHandlerProvider = interactionHandlerProvider;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder2;
        }

        @NotNull
        public Builder setDefaultSurfaceState(@NotNull DesignSurface.State surfaceState) {
            if (surfaceState == null) {
                Builder.$$$reportNull$$$0(13);
            }
            this.myDefaultSurfaceState = surfaceState;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder2;
        }

        @NotNull
        public Builder setNavigationHandler(NavigationHandler navigationHandler) {
            this.myNavigationHandler = navigationHandler;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(15);
            }
            return builder2;
        }

        public Builder setMinScale(double scale) {
            if (scale <= 0.0) {
                throw new IllegalStateException("The min scale (" + scale + ") is not larger than 0");
            }
            this.myMinScale = scale;
            return this;
        }

        public Builder setMaxScale(double scale) {
            this.myMaxScale = scale;
            return this;
        }

        @NotNull
        public NlDesignSurface build() {
            SurfaceLayoutManager layoutManager;
            SurfaceLayoutManager surfaceLayoutManager = layoutManager = this.myLayoutManager != null ? this.myLayoutManager : NlDesignSurface.createDefaultSurfaceLayoutManager();
            if (this.myMinScale > this.myMaxScale) {
                throw new IllegalStateException("The max scale (" + this.myMaxScale + ") is lower than min scale (" + this.myMinScale + ")");
            }
            return new NlDesignSurface(this.myProject, this.myParentDisposable, this.myIsPreview, this.myIsEditable, this.myShowModelName, this.mySceneManagerProvider, layoutManager, this.myActionManagerProvider, this.myInteractionHandlerProvider, this.myDefaultSurfaceState, this.myNavigationHandler, this.myMinScale, this.myMaxScale);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sceneManagerProvider";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layoutManager";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionManagerProvider";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interactionHandlerProvider";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "surfaceState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setIsPreview";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSceneManagerProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showModelNames";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLayoutManager";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setActionManagerProvider";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEditable";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInteractionHandlerProvider";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDefaultSurfaceState";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNavigationHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSceneManagerProvider";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setLayoutManager";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setActionManagerProvider";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setInteractionHandlerProvider";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultSurfaceState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

