/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.SdkConstants;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionInformation;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.common.CommonDragHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutGuidelineHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.openapi.project.Project;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.function.Predicate;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragDropInteraction
extends Interaction {
    private final DesignSurface myDesignSurface;
    private final List<NlComponent> myDraggedComponents;
    private ViewGroupHandler myCurrentHandler;
    private DragHandler myDragHandler;
    private SceneComponent myDragReceiver;
    private DragType myType;
    private SceneView mySceneView;
    private DnDTransferItem myTransferItem;
    SceneComponent myCurrentViewgroup;
    private boolean myDoesAcceptDropAtLastPosition;
    private ViewGroupHandler myCachedHandler;
    private SceneComponent myCachedComponent;

    public DragDropInteraction(@NotNull DesignSurface designSurface, @NotNull List<NlComponent> dragged) {
        if (designSurface == null) {
            DragDropInteraction.$$$reportNull$$$0(0);
        }
        if (dragged == null) {
            DragDropInteraction.$$$reportNull$$$0(1);
        }
        this.myType = DragType.MOVE;
        this.myCurrentViewgroup = null;
        this.myDoesAcceptDropAtLastPosition = true;
        this.myDesignSurface = designSurface;
        this.myDraggedComponents = dragged;
    }

    public void setType(DragType type) {
        this.myType = type;
        if (this.myDragHandler != null) {
            this.myDragHandler.setDragType(type);
        }
    }

    public void setTransferItem(@NotNull DnDTransferItem item) {
        if (item == null) {
            DragDropInteraction.$$$reportNull$$$0(2);
        }
        this.myTransferItem = item;
    }

    @Nullable
    public DnDTransferItem getTransferItem() {
        return this.myTransferItem;
    }

    @Override
    public void begin(@Nullable EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (interactionInformation == null) {
            DragDropInteraction.$$$reportNull$$$0(3);
        }
        assert (event instanceof DropTargetDragEvent);
        DropTargetDragEvent dropEvent = (DropTargetDragEvent)event;
        this.begin(dropEvent.getLocation().x, dropEvent.getLocation().y, interactionInformation.getModifiersEx());
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        super.begin(x, y, modifiersEx);
        this.moveTo(x, y, modifiersEx, false);
        this.myDesignSurface.startDragDropInteraction();
    }

    @Override
    public void update(@NotNull EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (event == null) {
            DragDropInteraction.$$$reportNull$$$0(4);
        }
        if (interactionInformation == null) {
            DragDropInteraction.$$$reportNull$$$0(5);
        }
        if (event instanceof DropTargetDragEvent) {
            DropTargetDragEvent dragEvent = (DropTargetDragEvent)event;
            Point location = dragEvent.getLocation();
            NlDropEvent nlDropEvent = new NlDropEvent(dragEvent);
            SceneView sceneView = this.myDesignSurface.getSceneView(location.x, location.y);
            if (sceneView == null) {
                nlDropEvent.reject();
                return;
            }
            this.update(location.x, location.y, interactionInformation.getModifiersEx());
            if (this.acceptsDrop()) {
                DragType dragType = dragEvent.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
                this.setType(dragType);
                NlModel model2 = sceneView.getModel();
                InsertType insertType = model2.determineInsertType(dragType, this.getTransferItem(), true);
                nlDropEvent.accept(insertType);
            } else {
                nlDropEvent.reject();
            }
        }
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        this.moveTo(x, y, modifiersEx, false);
    }

    public boolean acceptsDrop() {
        return this.myDoesAcceptDropAtLastPosition;
    }

    @Override
    public void commit(@Nullable EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (interactionInformation == null) {
            DragDropInteraction.$$$reportNull$$$0(6);
        }
        assert (event instanceof DropTargetDropEvent);
        DropTargetDropEvent dropEvent = (DropTargetDropEvent)event;
        NlDropEvent nlDropEvent = new NlDropEvent(dropEvent);
        Point location = dropEvent.getLocation();
        InsertType insertType = this.finishDropInteraction(location.x, location.y, dropEvent.getDropAction(), dropEvent.getTransferable());
        if (insertType != null) {
            this.end(dropEvent.getLocation().x, dropEvent.getLocation().y, interactionInformation.getModifiersEx());
            nlDropEvent.accept(insertType);
            nlDropEvent.complete();
        } else {
            this.cancel(event, interactionInformation);
            nlDropEvent.reject();
        }
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        this.moveTo(x, y, modifiersEx, true);
        boolean hasDragHandler = this.myDragHandler != null;
        this.mySceneView = this.myDesignSurface.getSceneView(x, y);
        if (this.mySceneView != null && this.myDragReceiver != null && hasDragHandler) {
            this.mySceneView.getModel().notifyModified(NlModel.ChangeType.DND_END);
            this.mySceneView.getSelectionModel().clear();
            this.mySceneView.getSceneManager().update();
            this.myDragReceiver.updateTargets();
        }
        this.myDesignSurface.stopDragDropInteraction();
    }

    @Override
    public void cancel(@Nullable EventObject event, @NotNull InteractionInformation interactionInformation) {
        if (interactionInformation == null) {
            DragDropInteraction.$$$reportNull$$$0(7);
        }
        this.cancel(interactionInformation.getX(), interactionInformation.getY(), interactionInformation.getModifiersEx());
        if (event instanceof DropTargetDropEvent) {
            NlDropEvent nlDropEvent = new NlDropEvent((DropTargetDropEvent)event);
            nlDropEvent.reject();
        }
    }

    @Override
    public void cancel(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        this.moveTo(x, y, modifiersEx, false);
        this.mySceneView = this.myDesignSurface.getSceneView(x, y);
        if (this.myDragHandler != null) {
            this.myDragHandler.cancel();
        }
        this.myDesignSurface.stopDragDropInteraction();
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(13);
    }

    private void moveTo(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean commit) {
        String error;
        SceneComponent viewgroup;
        this.mySceneView = this.myDesignSurface.getSceneView(x, y);
        if (this.mySceneView == null) {
            return;
        }
        this.myDoesAcceptDropAtLastPosition = true;
        this.myDesignSurface.getLayeredPane().scrollRectToVisible(new Rectangle(x - 50, y - 50, 100, 100));
        int ax = Coordinates.getAndroidX(this.mySceneView, x);
        int ay = Coordinates.getAndroidY(this.mySceneView, y);
        Project project = this.mySceneView.getModel().getProject();
        ViewGroupHandler handler = this.findViewGroupHandlerAt(x, y);
        for (viewgroup = this.mySceneView.getScene().findComponent(SceneContext.get(this.mySceneView), Coordinates.getAndroidXDip(this.mySceneView, x), Coordinates.getAndroidYDip(this.mySceneView, y)); viewgroup != null && !NlComponentHelperKt.isOrHasSuperclass(viewgroup.getNlComponent(), "android.view.ViewGroup"); viewgroup = viewgroup.getParent()) {
        }
        if (!(this.myDragHandler instanceof CommonDragHandler || handler == this.myCurrentHandler && this.myCurrentViewgroup == viewgroup)) {
            if (this.myCurrentViewgroup != null) {
                this.myCurrentViewgroup.setDrawState(SceneComponent.DrawState.NORMAL);
            }
            this.myCurrentViewgroup = viewgroup;
            if (this.myCurrentViewgroup != null) {
                this.myCurrentViewgroup.setDrawState(SceneComponent.DrawState.DRAG);
            }
            if (this.myDragHandler != null) {
                this.myDragHandler.cancel();
                this.myDragHandler = null;
                this.mySceneView.getSurface().repaint();
            }
            this.myCurrentHandler = handler;
            if (this.myCurrentHandler != null) {
                assert (this.myDragReceiver != null);
                error = null;
                ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(project);
                for (NlComponent component3 : this.myDraggedComponents) {
                    if (SdkConstants.CLASS_CONSTRAINT_LAYOUT_GUIDELINE.isEquals(component3.getTagName()) && !(this.myCurrentHandler instanceof ConstraintLayoutHandler)) {
                        error = String.format("<%1$s> does not accept <%2$s> as a child", this.myDragReceiver.getNlComponent().getTagName(), component3.getTagName());
                        this.myDoesAcceptDropAtLastPosition = false;
                        break;
                    }
                    if (!this.myCurrentHandler.acceptsChild(this.myDragReceiver, component3, ax, ay)) {
                        error = String.format("<%1$s> does not accept <%2$s> as a child", this.myDragReceiver.getNlComponent().getTagName(), component3.getTagName());
                        this.myDoesAcceptDropAtLastPosition = false;
                        break;
                    }
                    ViewHandler viewHandler = viewHandlerManager.getHandler(component3);
                    if (viewHandler == null || viewHandler.acceptsParent(this.myDragReceiver.getNlComponent(), component3)) continue;
                    error = String.format("<%1$s> does not accept <%2$s> as a parent", component3.getTagName(), this.myDragReceiver.getNlComponent().getTagName());
                    this.myDoesAcceptDropAtLastPosition = false;
                    break;
                }
                if (error == null) {
                    ViewEditorImpl editorImpl = new ViewEditorImpl(this.mySceneView);
                    this.myDragHandler = (Boolean)StudioFlags.NELE_DRAG_PLACEHOLDER.get() != false && CommonDragHandler.isSupportCommonDragHandler(this.myCurrentHandler) ? new CommonDragHandler((ViewEditor)editorImpl, this.myCurrentHandler, this.myDragReceiver, (List<? extends NlComponent>)this.myDraggedComponents, this.myType) : this.myCurrentHandler.createDragHandler(editorImpl, this.myDragReceiver, this.myDraggedComponents, this.myType);
                    if (this.myDragHandler != null) {
                        this.myDragHandler.start(Coordinates.getAndroidXDip(this.mySceneView, this.myStartX), Coordinates.getAndroidYDip(this.mySceneView, this.myStartY), this.myStartMask);
                    }
                } else {
                    this.myCurrentHandler = null;
                }
            }
        }
        if (this.myDragHandler instanceof CommonDragHandler || this.myDragHandler != null && this.myCurrentHandler != null) {
            error = this.myDragHandler.update(Coordinates.pxToDp(this.mySceneView, ax), Coordinates.pxToDp(this.mySceneView, ay), modifiers);
            ArrayList<NlComponent> added = new ArrayList<NlComponent>();
            if (commit && error == null) {
                added.addAll(this.myDraggedComponents);
                NlModel model2 = this.mySceneView.getModel();
                InsertType insertType = model2.determineInsertType(this.myType, this.myTransferItem, false);
                this.myDragHandler.commit(ax, ay, modifiers, insertType);
                model2.notifyModified(NlModel.ChangeType.DND_COMMIT);
                this.myDesignSurface.getLayeredPane().requestFocus();
            }
            this.mySceneView.getSurface().repaint();
        }
    }

    @Nullable
    private ViewGroupHandler findViewGroupHandlerAt(int x, int y) {
        SceneView sceneView = this.myDesignSurface.getSceneView(x, y);
        if (sceneView == null) {
            return null;
        }
        SceneComponent component3 = sceneView.getScene().findComponent(SceneContext.get(sceneView), Coordinates.getAndroidXDip(sceneView, x), Coordinates.getAndroidYDip(sceneView, y));
        if (component3 == null) {
            component3 = sceneView.getScene().getRoot();
        }
        if ((component3 = this.excludeDraggedComponents(component3)) == this.myCachedComponent && this.myCachedHandler != null) {
            return this.myCachedHandler;
        }
        this.myCachedComponent = component3;
        this.myCachedHandler = null;
        ViewHandlerManager handlerManager = ViewHandlerManager.get(sceneView.getModel().getFacet());
        while (component3 != null) {
            ViewHandler handler = handlerManager.getHandler(component3.getNlComponent());
            if (handler instanceof ViewGroupHandler && this.acceptsDrop(component3, (ViewGroupHandler)handler, x, y)) {
                this.myCachedHandler = (ViewGroupHandler)handlerManager.getHandler(component3.getNlComponent());
                this.myDragReceiver = component3;
                return this.myCachedHandler;
            }
            component3 = component3.getParent();
        }
        return null;
    }

    @Nullable
    private SceneComponent excludeDraggedComponents(@Nullable SceneComponent component3) {
        SceneComponent receiver = component3;
        while (component3 != null) {
            if (this.myDraggedComponents.contains(component3.getNlComponent())) {
                receiver = component3.getParent();
            }
            component3 = component3.getParent();
        }
        return receiver;
    }

    private boolean acceptsDrop(@NotNull SceneComponent parent, @NotNull ViewGroupHandler parentHandler, int x, int y) {
        if (parent == null) {
            DragDropInteraction.$$$reportNull$$$0(8);
        }
        if (parentHandler == null) {
            DragDropInteraction.$$$reportNull$$$0(9);
        }
        SceneView view = this.myDesignSurface.getSceneView(x, y);
        assert (view != null);
        ViewHandlerManager manager = ViewHandlerManager.get(view.getModel().getFacet());
        Predicate<NlComponent> acceptsChild = child -> parentHandler.acceptsChild(parent, (NlComponent)child, Coordinates.getAndroidX(view, x), Coordinates.getAndroidY(view, y));
        Predicate<NlComponent> acceptsParent = child -> {
            ViewHandler childHandler = manager.getHandler((NlComponent)child);
            return childHandler != null && childHandler.acceptsParent(parent.getNlComponent(), (NlComponent)child);
        };
        return this.myDraggedComponents.stream().allMatch(acceptsChild.and(acceptsParent));
    }

    @Override
    @NotNull
    public List<Layer> createOverlays() {
        List<Layer> list = Collections.singletonList(new DragLayer());
        if (list == null) {
            DragDropInteraction.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<NlComponent> getDraggedComponents() {
        List<NlComponent> list = this.myDraggedComponents;
        if (list == null) {
            DragDropInteraction.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    public InsertType finishDropInteraction(int mouseX, int mouseY, int dropAction, @Nullable Transferable transferable) {
        Object components;
        if (transferable == null) {
            return null;
        }
        DnDTransferItem item = DnDTransferItem.getTransferItem(transferable, false);
        if (item == null) {
            return null;
        }
        SceneView sceneView = this.myDesignSurface.getSceneView(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        NlModel model2 = sceneView.getModel();
        DragType dragType = dropAction == 1 ? DragType.COPY : DragType.MOVE;
        InsertType insertType = model2.determineInsertType(dragType, item, false);
        this.setType(dragType);
        this.setTransferItem(item);
        List<NlComponent> dragged = this.getDraggedComponents();
        if (insertType.isMove()) {
            components = this.myDesignSurface.getSelectionModel().getSelection();
        } else {
            components = model2.createComponents(item, insertType, this.myDesignSurface);
            if (components.isEmpty()) {
                return null;
            }
        }
        if (dragged.size() != components.size()) {
            throw new AssertionError((Object)String.format("Problem with drop: dragged.size(%1$d) != components.size(%2$d)", dragged.size(), components.size()));
        }
        for (int index = 0; index < dragged.size(); ++index) {
            if (!NlComponentHelperKt.getHasNlComponentInfo((NlComponent)components.get(index)) || !NlComponentHelperKt.getHasNlComponentInfo(dragged.get(index))) continue;
            NlComponentHelperKt.setX((NlComponent)components.get(index), NlComponentHelperKt.getX(dragged.get(index)));
            NlComponentHelperKt.setY((NlComponent)components.get(index), NlComponentHelperKt.getY(dragged.get(index)));
        }
        this.logFinishDropInteraction((List<NlComponent>)components);
        dragged.clear();
        dragged.addAll((Collection<NlComponent>)components);
        return insertType;
    }

    private void logFinishDropInteraction(@NotNull List<NlComponent> components) {
        DesignSurface surface2;
        if (components == null) {
            DragDropInteraction.$$$reportNull$$$0(12);
        }
        if (!((surface2 = this.myDesignSurface) instanceof NlDesignSurface)) {
            return;
        }
        NlAnalyticsManager manager = (NlAnalyticsManager)surface2.getAnalyticsManager();
        components.forEach(component3 -> {
            if (SdkConstants.CLASS_CONSTRAINT_LAYOUT_GUIDELINE.isEquals(component3.getTagName())) {
                if (ConstraintLayoutGuidelineHandler.isVertical(component3)) {
                    manager.trackAddVerticalGuideline();
                } else {
                    manager.trackAddHorizontalGuideline();
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragged";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interactionInformation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/DragDropInteraction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/DragDropInteraction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverlays";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDraggedComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTransferItem";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "begin";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDrop";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logFinishDropInteraction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DragLayer
    extends Layer {
        private DragLayer() {
        }

        @Override
        public void paint(@NotNull Graphics2D gc) {
            if (gc == null) {
                DragLayer.$$$reportNull$$$0(0);
            }
            if (DragDropInteraction.this.myDragHandler != null) {
                DragDropInteraction.this.myDragHandler.paint(new NlGraphics(gc, DragDropInteraction.this.mySceneView));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/surface/DragDropInteraction$DragLayer", "paint"));
        }
    }
}

