/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout.test;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scout.ConstraintSetGenerator;
import com.android.tools.idea.uibuilder.scout.RectangleGenerator;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ConstraintGeneratorTest
extends JPanel {
    DisplayList list;
    int count = 0;
    long time = System.nanoTime();
    public static final Color BLUEPRINT_BG_COLOR = new Color(1258866);
    private String mSceneList = "";

    public ConstraintGeneratorTest() {
        this.setBackground(Color.BLUE);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(BLUEPRINT_BG_COLOR);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.list != null) {
            this.list.paint((Graphics2D)g, SceneContext.get());
        }
        ++this.count;
        if (System.nanoTime() - this.time > 1000000000L) {
            double total = (double)(System.nanoTime() - this.time) * 1.0E-9;
            System.out.println(" " + (float)((double)this.count / total) + " fps");
            this.count = 0;
            this.time = System.nanoTime();
        }
        this.repaint();
    }

    public void setSceneList(String sceneList) {
        this.mSceneList = sceneList;
        this.list = DisplayList.getDisplayList(this.mSceneList);
        this.repaint();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Constraint Set");
        f.setBounds(new Rectangle(1100, 1100));
        f.setDefaultCloseOperation(3);
        ConstraintGeneratorTest p = new ConstraintGeneratorTest();
        RectangleGenerator rectGenerator = new RectangleGenerator();
        ArrayList<ScoutWidget> recs = rectGenerator.random(3, 3, 1000, 900);
        ScoutWidget[] widgets = recs.toArray(new ScoutWidget[4]);
        ConstraintSetGenerator lists = new ConstraintSetGenerator(widgets);
        Object list = rectGenerator.displayRecs(widgets);
        list = (String)list + lists.findConstraintSet().displayString();
        p.setSceneList((String)list);
        f.setContentPane(p);
        f.validate();
        f.setVisible(true);
    }
}

