/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawTextRegion;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;

public class ButtonDecorator
extends SceneDecorator {
    /*
     * WARNING - void declaration
     */
    @Override
    public void addContent(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent sceneComponent) {
        void component3;
        if (list == null) {
            ButtonDecorator.$$$reportNull$$$0(0);
        }
        if (sceneContext == null) {
            ButtonDecorator.$$$reportNull$$$0(1);
        }
        if (sceneComponent == null) {
            ButtonDecorator.$$$reportNull$$$0(2);
        }
        super.addContent(list, time2, sceneContext, (SceneComponent)component3);
        Rectangle rect = new Rectangle();
        component3.fillDrawRect(time2, rect);
        int l = sceneContext.getSwingXDip(rect.x);
        int t = sceneContext.getSwingYDip(rect.y);
        int w = sceneContext.getSwingDimensionDip(rect.width);
        int h = sceneContext.getSwingDimensionDip(rect.height);
        String text = this.getContentText(component3.getNlComponent());
        int fontSize = DrawTextRegion.getFont(component3.getNlComponent(), "14sp");
        float scale = (float)sceneContext.getScale();
        int baseLineOffset = sceneContext.getSwingDimensionDip(component3.getBaseline());
        int mode = component3.isSelected() ? 2 : 0;
        list.add(new DrawButton(l, t, w, h, mode, baseLineOffset, scale, fontSize, text));
    }

    @NotNull
    protected String getContentText(NlComponent nlComponent) {
        String string = ConstraintUtilities.getResolvedText(nlComponent);
        if (string == null) {
            ButtonDecorator.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/scene/decorator/ButtonDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/scene/decorator/ButtonDecorator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DrawButton
    extends DrawTextRegion {
        public static int androidToSwingFontSize(float fontSize) {
            return Math.round((fontSize * 2.0f + 4.5f) / 2.41f);
        }

        DrawButton(int x, int y, int width, int height, int mode, int baseLineOffset, float scale, int fontSize, String string) {
            super(x, y, width, height, mode, baseLineOffset, string, true, true, 4, 5, fontSize, scale);
            this.mHorizontalPadding = (int)(4.0f * scale);
            this.mVerticalPadding = (int)(8.0f * scale);
            this.mHorizontalMargin = (int)(8.0f * scale);
            this.mVerticalMargin = (int)(12.0f * scale);
        }

        @NotNull
        public static DrawButton createFromString(@NotNull String s) {
            if (s == null) {
                DrawButton.$$$reportNull$$$0(0);
            }
            String[] sp = s.split(",");
            int c = 0;
            int x = Integer.parseInt(sp[c++]);
            int y = Integer.parseInt(sp[c++]);
            int width = Integer.parseInt(sp[c++]);
            int height = Integer.parseInt(sp[c++]);
            int mode = Integer.parseInt(sp[c++]);
            int baseLineOffset = Integer.parseInt(sp[c++]);
            float scale = Float.parseFloat(sp[c++]);
            int fontSize = Integer.parseInt(sp[c++]);
            String text = s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
            return new DrawButton(x, y, width, height, mode, baseLineOffset, scale, fontSize, text);
        }

        @Override
        public String serialize() {
            return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.mMode + "," + this.myBaseLineOffset + "," + this.mScale + "," + this.mFontSize + ",\"" + this.mText + "\"";
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            ColorSet colorSet = sceneContext.getColorSet();
            if (colorSet.drawBackground()) {
                int round = sceneContext.getSwingDimensionDip(5.0f);
                Stroke stroke = g.getStroke();
                int strokeWidth = sceneContext.getSwingDimensionDip(2.0f);
                g.setStroke(new BasicStroke(strokeWidth));
                g.setColor(colorSet.getButtonBackground());
                g.fillRect(this.x + this.mHorizontalMargin, this.y + this.mVerticalMargin, this.width - this.mHorizontalMargin * 2 + 1, this.height - this.mVerticalMargin * 2 + 1);
                g.setColor(colorSet.getFakeUI());
                g.drawRoundRect(this.x + this.mHorizontalMargin, this.y + this.mVerticalMargin, this.width - this.mHorizontalMargin * 2, this.height - this.mVerticalMargin * 2, 2, 2);
                g.setStroke(stroke);
            }
            super.paint(g, sceneContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/uibuilder/scene/decorator/ButtonDecorator$DrawButton", "createFromString"));
        }
    }
}

