/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class ViewInspectorProvider
implements InspectorProvider<NlPropertiesManager> {
    private static final Set<String> TAG_EXCEPTIONS = ImmutableSet.of((Object)"TextView", (Object)"ProgressBar");
    private final Map<String, InspectorComponent<NlPropertiesManager>> myInspectors = new HashMap<String, InspectorComponent<NlPropertiesManager>>();

    ViewInspectorProvider() {
    }

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            ViewInspectorProvider.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            ViewInspectorProvider.$$$reportNull$$$0(1);
        }
        if (propertiesManager == null) {
            ViewInspectorProvider.$$$reportNull$$$0(2);
        }
        if (components.size() != 1) {
            return false;
        }
        NlComponent firstComponent = components.get(0);
        String tagName = firstComponent.getTagName();
        if (TAG_EXCEPTIONS.contains(tagName)) {
            return false;
        }
        if (this.myInspectors.containsKey(tagName)) {
            return true;
        }
        ViewHandler handler = NlComponentHelperKt.getViewHandler(firstComponent);
        if (handler == null || handler.getInspectorProperties().isEmpty()) {
            return false;
        }
        this.myInspectors.put(tagName, new ViewInspectorComponent(tagName, properties, propertiesManager, handler.getInspectorProperties()));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent<NlPropertiesManager> createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            ViewInspectorProvider.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            ViewInspectorProvider.$$$reportNull$$$0(4);
        }
        if (propertiesManager == null) {
            ViewInspectorProvider.$$$reportNull$$$0(5);
        }
        assert (components.size() == 1);
        String tagName = components.get(0).getTagName();
        InspectorComponent<NlPropertiesManager> inspector = this.myInspectors.get(tagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        InspectorComponent<NlPropertiesManager> inspectorComponent = inspector;
        if (inspectorComponent == null) {
            ViewInspectorProvider.$$$reportNull$$$0(6);
        }
        return inspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myInspectors.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomInspector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomInspector";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ViewInspectorComponent
    implements InspectorComponent<NlPropertiesManager> {
        private final String myComponentName;
        private final List<String> myPropertyNames;
        private final List<NlComponentEditor> myEditors;
        private final int mySrcPropertyIndex;
        private final int mySrcPropertyToolsIndex;

        public ViewInspectorComponent(@NotNull String tagName, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager, @NotNull List<String> propertyNames) {
            if (tagName == null) {
                ViewInspectorComponent.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                ViewInspectorComponent.$$$reportNull$$$0(1);
            }
            if (propertiesManager == null) {
                ViewInspectorComponent.$$$reportNull$$$0(2);
            }
            if (propertyNames == null) {
                ViewInspectorComponent.$$$reportNull$$$0(3);
            }
            this.myComponentName = tagName.substring(tagName.lastIndexOf(46) + 1);
            this.myPropertyNames = new ArrayList<String>(propertyNames);
            this.mySrcPropertyIndex = this.myPropertyNames.indexOf("src");
            this.mySrcPropertyToolsIndex = this.myPropertyNames.indexOf("tools:src");
            this.myEditors = new ArrayList<NlComponentEditor>(this.myPropertyNames.size());
            this.createEditors(properties, propertiesManager);
        }

        private void createEditors(@NotNull Map<String, NlProperty> properties, @NotNull PropertiesManager propertiesManager) {
            if (properties == null) {
                ViewInspectorComponent.$$$reportNull$$$0(4);
            }
            if (propertiesManager == null) {
                ViewInspectorComponent.$$$reportNull$$$0(5);
            }
            for (String propertyName : this.myPropertyNames) {
                boolean designPropertyRequired = propertyName.startsWith("tools:");
                NlProperty property2 = properties.get(propertyName = StringUtil.trimStart((String)propertyName, (String)"tools:"));
                if (property2 == null) continue;
                if (designPropertyRequired) {
                    property2 = property2.getDesignTimeProperty();
                }
                NlComponentEditor editor2 = propertiesManager.getPropertyEditors().create(property2);
                editor2.setProperty(property2);
                this.myEditors.add(editor2);
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                ViewInspectorComponent.$$$reportNull$$$0(6);
            }
            if (properties == null) {
                ViewInspectorComponent.$$$reportNull$$$0(7);
            }
            if (propertiesManager == null) {
                ViewInspectorComponent.$$$reportNull$$$0(8);
            }
            this.useSrcCompatIfExist(properties);
            this.myEditors.clear();
            this.createEditors(properties, propertiesManager);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            List<NlComponentEditor> list = this.myEditors;
            if (list == null) {
                ViewInspectorComponent.$$$reportNull$$$0(9);
            }
            return list;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                ViewInspectorComponent.$$$reportNull$$$0(10);
            }
            this.refresh();
            inspector.addTitle(this.myComponentName);
            for (NlComponentEditor editor2 : this.myEditors) {
                NlProperty property2 = editor2.getProperty();
                String propertyName = property2.getName();
                JLabel label = inspector.addComponent(propertyName, property2.getTooltipText(), editor2.getComponent());
                if ("http://schemas.android.com/tools".equals(property2.getNamespace())) {
                    label.setIcon(StudioIcons.LayoutEditor.Properties.TOOLS_ATTRIBUTE);
                }
                editor2.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            this.myEditors.forEach(NlComponentEditor::refresh);
        }

        private void useSrcCompatIfExist(@NotNull Map<String, NlProperty> properties) {
            if (properties == null) {
                ViewInspectorComponent.$$$reportNull$$$0(11);
            }
            if (this.mySrcPropertyIndex >= 0) {
                String nameToUse = properties.containsKey("srcCompat") ? "srcCompat" : "src";
                this.myPropertyNames.set(this.mySrcPropertyIndex, nameToUse);
                if (this.mySrcPropertyToolsIndex >= 0) {
                    this.myPropertyNames.set(this.mySrcPropertyToolsIndex, "tools:" + nameToUse);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertiesManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyNames";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/ViewInspectorProvider$ViewInspectorComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createEditors";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProperties";
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "attachToInspector";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "useSrcCompatIfExist";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

