/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.android.tools.idea.uibuilder.model.PreferenceUtils;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanIconEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlEnumEditor;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TextInspectorProvider
implements InspectorProvider<NlPropertiesManager> {
    private static final Set<String> TAG_EXCEPTIONS = ImmutableSet.of((Object)"com.google.android.material.chip.Chip");
    @VisibleForTesting
    static final List<String> REQUIRED_TEXT_PROPERTIES = ImmutableList.of((Object)"text", (Object)"contentDescription", (Object)"textAppearance", (Object)"typeface", (Object)"textSize", (Object)"lineSpacingExtra", (Object)"textStyle", (Object)"textAllCaps", (Object)"textColor");
    private TextInspectorComponent myComponent;

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            TextInspectorProvider.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            TextInspectorProvider.$$$reportNull$$$0(1);
        }
        if (propertiesManager == null) {
            TextInspectorProvider.$$$reportNull$$$0(2);
        }
        if (components.stream().map(component3 -> component3.getTagName()).anyMatch(tag -> TAG_EXCEPTIONS.contains(tag))) {
            return false;
        }
        if (!properties.keySet().containsAll(REQUIRED_TEXT_PROPERTIES)) {
            return false;
        }
        for (NlComponent component4 : components) {
            if (!PreferenceUtils.VALUES.contains(component4.getTagName())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public TextInspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            TextInspectorProvider.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            TextInspectorProvider.$$$reportNull$$$0(4);
        }
        if (propertiesManager == null) {
            TextInspectorProvider.$$$reportNull$$$0(5);
        }
        if (this.myComponent == null) {
            this.myComponent = new TextInspectorComponent(propertiesManager);
        }
        this.myComponent.updateProperties(components, properties, propertiesManager);
        TextInspectorComponent textInspectorComponent = this.myComponent;
        if (textInspectorComponent == null) {
            TextInspectorProvider.$$$reportNull$$$0(6);
        }
        return textInspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myComponent = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomInspector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomInspector";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class TextInspectorComponent
    implements InspectorComponent<NlPropertiesManager> {
        private final NlReferenceEditor myTextEditor;
        private final NlReferenceEditor myDesignTextEditor;
        private final NlReferenceEditor myDescriptionEditor;
        private final NlEnumEditor myStyleEditor;
        private final NlEnumEditor myFontFamilyEditor;
        private final NlEnumEditor myTypefaceEditor;
        private final NlEnumEditor myFontSizeEditor;
        private final NlEnumEditor mySpacingEditor;
        private final NlBooleanIconEditor myBoldEditor;
        private final NlBooleanIconEditor myItalicsEditor;
        private final NlBooleanIconEditor myAllCapsEditor;
        private final NlBooleanIconEditor myStartEditor;
        private final NlBooleanIconEditor myLeftEditor;
        private final NlBooleanIconEditor myCenterEditor;
        private final NlBooleanIconEditor myRightEditor;
        private final NlBooleanIconEditor myEndEditor;
        private final NlReferenceEditor myColorEditor;
        private final JPanel myTextStylePanel;
        private final JPanel myAlignmentPanel;
        private NlProperty myText;
        private NlProperty myDesignText;
        private NlProperty myDescription;
        private NlProperty myStyle;
        private NlProperty myFontFamily;
        private NlProperty myTypeface;
        private NlProperty myFontSize;
        private NlProperty mySpacing;
        private NlFlagPropertyItem myTextStyle;
        private NlProperty myTextAllCaps;
        private NlProperty myAlignment;
        private NlProperty myColor;

        public TextInspectorComponent(@NotNull NlPropertiesManager propertiesManager) {
            if (propertiesManager == null) {
                TextInspectorComponent.$$$reportNull$$$0(0);
            }
            Project project = propertiesManager.getProject();
            this.myTextEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myDesignTextEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myDescriptionEditor = NlReferenceEditor.createForInspectorWithBrowseButton(project, NlEditingListener.DEFAULT_LISTENER);
            this.myStyleEditor = NlEnumEditor.createForInspector(this.createEnumStyleListener());
            this.myFontFamilyEditor = NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            this.myTypefaceEditor = NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            this.myFontSizeEditor = NlEnumEditor.createForInspectorWithBrowseButton(NlEditingListener.DEFAULT_LISTENER);
            this.mySpacingEditor = NlEnumEditor.createForInspectorWithBrowseButton(NlEditingListener.DEFAULT_LISTENER);
            this.myBoldEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_STYLE_BOLD, "Bold");
            this.myItalicsEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_STYLE_ITALIC, "Italics");
            this.myAllCapsEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_STYLE_UPPERCASE, "All Caps");
            this.myStartEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_ALIGN_LAYOUT_LEFT, "Align Start of View", "viewStart");
            this.myLeftEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_ALIGN_LEFT, "Align Start of Text", "textStart");
            this.myCenterEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_ALIGN_CENTER, "Align Center", "center");
            this.myRightEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_ALIGN_RIGHT, "Align End of Text", "textEnd");
            this.myEndEditor = new NlBooleanIconEditor(StudioIcons.LayoutEditor.Properties.TEXT_ALIGN_LAYOUT_RIGHT, "Align End of View", "viewEnd");
            this.myColorEditor = NlReferenceEditor.createForInspectorWithBrowseButton(propertiesManager.getProject(), NlEditingListener.DEFAULT_LISTENER);
            this.myTextStylePanel = new AdtSecondaryPanel((LayoutManager)new FlowLayout(3));
            this.myTextStylePanel.setFocusable(false);
            this.myTextStylePanel.add(this.myBoldEditor.getComponent());
            this.myTextStylePanel.add(this.myItalicsEditor.getComponent());
            this.myTextStylePanel.add(this.myAllCapsEditor.getComponent());
            this.myAlignmentPanel = new AdtSecondaryPanel((LayoutManager)new FlowLayout(3));
            this.myAlignmentPanel.setFocusable(false);
            this.myAlignmentPanel.add(this.myStartEditor.getComponent());
            this.myAlignmentPanel.add(this.myLeftEditor.getComponent());
            this.myAlignmentPanel.add(this.myCenterEditor.getComponent());
            this.myAlignmentPanel.add(this.myRightEditor.getComponent());
            this.myAlignmentPanel.add(this.myEndEditor.getComponent());
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                TextInspectorComponent.$$$reportNull$$$0(1);
            }
            if (properties == null) {
                TextInspectorComponent.$$$reportNull$$$0(2);
            }
            if (propertiesManager == null) {
                TextInspectorComponent.$$$reportNull$$$0(3);
            }
            this.myText = properties.get("text");
            this.myDesignText = this.myText.getDesignTimeProperty();
            this.myDescription = properties.get("contentDescription");
            this.myStyle = properties.get("textAppearance");
            this.myFontFamily = properties.getOrDefault("fontFamily", EmptyProperty.INSTANCE);
            this.myTypeface = properties.get("typeface");
            this.myFontSize = properties.get("textSize");
            this.mySpacing = properties.get("lineSpacingExtra");
            this.myTextStyle = (NlFlagPropertyItem)properties.get("textStyle");
            this.myTextAllCaps = properties.get("textAllCaps");
            this.myAlignment = properties.getOrDefault("textAlignment", EmptyProperty.INSTANCE);
            this.myColor = properties.get("textColor");
        }

        @Override
        public int getMaxNumberOfRows() {
            return 12;
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                TextInspectorComponent.$$$reportNull$$$0(4);
            }
            this.refresh();
            inspector.addTitle("TextView");
            inspector.addComponent("text", this.myText.getTooltipText(), this.myTextEditor.getComponent());
            JLabel designText = inspector.addComponent("text", this.myDesignText.getTooltipText(), this.myDesignTextEditor.getComponent());
            designText.setIcon(StudioIcons.LayoutEditor.Properties.TOOLS_ATTRIBUTE);
            inspector.addComponent("contentDescription", this.myDescription.getTooltipText(), this.myDescriptionEditor.getComponent());
            inspector.addExpandableComponent("textAppearance", this.myStyle.getTooltipText(), this.myStyleEditor.getComponent(), this.myStyleEditor.getKeySource());
            if (this.myFontFamily != EmptyProperty.INSTANCE) {
                inspector.addComponent("fontFamily", this.myFontFamily.getTooltipText(), this.myFontFamilyEditor.getComponent());
            }
            inspector.addComponent("typeface", this.myTypeface.getTooltipText(), this.myTypefaceEditor.getComponent());
            inspector.addComponent("textSize", this.myFontSize.getTooltipText(), this.myFontSizeEditor.getComponent());
            inspector.addComponent("lineSpacingExtra", this.mySpacing.getTooltipText(), this.mySpacingEditor.getComponent());
            inspector.addComponent("textColor", this.myColor.getTooltipText(), this.myColorEditor.getComponent());
            inspector.addComponent("textStyle", this.myTextStyle.getTooltipText(), this.myTextStylePanel);
            if (this.myAlignment != EmptyProperty.INSTANCE) {
                inspector.addComponent("textAlignment", this.myAlignment.getTooltipText(), this.myAlignmentPanel);
            }
        }

        @Override
        public void refresh() {
            this.myTextEditor.setProperty(this.myText);
            this.myDesignTextEditor.setProperty(this.myDesignText);
            this.myDescriptionEditor.setProperty(this.myDescription);
            this.myStyleEditor.setProperty(this.myStyle);
            this.myFontFamilyEditor.setProperty(this.myFontFamily);
            this.myTypefaceEditor.setProperty(this.myTypeface);
            this.myFontSizeEditor.setProperty(this.myFontSize);
            this.mySpacingEditor.setProperty(this.mySpacing);
            this.myBoldEditor.setProperty(this.myTextStyle.getChildProperty("bold"));
            this.myItalicsEditor.setProperty(this.myTextStyle.getChildProperty("italic"));
            this.myAllCapsEditor.setProperty(this.myTextAllCaps);
            this.myStartEditor.setProperty(this.myAlignment);
            this.myLeftEditor.setProperty(this.myAlignment);
            this.myCenterEditor.setProperty(this.myAlignment);
            this.myRightEditor.setProperty(this.myAlignment);
            this.myEndEditor.setProperty(this.myAlignment);
            this.myColorEditor.setProperty(this.myColor);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            ImmutableList immutableList = ImmutableList.of((Object)this.myTextEditor, (Object)this.myDesignTextEditor, (Object)this.myDescriptionEditor, (Object)this.myStyleEditor, (Object)this.myFontFamilyEditor, (Object)this.myTypefaceEditor, (Object)this.myFontSizeEditor, (Object)this.mySpacingEditor, (Object)this.myColorEditor);
            if (immutableList == null) {
                TextInspectorComponent.$$$reportNull$$$0(5);
            }
            return immutableList;
        }

        @TestOnly
        public List<NlBooleanIconEditor> getTextStyleEditors() {
            return ImmutableList.of((Object)this.myBoldEditor, (Object)this.myItalicsEditor, (Object)this.myAllCapsEditor);
        }

        @TestOnly
        public List<NlBooleanIconEditor> getTextAlignmentEditors() {
            return ImmutableList.of((Object)this.myStartEditor, (Object)this.myLeftEditor, (Object)this.myCenterEditor, (Object)this.myRightEditor, (Object)this.myEndEditor);
        }

        private NlEditingListener createEnumStyleListener() {
            return new NlEditingListener(){

                @Override
                public void stopEditing(@NotNull NlComponentEditor editor2, @Nullable Object value2) {
                    if (editor2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!Objects.equal((Object)value2, (Object)myStyle.getValue())) {
                        myStyle.setValue(value2);
                        myTypeface.setValue(null);
                        myFontFamily.setValue(null);
                        myFontSize.setValue(null);
                        mySpacing.setValue(null);
                        myTextStyle.setValue(null);
                        myTextAllCaps.setValue(null);
                        myAlignment.setValue(null);
                        myColor.setValue(null);
                        this.refresh();
                    }
                }

                @Override
                public void cancelEditing(@NotNull NlComponentEditor editor2) {
                    if (editor2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "editor";
                    objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider$TextInspectorComponent$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "stopEditing";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "cancelEditing";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertiesManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspector";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider$TextInspectorComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/TextInspectorProvider$TextInspectorComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProperties";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "attachToInspector";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

