/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.PropertyDesignState;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableCellEditor;
import com.android.tools.property.ptable.PTableItem;
import com.android.tools.property.ptable.PTableModel;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTableCellEditor
extends PTableCellEditor
implements NlEditingListener,
BrowsePanel.Context {
    protected NlComponentEditor myEditor;
    protected BrowsePanel myBrowsePanel;
    protected JTable myTable;
    protected int myRow;

    public void init(@NotNull NlComponentEditor editor2, @Nullable BrowsePanel browsePanel) {
        if (editor2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(0);
        }
        this.myEditor = editor2;
        this.myBrowsePanel = browsePanel;
    }

    public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, int row, int column) {
        if (table2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(2);
        }
        assert (value2 instanceof NlProperty);
        this.myEditor.setProperty((NlProperty)value2);
        this.startCellEditing(table2, row);
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setDesignState(NlTableCellEditor.getDesignState(table2, row));
        }
        return this.myEditor.getComponent();
    }

    protected void startCellEditing(@NotNull JTable table2, int row) {
        if (table2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(3);
        }
        this.myTable = table2;
        this.myRow = row;
    }

    @VisibleForTesting
    @Nullable
    JTable getTable() {
        return this.myTable;
    }

    @VisibleForTesting
    int getRow() {
        return this.myRow;
    }

    @VisibleForTesting
    public final NlComponentEditor getEditor() {
        return this.myEditor;
    }

    public boolean stopCellEditing() {
        if (this.myTable != null) {
            this.myTable.requestFocus();
            if (!super.stopCellEditing()) {
                return false;
            }
            this.myTable = null;
            this.myRow = -1;
            this.myEditor.setProperty(EmptyProperty.INSTANCE);
        }
        return true;
    }

    @Override
    public boolean isBooleanEditor() {
        return this.myEditor instanceof NlBooleanEditor;
    }

    @Override
    public void activate() {
        this.myEditor.activate();
    }

    public Object getCellEditorValue() {
        return this.myEditor.getValue();
    }

    @Override
    public void stopEditing(@NotNull NlComponentEditor editor2, @Nullable Object value2) {
        if (editor2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(4);
        }
        this.stopCellEditing();
    }

    @Override
    public void cancelEditing(@NotNull NlComponentEditor editor2) {
        if (editor2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(5);
        }
        this.cancelCellEditing();
    }

    @Override
    @Nullable
    public NlProperty getProperty() {
        return NlTableCellEditor.getPropertyAt(this.myTable, this.myRow);
    }

    @Override
    public void cancelEditing() {
        this.cancelCellEditing();
    }

    @Override
    public void addDesignProperty() {
        this.cancelEditing();
        NlTableCellEditor.addDesignProperty(this.myTable, this.myRow);
    }

    @Override
    public void removeDesignProperty() {
        this.cancelEditing();
        NlTableCellEditor.removeDesignProperty(this.myTable, this.myRow);
    }

    public static PropertyDesignState getDesignState(@NotNull JTable table2, int row) {
        NlPropertyItem property2;
        if (table2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(6);
        }
        if ((property2 = NlTableCellEditor.getPropertyAt(table2, row)) == null) {
            return PropertyDesignState.NOT_APPLICABLE;
        }
        if ("http://schemas.android.com/tools".equals(property2.getNamespace())) {
            NlProperty runtimeProperty = NlTableCellEditor.getRuntimeProperty(table2, row);
            return runtimeProperty != null ? PropertyDesignState.IS_REMOVABLE_DESIGN_PROPERTY : PropertyDesignState.NOT_APPLICABLE;
        }
        NlProperty designProperty = NlTableCellEditor.getDesignProperty(table2, row);
        return designProperty != null ? PropertyDesignState.HAS_DESIGN_PROPERTY : PropertyDesignState.MISSING_DESIGN_PROPERTY;
    }

    @Nullable
    public static NlPropertyItem getPropertyAt(@NotNull JTable table2, int row) {
        if (table2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(7);
        }
        if (!(table2 instanceof PTable) || row < 0 || row >= table2.getRowCount()) {
            return null;
        }
        Object value2 = table2.getValueAt(row, 1);
        if (value2 instanceof NlPropertyItem) {
            return (NlPropertyItem)value2;
        }
        return null;
    }

    @Nullable
    public static NlProperty getRuntimeProperty(@NotNull JTable table2, int row) {
        if (table2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(8);
        }
        NlPropertyItem currentProperty = NlTableCellEditor.getPropertyAt(table2, row);
        NlPropertyItem previousProperty = NlTableCellEditor.getPropertyAt(table2, NlTableCellEditor.getPreviousPropertyRow(currentProperty, table2, row));
        if (currentProperty != null && previousProperty != null && previousProperty.getName().equals(currentProperty.getName()) && "http://schemas.android.com/tools".equals(currentProperty.getNamespace()) && !"http://schemas.android.com/tools".equals(previousProperty.getNamespace())) {
            return previousProperty;
        }
        return null;
    }

    @Nullable
    public static NlProperty getDesignProperty(@NotNull JTable table2, int row) {
        if (table2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(9);
        }
        NlPropertyItem currentProperty = NlTableCellEditor.getPropertyAt(table2, row);
        NlPropertyItem nextProperty = NlTableCellEditor.getPropertyAt(table2, NlTableCellEditor.getNextPropertyRow(currentProperty, row));
        if (currentProperty != null && nextProperty != null && nextProperty.getName().equals(currentProperty.getName()) && !"http://schemas.android.com/tools".equals(currentProperty.getNamespace()) && "http://schemas.android.com/tools".equals(nextProperty.getNamespace())) {
            return nextProperty;
        }
        return null;
    }

    public static void addDesignProperty(@NotNull JTable table2, int row) {
        if (table2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(10);
        }
        NlPropertyItem property2 = NlTableCellEditor.getPropertyAt(table2, row);
        assert (property2 != null && !"http://schemas.android.com/tools".equals(property2.getNamespace()));
        assert (NlTableCellEditor.getDesignProperty(table2, row) == null);
        PTableModel model2 = (PTableModel)table2.getModel();
        int nextRow = NlTableCellEditor.getNextPropertyRow(property2, row);
        model2.insertRow(nextRow, property2.getDesignTimeProperty());
        if (property2.isExpanded()) {
            model2.expand(nextRow);
        }
        SwingUtilities.invokeLater(() -> table2.editCellAt(row + 1, 1));
    }

    public static void removeDesignProperty(@NotNull JTable table2, int row) {
        if (table2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(11);
        }
        NlPropertyItem designProperty = NlTableCellEditor.getPropertyAt(table2, row);
        assert (designProperty != null && "http://schemas.android.com/tools".equals(designProperty.getNamespace()));
        int previousRow = NlTableCellEditor.getPreviousPropertyRow(designProperty, table2, row);
        PTableModel model2 = (PTableModel)table2.getModel();
        designProperty.setValue(null);
        designProperty.delete();
        model2.collapse(row);
        model2.deleteRow(row);
        SwingUtilities.invokeLater(() -> table2.editCellAt(previousRow, 1));
    }

    private static int getNextPropertyRow(@Nullable NlPropertyItem currentProperty, int row) {
        if (currentProperty == null) {
            return -1;
        }
        return row + 1 + (currentProperty.isExpanded() ? currentProperty.getChildren().size() : 0);
    }

    private static int getPreviousPropertyRow(@Nullable NlPropertyItem currentProperty, @NotNull JTable table2, int row) {
        if (table2 == null) {
            NlTableCellEditor.$$$reportNull$$$0(12);
        }
        if (currentProperty == null || row == 0) {
            return -1;
        }
        PTableItem previous = (PTableItem)table2.getValueAt(row - 1, 1);
        if (previous.getParent() != null && currentProperty.getParent() == null) {
            return row - previous.getParent().getChildren().size() - 1;
        }
        return row - 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlTableCellEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTableCellEditorComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "startCellEditing";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "stopEditing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelEditing";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDesignState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyAt";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getRuntimeProperty";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getDesignProperty";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addDesignProperty";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDesignProperty";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreviousPropertyRow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

