/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.editors.PropertyEditors;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlEnumEditor;
import com.android.tools.idea.uibuilder.property.editors.NlFlagEditor;
import com.android.tools.idea.uibuilder.property.editors.NlFlagsEditor;
import com.android.tools.idea.uibuilder.property.editors.NlNoEditor;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupportFactory;
import com.android.tools.property.ptable.PTableCellEditor;
import com.android.tools.property.ptable.PTableCellEditorProvider;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;

public final class NlPropertyEditors
extends PropertyEditors
implements PTableCellEditorProvider {
    private final Project myProject;
    private NlTableCellEditor myBooleanEditor;
    private NlTableCellEditor myFlagEditor;
    private NlTableCellEditor myComboEditor;
    private NlTableCellEditor myDefaultEditor;

    @NotNull
    public static NlPropertyEditors getInstance(@NotNull Project project) {
        if (project == null) {
            NlPropertyEditors.$$$reportNull$$$0(0);
        }
        NlPropertyEditors nlPropertyEditors = (NlPropertyEditors)project.getService(NlPropertyEditors.class);
        if (nlPropertyEditors == null) {
            NlPropertyEditors.$$$reportNull$$$0(1);
        }
        return nlPropertyEditors;
    }

    private NlPropertyEditors(@NotNull Project project) {
        if (project == null) {
            NlPropertyEditors.$$$reportNull$$$0(2);
        }
        super(project.getMessageBus());
        this.myProject = project;
    }

    @Override
    @NotNull
    public PTableCellEditor getCellEditor(@NotNull PTableItem item, int column) {
        if (item == null) {
            NlPropertyEditors.$$$reportNull$$$0(3);
        }
        if (!(item instanceof NlProperty)) {
            NlNoEditor nlNoEditor = NlNoEditor.getInstance();
            if (nlNoEditor == null) {
                NlPropertyEditors.$$$reportNull$$$0(4);
            }
            return nlNoEditor;
        }
        switch (NlPropertyEditors.getEditorType((NlProperty)((Object)item))) {
            case BOOLEAN: {
                PTableCellEditor pTableCellEditor = this.getBooleanEditor();
                if (pTableCellEditor == null) {
                    NlPropertyEditors.$$$reportNull$$$0(5);
                }
                return pTableCellEditor;
            }
            case FLAG: {
                PTableCellEditor pTableCellEditor = this.getMyFlagEditor();
                if (pTableCellEditor == null) {
                    NlPropertyEditors.$$$reportNull$$$0(6);
                }
                return pTableCellEditor;
            }
            case COMBO: 
            case COMBO_WITH_BROWSE: {
                PTableCellEditor pTableCellEditor = this.getMyComboEditor();
                if (pTableCellEditor == null) {
                    NlPropertyEditors.$$$reportNull$$$0(7);
                }
                return pTableCellEditor;
            }
        }
        PTableCellEditor pTableCellEditor = this.getDefaultEditor();
        if (pTableCellEditor == null) {
            NlPropertyEditors.$$$reportNull$$$0(8);
        }
        return pTableCellEditor;
    }

    @Override
    @NotNull
    public NlComponentEditor create(@NotNull NlProperty property2) {
        if (property2 == null) {
            NlPropertyEditors.$$$reportNull$$$0(9);
        }
        switch (NlPropertyEditors.getEditorType(property2)) {
            case BOOLEAN: {
                NlBooleanEditor nlBooleanEditor = NlBooleanEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
                if (nlBooleanEditor == null) {
                    NlPropertyEditors.$$$reportNull$$$0(10);
                }
                return nlBooleanEditor;
            }
            case FLAG: {
                NlFlagsEditor nlFlagsEditor = NlFlagsEditor.create();
                if (nlFlagsEditor == null) {
                    NlPropertyEditors.$$$reportNull$$$0(11);
                }
                return nlFlagsEditor;
            }
            case COMBO: {
                NlEnumEditor nlEnumEditor = NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
                if (nlEnumEditor == null) {
                    NlPropertyEditors.$$$reportNull$$$0(12);
                }
                return nlEnumEditor;
            }
            case COMBO_WITH_BROWSE: {
                NlEnumEditor nlEnumEditor = NlEnumEditor.createForInspectorWithBrowseButton(NlEditingListener.DEFAULT_LISTENER);
                if (nlEnumEditor == null) {
                    NlPropertyEditors.$$$reportNull$$$0(13);
                }
                return nlEnumEditor;
            }
        }
        NlReferenceEditor nlReferenceEditor = NlReferenceEditor.createForInspectorWithBrowseButton(property2.getModel().getProject(), NlEditingListener.DEFAULT_LISTENER);
        if (nlReferenceEditor == null) {
            NlPropertyEditors.$$$reportNull$$$0(14);
        }
        return nlReferenceEditor;
    }

    @Override
    protected void resetCachedEditors() {
        this.myBooleanEditor = null;
        this.myFlagEditor = null;
        this.myComboEditor = null;
        this.myDefaultEditor = null;
    }

    @NotNull
    private static EditorType getEditorType(@NotNull NlProperty property2) {
        AttributeDefinition definition;
        if (property2 == null) {
            NlPropertyEditors.$$$reportNull$$$0(15);
        }
        Set<Object> formats = (definition = property2.getDefinition()) != null ? definition.getFormats() : Collections.emptySet();
        Boolean isBoolean = null;
        for (AttributeFormat attributeFormat : formats) {
            switch (attributeFormat) {
                case BOOLEAN: {
                    if (isBoolean != null) break;
                    isBoolean = Boolean.TRUE;
                    break;
                }
                case STRING: 
                case COLOR: 
                case DIMENSION: 
                case INTEGER: 
                case FLOAT: 
                case FRACTION: {
                    if (isBoolean != null) break;
                    isBoolean = Boolean.FALSE;
                    break;
                }
                case ENUM: {
                    EditorType editorType = EditorType.COMBO;
                    if (editorType == null) {
                        NlPropertyEditors.$$$reportNull$$$0(16);
                    }
                    return editorType;
                }
                case FLAGS: {
                    EditorType editorType = EditorType.FLAG;
                    if (editorType == null) {
                        NlPropertyEditors.$$$reportNull$$$0(17);
                    }
                    return editorType;
                }
            }
        }
        if (isBoolean == Boolean.TRUE) {
            EditorType editorType = EditorType.BOOLEAN;
            if (editorType == null) {
                NlPropertyEditors.$$$reportNull$$$0(18);
            }
            return editorType;
        }
        if (EnumSupportFactory.supportsProperty(property2)) {
            if (property2.getName().equals("style")) {
                EditorType editorType = EditorType.COMBO_WITH_BROWSE;
                if (editorType == null) {
                    NlPropertyEditors.$$$reportNull$$$0(19);
                }
                return editorType;
            }
            EditorType editorType = EditorType.COMBO;
            if (editorType == null) {
                NlPropertyEditors.$$$reportNull$$$0(20);
            }
            return editorType;
        }
        EditorType editorType = EditorType.DEFAULT;
        if (editorType == null) {
            NlPropertyEditors.$$$reportNull$$$0(21);
        }
        return editorType;
    }

    private PTableCellEditor getBooleanEditor() {
        if (this.myBooleanEditor == null) {
            this.myBooleanEditor = NlBooleanEditor.createForTable();
        }
        return this.myBooleanEditor;
    }

    private PTableCellEditor getMyFlagEditor() {
        if (this.myFlagEditor == null) {
            this.myFlagEditor = NlFlagEditor.createForTable();
        }
        return this.myFlagEditor;
    }

    private PTableCellEditor getMyComboEditor() {
        if (this.myComboEditor == null) {
            this.myComboEditor = NlEnumEditor.createForTable();
        }
        return this.myComboEditor;
    }

    private PTableCellEditor getDefaultEditor() {
        if (this.myDefaultEditor == null) {
            this.myDefaultEditor = NlReferenceEditor.createForTable(this.myProject);
        }
        return this.myDefaultEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellEditor";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCellEditor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEditorType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum EditorType {
        DEFAULT,
        BOOLEAN,
        FLAG,
        COMBO,
        COMBO_WITH_BROWSE;

    }
}

