/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.BaseComponentEditor;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.renderer.NlBooleanRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NlBooleanEditor
extends BaseComponentEditor
implements NlComponentEditor {
    @VisibleForTesting
    static final String TIP_TEXT_DONT_CARE = "(No value)";
    @VisibleForTesting
    static final String TIP_TEXT_NOT_SELECTED = "false";
    @VisibleForTesting
    static final String TIP_TEXT_SELECTED = "true";
    private static final int VERTICAL_SPACING_IN_TABLE_CELL = 1;
    private final JPanel myPanel;
    private final ThreeStateCheckBox myCheckbox;
    private final BrowsePanel myBrowsePanel;
    private NlProperty myProperty;
    private Object myValue;

    public static NlTableCellEditor createForTable() {
        NlTableCellEditor cellEditor = new NlTableCellEditor();
        BrowsePanel browsePanel = new BrowsePanel(cellEditor, true);
        cellEditor.init(new NlBooleanEditor(cellEditor, browsePanel, 1), browsePanel);
        return cellEditor;
    }

    public static NlBooleanEditor createForInspector(@NotNull NlEditingListener listener2) {
        if (listener2 == null) {
            NlBooleanEditor.$$$reportNull$$$0(0);
        }
        return new NlBooleanEditor(listener2, null, 2);
    }

    private NlBooleanEditor(@NotNull NlEditingListener listener2, @Nullable BrowsePanel browsePanel, int verticalSpacing) {
        if (listener2 == null) {
            NlBooleanEditor.$$$reportNull$$$0(1);
        }
        super(listener2);
        this.myCheckbox = new ThreeStateCheckBox();
        this.myCheckbox.addActionListener(this::checkboxChanged);
        this.myPanel = new AdtSecondaryPanel((LayoutManager)new BorderLayout(JBUI.scale((int)HORIZONTAL_COMPONENT_GAP), 0));
        this.myPanel.add((Component)this.myCheckbox, "Before");
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)verticalSpacing, (int)6, (int)verticalSpacing, (int)0));
        this.myBrowsePanel = browsePanel;
        if (browsePanel != null) {
            this.myPanel.add((Component)((Object)browsePanel), "After");
        }
        this.myProperty = EmptyProperty.INSTANCE;
    }

    @Override
    @NotNull
    public NlProperty getProperty() {
        NlProperty nlProperty = this.myProperty;
        if (nlProperty == null) {
            NlBooleanEditor.$$$reportNull$$$0(2);
        }
        return nlProperty;
    }

    @Override
    public void setProperty(@NotNull NlProperty property2) {
        if (property2 == null) {
            NlBooleanEditor.$$$reportNull$$$0(3);
        }
        this.myProperty = property2;
        String propValue = this.myProperty.getValue();
        this.myValue = propValue;
        ThreeStateCheckBox.State state = NlBooleanRenderer.getState(propValue);
        this.myCheckbox.setState(state == null ? ThreeStateCheckBox.State.NOT_SELECTED : state);
        this.updateTipText();
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setProperty(property2);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            NlBooleanEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.myValue;
    }

    private void checkboxChanged(ActionEvent event) {
        this.myValue = NlBooleanRenderer.getBoolean(this.myCheckbox.getState());
        this.stopEditing(this.myValue);
        this.updateTipText();
    }

    private void updateTipText() {
        switch (this.myCheckbox.getState()) {
            case DONT_CARE: {
                this.myCheckbox.setToolTipText(TIP_TEXT_DONT_CARE);
                break;
            }
            case NOT_SELECTED: {
                this.myCheckbox.setToolTipText(TIP_TEXT_NOT_SELECTED);
                break;
            }
            case SELECTED: {
                this.myCheckbox.setToolTipText(TIP_TEXT_SELECTED);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/NlBooleanEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlBooleanEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperty";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createForInspector";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

