/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesGrouper;
import com.android.tools.idea.uibuilder.property.NlPropertiesSorter;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.editors.NlPropertyEditors;
import com.android.tools.idea.uibuilder.property.renderer.NlPropertyRenderers;
import com.android.tools.property.ptable.PTable;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NlPropertyTableBuilder {
    private final Project myProject;
    private final PTable myTable;
    private final List<NlComponent> myComponents;
    private final List<NlPropertyItem> myProperties;

    NlPropertyTableBuilder(@NotNull Project project, @NotNull PTable table2, @NotNull List<NlComponent> components, @NotNull List<NlPropertyItem> properties) {
        if (project == null) {
            NlPropertyTableBuilder.$$$reportNull$$$0(0);
        }
        if (table2 == null) {
            NlPropertyTableBuilder.$$$reportNull$$$0(1);
        }
        if (components == null) {
            NlPropertyTableBuilder.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            NlPropertyTableBuilder.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myTable = table2;
        this.myComponents = components;
        this.myProperties = properties;
    }

    public boolean build() {
        List<PTableItem> groupedProperties;
        if (this.myComponents.isEmpty()) {
            groupedProperties = Collections.emptyList();
        } else {
            List<NlPropertyItem> sortedProperties = new NlPropertiesSorter().sort(this.myProperties, this.myComponents);
            groupedProperties = new NlPropertiesGrouper().group(sortedProperties, this.myComponents);
        }
        if (this.myTable.isEditing()) {
            this.myTable.removeEditor();
        }
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        this.myTable.getModel().setItems(groupedProperties);
        this.myTable.setRendererProvider(NlPropertyRenderers.getInstance());
        this.myTable.setEditorProvider(NlPropertyEditors.getInstance(this.myProject));
        if (this.myTable.getRowCount() > 0) {
            this.myTable.restoreSelection(selectedRow, selectedItem);
        }
        return !groupedProperties.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "table";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "components";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "properties";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/uibuilder/property/NlPropertyTableBuilder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

