/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.uibuilder.property.NlPropertiesGrouper;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NlPropertiesSorter {
    public List<NlPropertyItem> sort(@NotNull List<NlPropertyItem> groupedProperties, @NotNull List<NlComponent> components) {
        if (groupedProperties == null) {
            NlPropertiesSorter.$$$reportNull$$$0(0);
        }
        if (components == null) {
            NlPropertiesSorter.$$$reportNull$$$0(1);
        }
        String tagName = NlPropertiesGrouper.getCommonTagName(components);
        Set<String> modifiedAttributeNames = NlPropertiesSorter.getModifiedAttributes(components);
        groupedProperties.sort(Comparator.comparing(property2 -> SortOrder.of(property2.getName(), property2.getName().equalsIgnoreCase(tagName), modifiedAttributeNames.contains(property2.getName()))).thenComparing(NlPropertyItem::getName).thenComparing(NlPropertyItem::getNamespace));
        return groupedProperties;
    }

    @NotNull
    public static Set<String> getModifiedAttributes(@NotNull List<NlComponent> components) {
        if (components == null) {
            NlPropertiesSorter.$$$reportNull$$$0(2);
        }
        List<AttributeSnapshot> attrs = components.get(0).getAttributes();
        HashSet modifiedAttrs = Sets.newHashSetWithExpectedSize((int)attrs.size());
        for (NlComponent component3 : components) {
            attrs = component3.getAttributes();
            for (AttributeSnapshot snapshot : attrs) {
                modifiedAttrs.add(snapshot.name);
            }
        }
        HashSet hashSet = modifiedAttrs;
        if (hashSet == null) {
            NlPropertiesSorter.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupedProperties";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/NlPropertiesSorter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlPropertiesSorter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModifiedAttributes";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum SortOrder {
        id,
        layout_width,
        layout_height,
        layout_constraint,
        layout_margin,
        padding,
        opacity,
        elevation,
        modified,
        accessibility,
        theme,
        styles,
        important,
        expert;


        public static SortOrder of(@NotNull String item, boolean isMainClass, boolean isModifiedAttribute) {
            if (item == null) {
                SortOrder.$$$reportNull$$$0(0);
            }
            for (SortOrder order : SortOrder.values()) {
                if (!order.name().equalsIgnoreCase(item)) continue;
                return order;
            }
            if (isMainClass || isModifiedAttribute) {
                return modified;
            }
            return expert;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/property/NlPropertiesSorter$SortOrder", "of"));
        }
    }
}

