/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.tools;

import com.android.tools.idea.uibuilder.mockup.editor.MockupViewPanel;
import com.android.tools.idea.uibuilder.mockup.editor.SelectionLayer;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class SelectionEditors
extends JPanel
implements MockupViewPanel.SelectionListener {
    private static int W = 0;
    private static int H = 1;
    private static int X = 2;
    private static int Y = 3;
    private final Document[] myBoundsDocuments;
    private final MockupViewPanel myMockupViewPanel;
    private boolean myBoundsUpdating;
    private final DocumentListener myDocumentListener;

    public SelectionEditors(@NotNull MockupViewPanel mockupViewPanel) {
        if (mockupViewPanel == null) {
            SelectionEditors.$$$reportNull$$$0(0);
        }
        this.myBoundsDocuments = new Document[4];
        this.myMockupViewPanel = mockupViewPanel;
        this.myDocumentListener = this.createDocumentListener();
        mockupViewPanel.addSelectionListener(this);
        this.createPositionText();
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            private void processChange(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (SelectionEditors.this.myBoundsUpdating) {
                    return;
                }
                try {
                    Document document = e.getDocument();
                    int value2 = document.getLength() <= 0 ? 0 : Integer.parseInt(document.getText(0, document.getLength()));
                    SelectionLayer selectionLayer = SelectionEditors.this.myMockupViewPanel.getSelectionLayer();
                    Rectangle selection = selectionLayer.getSelection();
                    if (document == SelectionEditors.this.myBoundsDocuments[W]) {
                        selectionLayer.setSelection(selection.x, selection.y, value2, selection.height);
                    } else if (document == SelectionEditors.this.myBoundsDocuments[H]) {
                        selectionLayer.setSelection(selection.x, selection.y, selection.width, value2);
                    } else if (document == SelectionEditors.this.myBoundsDocuments[X]) {
                        selectionLayer.setSelection(value2, selection.y, selection.width, selection.height);
                    } else if (document == SelectionEditors.this.myBoundsDocuments[Y]) {
                        selectionLayer.setSelection(selection.x, value2, selection.width, selection.height);
                    }
                }
                catch (NumberFormatException | BadLocationException exception) {
                    // empty catch block
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processChange(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processChange(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/uibuilder/mockup/editor/tools/SelectionEditors$1", "processChange"));
            }
        };
    }

    private void updateDocuments(@NotNull Rectangle selection) {
        if (selection == null) {
            SelectionEditors.$$$reportNull$$$0(1);
        }
        try {
            this.myBoundsUpdating = true;
            this.myBoundsDocuments[W].remove(0, this.myBoundsDocuments[W].getLength());
            this.myBoundsDocuments[H].remove(0, this.myBoundsDocuments[H].getLength());
            this.myBoundsDocuments[X].remove(0, this.myBoundsDocuments[X].getLength());
            this.myBoundsDocuments[Y].remove(0, this.myBoundsDocuments[Y].getLength());
            this.myBoundsDocuments[W].insertString(0, String.valueOf(selection.width), null);
            this.myBoundsDocuments[H].insertString(0, String.valueOf(selection.height), null);
            this.myBoundsDocuments[X].insertString(0, String.valueOf(selection.x), null);
            this.myBoundsDocuments[Y].insertString(0, String.valueOf(selection.y), null);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            this.myBoundsUpdating = false;
        }
    }

    private void createPositionText() {
        this.createLabelAndField("w", this.myBoundsDocuments, W);
        this.createLabelAndField("h", this.myBoundsDocuments, H);
        this.createLabelAndField("x", this.myBoundsDocuments, X);
        this.createLabelAndField("y", this.myBoundsDocuments, Y);
    }

    @NotNull
    private JTextField createLabelAndField(@NotNull String label, @NotNull Document[] documents, int documentIndex) {
        if (label == null) {
            SelectionEditors.$$$reportNull$$$0(2);
        }
        if (documents == null) {
            SelectionEditors.$$$reportNull$$$0(3);
        }
        JLabel jLabel = new JLabel(label);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        JFormattedTextField jTextField = new JFormattedTextField(NumberFormat.getIntegerInstance(Locale.US));
        jTextField.setName(label);
        jTextField.setHorizontalAlignment(0);
        jTextField.setColumns(4);
        jTextField.setBorder(IdeBorderFactory.createBorder((int)15));
        jTextField.setPreferredSize(new Dimension(5, jTextField.getPreferredSize().height));
        jLabel.setLabelFor(jTextField);
        if (documentIndex >= 0 && documentIndex < documents.length) {
            documents[documentIndex] = jTextField.getDocument();
            documents[documentIndex].addDocumentListener(this.myDocumentListener);
        }
        this.add(jLabel);
        this.add(jTextField);
        JFormattedTextField jFormattedTextField = jTextField;
        if (jFormattedTextField == null) {
            SelectionEditors.$$$reportNull$$$0(4);
        }
        return jFormattedTextField;
    }

    public void setSelection(@NotNull Rectangle selection) {
        if (selection == null) {
            SelectionEditors.$$$reportNull$$$0(5);
        }
        this.updateDocuments(selection);
    }

    @Override
    public void selectionStarted(MockupViewPanel mockupViewPanel, int x, int y) {
    }

    @Override
    public void selectionEnded(MockupViewPanel mockupViewPanel, Rectangle selection) {
        this.updateDocuments(selection);
        this.setVisible(!selection.isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockupViewPanel";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documents";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/tools/SelectionEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/tools/SelectionEditors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabelAndField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateDocuments";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLabelAndField";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

