/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.backgroundremove.RemoveBackgroundPanel;
import com.android.tools.idea.uibuilder.mockup.editor.creators.ResourcesUtil;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ExtractBackgroundForm;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageViewCreator
extends SimpleViewCreator {
    public static final Logger LOGGER = Logger.getInstance(ImageViewCreator.class);
    public static final String DRAWABLE_TYPE = "png";
    private final Rectangle mySelection;
    private RemoveBackgroundPanel myRemoveBackgroundPanel;
    private ExtractBackgroundForm myExtractBackgroundForm;
    @Nullable
    private String myDrawableName;

    public ImageViewCreator(@NotNull Mockup mockup, @NotNull NlModel model2, @NotNull SceneView screenView, @NotNull Rectangle selection) {
        if (mockup == null) {
            ImageViewCreator.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            ImageViewCreator.$$$reportNull$$$0(1);
        }
        if (screenView == null) {
            ImageViewCreator.$$$reportNull$$$0(2);
        }
        if (selection == null) {
            ImageViewCreator.$$$reportNull$$$0(3);
        }
        super(mockup, model2, screenView, selection);
        this.mySelection = selection;
        this.myRemoveBackgroundPanel = new RemoveBackgroundPanel();
        this.myExtractBackgroundForm = new ExtractBackgroundForm(this.myRemoveBackgroundPanel);
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        return "ImageView";
    }

    @Override
    public boolean hasOptionsComponent() {
        return true;
    }

    @Override
    @Nullable
    public JComponent getOptionsComponent(@NotNull WidgetCreator.DoneCallback doneCallback) {
        Mockup mockup;
        BufferedImage image;
        if (doneCallback == null) {
            ImageViewCreator.$$$reportNull$$$0(4);
        }
        if ((image = (mockup = this.getMockup()).getImage()) == null) {
            return null;
        }
        this.myExtractBackgroundForm.setOKListener(actionEvent -> {
            BufferedImage extractedImage = this.myRemoveBackgroundPanel.getImage();
            if (extractedImage == null) {
                doneCallback.done(0);
                return;
            }
            this.myDrawableName = this.myExtractBackgroundForm.getDrawableName();
            if (ResourcesUtil.checkDrawableExist(this.myDrawableName, DRAWABLE_TYPE, this.getModel().getFacet())) {
                this.myExtractBackgroundForm.setErrorText(String.format("A drawable resource named <i>%s</i> already exists and will be overwritten.", this.myDrawableName));
                return;
            }
            ResourcesUtil.createDrawable(this.myDrawableName, DRAWABLE_TYPE, doneCallback, this.getModel(), extractedImage, this);
        });
        Rectangle realCropping = mockup.getComputedCropping();
        BufferedImage subimage = image.getSubimage(realCropping.x + this.mySelection.x, realCropping.y + this.mySelection.y, this.mySelection.width, this.mySelection.height);
        this.myRemoveBackgroundPanel.setImage(subimage);
        this.myRemoveBackgroundPanel.setPreferredSize(new Dimension(300, 300));
        return this.myExtractBackgroundForm.getComponent();
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            ImageViewCreator.$$$reportNull$$$0(5);
        }
        super.addAttributes(transaction);
        if (this.getDrawableName() != null) {
            transaction.setAttribute(null, "android:src", "@drawable/" + this.getDrawableName());
        }
    }

    @Nullable
    public String getDrawableName() {
        return this.myDrawableName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doneCallback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/creators/ImageViewCreator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionsComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

