/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.colorextractor;

import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.colorextractor.Clusterer;
import com.android.tools.idea.uibuilder.mockup.colorextractor.DoublesColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ExtractedColor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.KMeansClusterer;
import com.android.tools.pixelprobe.color.Colors;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class KMeansColorExtractor
extends DoublesColorExtractor {
    private static int K = 10;
    private int myK = K;

    KMeansColorExtractor(Mockup mockup) {
        super(mockup);
    }

    KMeansColorExtractor(BufferedImage image, int k) {
        super(image);
        this.myK = k;
    }

    @Override
    List<ExtractedColor> runClustering(HashMap<Integer, Integer> labToRgb, List<double[]> clusterInput, Clusterer.ProgressListener listener2) {
        List<List<double[]>> clusters = new KMeansClusterer(this.myK).cluster((double[][])clusterInput.toArray((T[])new double[clusterInput.size()][3]));
        ArrayList<ExtractedColor> extractedColors = new ArrayList<ExtractedColor>(clusters.size());
        ColorSpace labColorSpace = Colors.getLabColorSpace();
        for (List<double[]> cluster : clusters) {
            double[] color = cluster.get(0);
            float[] rgb = labColorSpace.toRGB(new float[]{(float)color[0], (float)color[1], (float)color[2]});
            int rgbInt = Math.round(rgb[0] * 255.0f) << 16 | Math.round(rgb[1] * 255.0f) << 8 | Math.round(rgb[2] * 255.0f);
            extractedColors.add(new ExtractedColor(rgbInt, 1, null));
        }
        return extractedColors;
    }
}

