/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.mockup.MockupFileHelper;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.util.ListenerCollection;
import com.android.tools.pixelprobe.Guide;
import com.android.tools.pixelprobe.Image;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Mockup
implements ModelListener {
    private static final Pattern REGEX_CROP = Pattern.compile("(([0-9]+|-1)\\s+([0-9]+|-1)\\s*){1,2}");
    private static final Pattern REGEX_CROP_BOUNDS = Pattern.compile(REGEX_CROP + "(\\s+[-]?[0-9]+\\s+[-]?[0-9]+\\s*){1,2}");
    private static final Pattern REGEX_OPACITY = Pattern.compile("[01]|[01]?\\.\\d+");
    static final float DEFAULT_OPACITY = 0.5f;
    static final float DEFAULT_OPACITY_IF_ERROR = 1.0f;
    private static final int X = 4;
    private static final int Y = 5;
    private static final int W = 6;
    private static final int H = 7;
    private static final int C_X = 0;
    private static final int C_Y = 1;
    private static final int C_W = 2;
    private static final int C_H = 3;
    private static final Map<NlComponent, Mockup> MOCKUP_CACHE = ContainerUtil.createWeakMap();
    private final ListenerCollection<MockupModelListener> myListeners = ListenerCollection.createWithDirectExecutor();
    private final Rectangle myBounds;
    private final Rectangle myCropping;
    private final Rectangle mySwingBounds;
    private NlModel myNlModel;
    @Nullable
    String myFilePath;
    @Nullable
    Image myImage;
    private float myAlpha = 0.5f;
    private NlComponent myComponent;
    private boolean myIsFullScreen;
    private int myChangingFlags = 0;
    private Rectangle myRealCropping = new Rectangle();

    @Nullable
    public static Mockup create(@NotNull NlComponent component3, boolean createWithoutAttribute) {
        if (component3 == null) {
            Mockup.$$$reportNull$$$0(0);
        }
        if (Mockup.hasMockupAttribute(component3) || createWithoutAttribute) {
            if (MOCKUP_CACHE.containsKey(component3)) {
                return MOCKUP_CACHE.get(component3);
            }
            Mockup mockup = new Mockup(component3);
            MOCKUP_CACHE.put(component3, mockup);
            Disposer.register((Disposable)component3.getModel(), () -> MOCKUP_CACHE.remove(component3));
            return mockup;
        }
        return null;
    }

    public static Mockup create(@NotNull NlComponent component3) {
        if (component3 == null) {
            Mockup.$$$reportNull$$$0(1);
        }
        return Mockup.create(component3, false);
    }

    @NotNull
    public static List<Mockup> createAll(NlModel model2) {
        ArrayList<Mockup> mockup = new ArrayList<Mockup>();
        ImmutableList<NlComponent> components = model2.getComponents();
        if (!components.isEmpty()) {
            NlComponent root2 = ((NlComponent)components.get(0)).getRoot();
            Mockup.createAll(mockup, root2);
        }
        ArrayList<Mockup> arrayList = mockup;
        if (arrayList == null) {
            Mockup.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void createAll(@NotNull List<Mockup> list, @NotNull NlComponent component3) {
        Mockup mockup;
        if (list == null) {
            Mockup.$$$reportNull$$$0(3);
        }
        if (component3 == null) {
            Mockup.$$$reportNull$$$0(4);
        }
        if ((mockup = Mockup.create(component3, false)) != null) {
            list.add(mockup);
        }
        for (int i2 = 0; i2 < component3.getChildCount(); ++i2) {
            NlComponent child = component3.getChild(i2);
            if (child == null) continue;
            Mockup.createAll(list, child);
        }
    }

    public static boolean hasMockupAttribute(@Nullable NlComponent component3) {
        return component3 != null && component3.getAttribute("http://schemas.android.com/tools", "mockup") != null;
    }

    private Mockup(NlComponent component3) {
        this.myBounds = new Rectangle(0, 0, -1, -1);
        this.myCropping = new Rectangle(0, 0, -1, -1);
        this.mySwingBounds = new Rectangle();
        this.myComponent = component3;
        this.myNlModel = component3.getModel();
        this.myNlModel.addListener(this);
        this.parseComponent(component3);
    }

    private void parseComponent(NlComponent component3) {
        this.myComponent = component3;
        String fileName = this.myComponent.getAttribute("http://schemas.android.com/tools", "mockup");
        String position = this.myComponent.getAttribute("http://schemas.android.com/tools", "mockup_crop");
        String opacity = this.myComponent.getAttribute("http://schemas.android.com/tools", "mockup_opacity");
        if (fileName != null && (this.myChangingFlags & 1) == 0) {
            this.setFilePath(fileName);
        }
        if (position != null && (this.myChangingFlags & 2) == 0) {
            this.myIsFullScreen = false;
            this.parsePositionString(position);
        } else if (position == null && (this.myChangingFlags & 2) == 0) {
            this.clearCrop();
        }
        if (opacity != null && (this.myChangingFlags & 4) == 0) {
            this.setAlpha(opacity);
        }
        this.myChangingFlags = 0;
    }

    public void setAlpha(String opacity) {
        if (REGEX_OPACITY.matcher(opacity).matches()) {
            this.setAlpha(Float.parseFloat(opacity));
        } else {
            this.setAlpha(1.0f);
        }
        this.notifyListeners(4);
    }

    private boolean setFilePath(@NotNull String filePath) {
        Path path2;
        if (filePath == null) {
            Mockup.$$$reportNull$$$0(5);
        }
        if ((path2 = MockupFileHelper.getFullFilePath(this.myNlModel.getProject(), filePath)) == null) {
            return false;
        }
        if (this.myFilePath == null || !Paths.get(this.myFilePath, new String[0]).equals(path2)) {
            if (this.myFilePath != null && !Paths.get(this.myFilePath, new String[0]).equals(path2)) {
                this.clearCrop();
            }
            this.myFilePath = path2.toString();
            this.myImage = MockupFileHelper.openImageFile(this.myFilePath);
            this.notifyListeners(1);
            return true;
        }
        return false;
    }

    private void parsePositionString(String position) {
        if (Mockup.isPositionStringCorrect(position)) {
            String[] split = (position = position.trim()).split("\\s+");
            if (split.length >= 4) {
                this.setCropping(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]));
            } else if (split.length == 2) {
                this.setCropping(Integer.parseInt(split[0]), Integer.parseInt(split[1]), -1, -1);
            } else {
                this.setCropping(0, 0, -1, -1);
            }
            if (split.length >= 8) {
                this.setBounds(Integer.parseInt(split[4]), Integer.parseInt(split[5]), Integer.parseInt(split[6]), Integer.parseInt(split[7]));
            } else if (split.length >= 6) {
                this.setBounds(Integer.parseInt(split[4]), Integer.parseInt(split[5]), -1, -1);
            } else {
                this.setDefaultBounds();
            }
        } else {
            this.setDefaultBounds();
            this.setCropping(0, 0, -1, -1);
        }
    }

    void setDefaultBounds() {
        this.setBounds(0, 0, -1, -1);
    }

    public void setDefaultCrop() {
        this.setCropping(0, 0, -1, -1);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.myBounds.x != x || this.myBounds.y != y || this.myBounds.width != width || this.myBounds.height != height) {
            this.myBounds.setBounds(x, y, width, height);
            this.myIsFullScreen = false;
            this.notifyListeners(2);
        }
    }

    public void setCropping(int x, int y, int width, int height) {
        if (this.myImage != null) {
            width = width > 0 ? width : this.myImage.getWidth() - x;
            int n = height = height > 0 ? height : this.myImage.getHeight() - y;
        }
        if (this.myCropping.x != x || this.myCropping.y != y || this.myCropping.width != width || this.myCropping.height != height) {
            this.myCropping.setBounds(x, y, width, height);
            this.notifyListeners(2);
        }
        this.myIsFullScreen = false;
    }

    public Rectangle getBounds() {
        return this.myBounds;
    }

    public Rectangle getScreenBounds(ScreenView screenView) {
        int androidX = Coordinates.dpToPx((SceneView)screenView, this.myBounds.x);
        int androidY = Coordinates.dpToPx((SceneView)screenView, this.myBounds.y);
        int androidWidth = this.myBounds.width <= 0 ? NlComponentHelperKt.getW(this.myComponent) : Coordinates.dpToPx((SceneView)screenView, this.myBounds.width);
        int androidHeight = this.myBounds.height <= 0 ? NlComponentHelperKt.getH(this.myComponent) : Coordinates.dpToPx((SceneView)screenView, this.myBounds.height);
        this.mySwingBounds.x = Coordinates.getSwingX((SceneView)screenView, NlComponentHelperKt.getX(this.myComponent) + androidX);
        this.mySwingBounds.y = Coordinates.getSwingY((SceneView)screenView, NlComponentHelperKt.getY(this.myComponent) + androidY);
        this.mySwingBounds.width = Coordinates.getSwingDimension((SceneView)screenView, androidWidth - androidX);
        this.mySwingBounds.height = Coordinates.getSwingDimension((SceneView)screenView, androidHeight - androidY);
        return this.mySwingBounds;
    }

    public boolean isFullScreen() {
        return this.myIsFullScreen;
    }

    public Rectangle getCropping() {
        return this.myCropping;
    }

    public Rectangle getComputedCropping() {
        if (this.myCropping.width >= 0 && this.myCropping.height >= 0) {
            return this.myCropping;
        }
        this.myRealCropping.setBounds(this.myCropping);
        if (this.myImage == null) {
            this.myRealCropping.width = 0;
            this.myRealCropping.height = 0;
        }
        if (this.myRealCropping.width < 0) {
            this.myRealCropping.width = this.myImage.getWidth();
        }
        if (this.myRealCropping.height < 0) {
            this.myRealCropping.height = this.myImage.getHeight();
        }
        return this.myRealCropping;
    }

    @Nullable
    public String getFilePath() {
        return this.myFilePath;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile toSelect = this.getFilePath() == null ? null : VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemIndependentName((String)this.getFilePath())), (boolean)false);
        return toSelect;
    }

    @Nullable
    public BufferedImage getImage() {
        return this.myImage == null ? null : this.myImage.getMergedImage();
    }

    @Nullable
    public List<Guide> getGuidelines() {
        if (this.myImage == null && this.myFilePath != null && !this.myFilePath.isEmpty()) {
            this.myImage = MockupFileHelper.openImageFile(this.myFilePath);
        }
        return this.myImage == null ? null : this.myImage.getGuides();
    }

    public static boolean isPositionStringCorrect(@Nullable String s) {
        if (s == null) {
            return false;
        }
        return s.isEmpty() || REGEX_CROP_BOUNDS.matcher(s).matches() || REGEX_CROP.matcher(s).matches();
    }

    public void setAlpha(float alpha) {
        if (alpha != this.myAlpha) {
            this.myAlpha = Math.min(1.0f, Math.max(0.0f, alpha));
            this.notifyListeners(7);
        }
    }

    public float getAlpha() {
        return this.myAlpha;
    }

    @Override
    public void modelDerivedDataChanged(@NotNull NlModel model2) {
        if (model2 == null) {
            Mockup.$$$reportNull$$$0(6);
        }
        this.parseComponent(this.myComponent);
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
        if (model2 == null) {
            Mockup.$$$reportNull$$$0(7);
        }
    }

    public void addMockupListener(MockupModelListener listener2) {
        if (listener2 != null) {
            this.myListeners.add(listener2);
        }
    }

    public void removeMockupListener(MockupModelListener listener2) {
        this.myListeners.remove(listener2);
    }

    private void notifyListeners(int changedFlags) {
        this.myChangingFlags = changedFlags;
        this.myListeners.forEach(l -> l.mockupChanged(this, changedFlags));
    }

    public NlComponent getComponent() {
        return this.myComponent;
    }

    public void clearCrop() {
        this.setDefaultBounds();
        this.setDefaultCrop();
        this.myIsFullScreen = true;
        MockupFileHelper.writePositionToXML(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/Mockup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/Mockup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "modelDerivedDataChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modelChangedOnLayout";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface MockupModelListener {
        public static final int FLAG_FILE_CHANGED = 1;
        public static final int FLAG_CROP_CHANGED = 2;
        public static final int FLAG_OPACITY_CHANGED = 4;

        public void mockupChanged(Mockup var1, int var2);
    }
}

