/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.ComponentProvider;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.relative.targets.RelativeDragTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\"\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/relative/RelativeDragHandler;", "Lcom/android/tools/idea/uibuilder/api/DragHandler;", "editor", "Lcom/android/tools/idea/uibuilder/api/ViewEditor;", "handler", "Lcom/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler;", "layout", "Lcom/android/tools/idea/common/scene/SceneComponent;", "components", "", "Lcom/android/tools/idea/common/model/NlComponent;", "type", "Lcom/android/tools/idea/common/api/DragType;", "(Lcom/android/tools/idea/uibuilder/api/ViewEditor;Lcom/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler;Lcom/android/tools/idea/common/scene/SceneComponent;Ljava/util/List;Lcom/android/tools/idea/common/api/DragType;)V", "component", "dragTarget", "Lcom/android/tools/idea/uibuilder/handlers/relative/targets/RelativeDragTarget;", "cancel", "", "commit", "x", "", "y", "modifiers", "insertType", "Lcom/android/tools/idea/common/api/InsertType;", "start", "update", "", "intellij.android.designer"})
public final class RelativeDragHandler
extends DragHandler {
    private final SceneComponent component;
    private final RelativeDragTarget dragTarget;

    @Override
    public void start(int x, int y, int modifiers) {
        if (this.component == null) {
            return;
        }
        super.start(x, y, modifiers);
        this.dragTarget.mouseDown(x, y);
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        if (this.component == null) {
            return "undefined";
        }
        String result2 = super.update(x, y, modifiers);
        int dx = x + this.startX - this.component.getDrawWidth() / 2;
        int dy = y + this.startY - this.component.getDrawHeight() / 2;
        this.dragTarget.mouseDrag(dx, dy, CollectionsKt.emptyList());
        return result2;
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        if (this.component == null) {
            return;
        }
        SceneComponent sceneComponent = this.layout;
        Intrinsics.checkNotNullExpressionValue((Object)sceneComponent, (String)"layout");
        this.editor.insertChildren(sceneComponent.getNlComponent(), this.components, -1, insertType);
        boolean bl = this.components.size() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int dx = this.editor.pxToDp(x) + this.startX - this.component.getDrawWidth() / 2;
        int dy = this.editor.pxToDp(y) + this.startY - this.component.getDrawHeight() / 2;
        this.dragTarget.mouseRelease(dx, dy, CollectionsKt.emptyList());
        SceneComponent sceneComponent2 = this.layout;
        Intrinsics.checkNotNullExpressionValue((Object)sceneComponent2, (String)"layout");
        sceneComponent2.getScene().removeComponent(this.component);
        SceneComponent sceneComponent3 = this.layout;
        Intrinsics.checkNotNullExpressionValue((Object)sceneComponent3, (String)"layout");
        sceneComponent3.getScene().requestLayoutIfNeeded();
    }

    @Override
    public void cancel() {
        if (this.component != null) {
            SceneComponent sceneComponent = this.layout;
            Intrinsics.checkNotNullExpressionValue((Object)sceneComponent, (String)"layout");
            sceneComponent.getScene().removeComponent(this.component);
        }
        this.dragTarget.mouseCancel();
    }

    /*
     * WARNING - void declaration
     */
    public RelativeDragHandler(@NotNull ViewEditor editor2, @NotNull RelativeLayoutHandler handler, @NotNull SceneComponent layout2, final @NotNull List<? extends NlComponent> components, @NotNull DragType type) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(editor2, handler, layout2, components, type);
        this.dragTarget = new RelativeDragTarget();
        if (components.size() == 1) {
            NlComponent dragged = components.get(0);
            RelativeDragHandler relativeDragHandler = this;
            SceneComponent sceneComponent = layout2.getScene().getSceneComponent(dragged);
            if (sceneComponent == null) {
                void $this$apply;
                TemporarySceneComponent temporarySceneComponent = new TemporarySceneComponent(layout2.getScene(), dragged);
                boolean bl = false;
                boolean bl2 = false;
                TemporarySceneComponent temporarySceneComponent2 = temporarySceneComponent;
                RelativeDragHandler relativeDragHandler2 = relativeDragHandler;
                boolean bl3 = false;
                $this$apply.setSize(editor2.pxToDp(NlComponentHelperKt.getW(dragged)), editor2.pxToDp(NlComponentHelperKt.getH(dragged)));
                Unit unit = Unit.INSTANCE;
                relativeDragHandler = relativeDragHandler2;
                sceneComponent = temporarySceneComponent;
            }
            relativeDragHandler.component = sceneComponent;
            this.component.setTargetProvider(new TargetProvider(){

                @Override
                @NotNull
                public final List<Target> createTargets(@NotNull SceneComponent $noName_0) {
                    Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                    return CollectionsKt.mutableListOf((Object[])new Target[]{dragTarget});
                }
            });
            this.component.updateTargets();
            this.component.setComponentProvider(new ComponentProvider(){

                @Override
                public final NlComponent getComponent(@NotNull SceneComponent $noName_0) {
                    Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                    return (NlComponent)components.get(0);
                }
            });
            layout2.addChild(this.component);
            this.component.setDrawState(SceneComponent.DrawState.DRAG);
        } else {
            this.component = null;
        }
    }
}

