/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.NlComponentTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionSelection {
    private final MotionEditorSelector.Type myType;
    private final MTag[] myTags;
    private final MTag[] myConstraintSetTags;
    private final List<? extends NlComponent> myComponents;

    public MotionSelection(@NotNull MotionEditorSelector.Type type, @NotNull MTag[] tags2, @NotNull List<? extends NlComponent> components) {
        if (type == null) {
            MotionSelection.$$$reportNull$$$0(0);
        }
        if (tags2 == null) {
            MotionSelection.$$$reportNull$$$0(1);
        }
        if (components == null) {
            MotionSelection.$$$reportNull$$$0(2);
        }
        this.myType = type;
        this.myTags = tags2;
        this.myConstraintSetTags = MotionSelection.computeConstraintSetTags(type, tags2);
        this.myComponents = components;
    }

    @Nullable
    private static MTag[] computeConstraintSetTags(@NotNull MotionEditorSelector.Type type, @NotNull MTag[] tags2) {
        if (type == null) {
            MotionSelection.$$$reportNull$$$0(3);
        }
        if (tags2 == null) {
            MotionSelection.$$$reportNull$$$0(4);
        }
        if (type != MotionEditorSelector.Type.CONSTRAINT) {
            return null;
        }
        MTag[] constraintSets = new MTag[tags2.length];
        for (int index = 0; index < tags2.length; ++index) {
            MTag tag = tags2[index];
            MTag constraintSet = null;
            if (tag instanceof NlComponentTag) {
                MotionAttributes attributes = MotionSceneUtils.getAttributes(((NlComponentTag)tag).getComponent());
                if (attributes != null) {
                    constraintSet = attributes.getConstraintSet();
                }
            } else {
                constraintSet = tag.getParent();
            }
            constraintSets[index] = constraintSet;
        }
        return constraintSets;
    }

    public boolean sameSelection(@NotNull MotionSelection other) {
        if (other == null) {
            MotionSelection.$$$reportNull$$$0(5);
        }
        return this.myType == other.myType && this.myComponents.equals(other.myComponents) && MotionSelection.isSameTreeIdHierarchy(this.myTags, other.myTags) && MotionSelection.isSameTreeIdHierarchy(this.myConstraintSetTags, other.myConstraintSetTags);
    }

    private static boolean isSameTreeIdHierarchy(@Nullable MTag[] tags2, @Nullable MTag[] otherTags) {
        if (tags2 == null || otherTags == null) {
            return tags2 == null && otherTags == null;
        }
        if (tags2.length != otherTags.length) {
            return false;
        }
        if (Arrays.equals(tags2, otherTags)) {
            return true;
        }
        for (int index = 0; index < tags2.length; ++index) {
            if (MotionSelection.isSameTreeIdHierarchy(tags2[index], otherTags[index])) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameTreeIdHierarchy(@Nullable MTag tag, @Nullable MTag other) {
        if (tag == null || other == null) {
            return tag == null && other == null;
        }
        if (tag == other) {
            return true;
        }
        return tag.isSameTreeIdHierarchy(other);
    }

    public void update(@NotNull MotionSelection newSelection) {
        if (newSelection == null) {
            MotionSelection.$$$reportNull$$$0(6);
        }
        System.arraycopy(newSelection.myTags, 0, this.myTags, 0, this.myTags.length);
    }

    @NotNull
    public MotionEditorSelector.Type getType() {
        MotionEditorSelector.Type type = this.myType;
        if (type == null) {
            MotionSelection.$$$reportNull$$$0(7);
        }
        return type;
    }

    @NotNull
    public MTag[] getTags() {
        if (this.myTags == null) {
            MotionSelection.$$$reportNull$$$0(8);
        }
        return this.myTags;
    }

    @NotNull
    public List<? extends NlComponent> getComponents() {
        List<? extends NlComponent> list = this.myComponents;
        if (list == null) {
            MotionSelection.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public MotionSceneTag getMotionSceneTag() {
        if (this.myTags.length == 0) {
            return null;
        }
        MTag firstTag2 = this.myTags[0];
        if (!(firstTag2 instanceof MotionSceneTag)) {
            return null;
        }
        return (MotionSceneTag)firstTag2;
    }

    @Nullable
    private NlComponentTag getNlComponentTag() {
        if (this.myTags.length == 0) {
            return null;
        }
        MTag firstTag2 = this.myTags[0];
        if (!(firstTag2 instanceof NlComponentTag)) {
            return null;
        }
        return (NlComponentTag)firstTag2;
    }

    @Nullable
    public String getMotionSceneTagName() {
        MotionSceneTag tag = this.getMotionSceneTag();
        return tag != null ? tag.getTagName() : null;
    }

    @Nullable
    public XmlTag getXmlTag(@Nullable MotionSceneTag tag) {
        return tag != null ? tag.getXmlTag() : null;
    }

    @Nullable
    public PsiFile getSceneFile() {
        MotionSceneTag tag = this.getMotionSceneTag();
        XmlTag xml = this.getXmlTag(tag);
        if (xml != null) {
            return xml.getContainingFile();
        }
        return null;
    }

    @Nullable
    public MotionAttributes getMotionAttributes() {
        NlComponent component3 = this.getComponent();
        return component3 != null ? MotionSceneUtils.getAttributes(component3) : null;
    }

    @Nullable
    public Icon getComponentIcon() {
        NlComponent component3 = this.getComponent();
        if (component3 == null) {
            return null;
        }
        NlComponent.XmlModelComponentMixin mixin = component3.getMixin();
        return mixin != null ? mixin.getIcon() : null;
    }

    @Nullable
    public String getComponentId() {
        NlComponent component3 = this.getComponent();
        if (component3 == null) {
            return null;
        }
        return component3.getAttribute("http://schemas.android.com/apk/res/android", "id");
    }

    @Nullable
    public String getConstraintSetId() {
        if (this.myType != MotionEditorSelector.Type.CONSTRAINT) {
            return null;
        }
        MotionSceneTag tag = this.getMotionSceneTag();
        MTag parent = null;
        if (tag != null) {
            parent = tag.getParent();
        } else {
            MotionAttributes attrs = this.getMotionAttributes();
            if (attrs != null) {
                parent = attrs.getConstraintSet();
            }
        }
        return parent != null ? parent.getAttributeValue("id") : null;
    }

    @Nullable
    public NlComponent getComponent() {
        NlComponentTag componentTag = this.getNlComponentTag();
        if (componentTag != null) {
            return componentTag.getComponent();
        }
        MotionSceneTag motionTag = this.getMotionSceneTag();
        if (motionTag == null || !Objects.equals(motionTag.getTagName(), "Constraint")) {
            return null;
        }
        return this.getComponentFromConstraintTag(motionTag);
    }

    @Nullable
    public NlComponent getComponentForCustomAttributeCompletions() {
        NlComponentTag componentTag = this.getNlComponentTag();
        if (componentTag != null) {
            return componentTag.getComponent();
        }
        MotionSceneTag motionTag = this.getMotionSceneTag();
        if (motionTag == null || motionTag.getTagName() == null) {
            return null;
        }
        switch (motionTag.getTagName()) {
            case "Constraint": {
                return this.getComponentFromConstraintTag(motionTag);
            }
            case "KeyAttribute": 
            case "KeyCycle": 
            case "KeyTimeCycle": {
                return this.getComponentFromKeyWithArbitraryBackup(motionTag);
            }
        }
        return null;
    }

    private NlComponent getComponentFromConstraintTag(@NotNull MTag constraintTag) {
        if (constraintTag == null) {
            MotionSelection.$$$reportNull$$$0(10);
        }
        String constraintId = Utils.stripID(constraintTag.getAttributeValue("id"));
        if (this.myComponents.isEmpty()) {
            return null;
        }
        NlComponent motionLayout = this.getMotionLayoutComponent();
        if (motionLayout == null) {
            return null;
        }
        return motionLayout.getChildren().stream().filter(view -> constraintId.equals(view.getId())).findFirst().orElse(null);
    }

    private NlComponent getMotionLayoutComponent() {
        NlComponent motionLayout = this.myComponents.get(0);
        if (!SdkConstants.MOTION_LAYOUT.isEquals(motionLayout.getTagName())) {
            motionLayout = motionLayout.getParent();
        }
        if (motionLayout == null || !SdkConstants.MOTION_LAYOUT.isEquals(motionLayout.getTagName())) {
            return null;
        }
        return motionLayout;
    }

    private NlComponent getComponentFromKeyWithArbitraryBackup(@NotNull MotionSceneTag keyTag) {
        if (keyTag == null) {
            MotionSelection.$$$reportNull$$$0(11);
        }
        if (this.myComponents.isEmpty()) {
            return null;
        }
        NlComponent component3 = this.getComponentFromKey(keyTag);
        return component3 != null ? component3 : this.myComponents.get(0);
    }

    private NlComponent getComponentFromKey(@NotNull MotionSceneTag keyTag) {
        MTag keyFrameSet;
        if (keyTag == null) {
            MotionSelection.$$$reportNull$$$0(12);
        }
        if ((keyFrameSet = keyTag.getParent()) == null) {
            return null;
        }
        MTag transition = keyFrameSet.getParent();
        if (transition == null) {
            return null;
        }
        String startConstraintSetId = Utils.stripID(transition.getAttributeValue("constraintSetStart"));
        if (startConstraintSetId.isEmpty()) {
            return null;
        }
        MTag motionScene = transition.getParent();
        if (motionScene == null) {
            return null;
        }
        MTag startConstraint = Arrays.stream(motionScene.getChildTags("ConstraintSet")).filter(mtag -> Utils.stripID(mtag.getAttributeValue("id")).equals(startConstraintSetId)).findFirst().orElse(null);
        if (startConstraint == null) {
            return null;
        }
        return Arrays.stream(startConstraint.getChildTags("Constraint")).map(mTag -> this.getComponentFromConstraintTag((MTag)mTag)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/property2/MotionSelection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintTag";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/property2/MotionSelection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeConstraintSetTags";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sameSelection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getComponentFromConstraintTag";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getComponentFromKeyWithArbitraryBackup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getComponentFromKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

