/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionIdPropertyItem;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionSelection;
import com.android.tools.idea.uibuilder.property2.NeleFlagsPropertyItem;
import com.android.tools.idea.uibuilder.property2.NelePropertiesModel;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.idea.uibuilder.property2.NelePropertyType;
import com.android.tools.idea.uibuilder.property2.PropertiesProvider;
import com.android.tools.idea.uibuilder.property2.support.TypeResolver;
import com.android.tools.property.panel.api.PropertiesTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.awt.EventQueue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutPropertyProvider
implements PropertiesProvider {
    private final AndroidFacet myFacet;
    private final Project myProject;
    private final XmlElementDescriptorProvider myDescriptorProvider;
    private final Table<String, String, NelePropertyItem> myEmptyTable;
    private static final int EXPECTED_ROWS = 3;
    private static final int EXPECTED_CELLS_PER_ROW = 10;
    private static final List<String> INCLUDE_SUB_TAGS_OF = ImmutableList.of((Object)"Constraint", (Object)"Transition");

    public MotionLayoutPropertyProvider(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(0);
        }
        this.myFacet = facet2;
        this.myProject = facet2.getModule().getProject();
        this.myDescriptorProvider = new AndroidDomElementDescriptorProvider();
        this.myEmptyTable = ImmutableTable.of();
    }

    @Override
    @NotNull
    public PropertiesTable<NelePropertyItem> getProperties(@NotNull NelePropertiesModel model2, @Nullable Object optionalValue, @NotNull List<? extends NlComponent> components) {
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(1);
        }
        if (components == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(2);
        }
        PropertiesTable<NelePropertyItem> propertiesTable = PropertiesTable.Companion.emptyTable();
        if (propertiesTable == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(3);
        }
        return propertiesTable;
    }

    @NotNull
    public Map<String, PropertiesTable<NelePropertyItem>> getAllProperties(@NotNull NelePropertiesModel model2, @NotNull MotionSelection selection) {
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(4);
        }
        if (selection == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(5);
        }
        assert (!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        Map map2 = (Map)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> this.getPropertiesImpl(model2, selection));
        if (map2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @Override
    @NotNull
    public PropertiesTable<NelePropertyItem> createEmptyTable() {
        PropertiesTable<NelePropertyItem> propertiesTable = PropertiesTable.Companion.create(HashBasedTable.create((int)3, (int)10));
        if (propertiesTable == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(7);
        }
        return propertiesTable;
    }

    private Map<String, PropertiesTable<NelePropertyItem>> getPropertiesImpl(@NotNull NelePropertiesModel model2, @NotNull MotionSelection selection) {
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(8);
        }
        if (selection == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(9);
        }
        if (selection.getComponents().isEmpty()) {
            return Collections.emptyMap();
        }
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(this.myFacet);
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        FrameworkResourceManager frameworkResourceManager = resourceManagers.getFrameworkResourceManager();
        if (frameworkResourceManager == null) {
            Logger.getInstance(MotionLayoutPropertyProvider.class).error("No system resource manager for module: " + this.myFacet.getModule().getName());
            return Collections.emptyMap();
        }
        AttributeDefinitions localAttrDefs = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
        if (localAttrDefs == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, PropertiesTable<NelePropertyItem>> allProperties = new LinkedHashMap<String, PropertiesTable<NelePropertyItem>>();
        MotionSceneTag motionSceneTag = selection.getMotionSceneTag();
        XmlTag tag = selection.getXmlTag(motionSceneTag);
        if (motionSceneTag != null && tag != null) {
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                return Collections.emptyMap();
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor descriptor2 : descriptors) {
                String namespaceUri = MotionLayoutPropertyProvider.getNamespace(descriptor2, tag);
                String name = descriptor2.getName();
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android" == namespaceUri ? systemAttrDefs : localAttrDefs;
                ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri);
                AttributeDefinition attrDef = namespace != null && attrDefs != null ? attrDefs.getAttrDefinition(ResourceReference.attr((ResourceNamespace)namespace, (String)name)) : null;
                NelePropertyItem property2 = MotionLayoutPropertyProvider.createProperty(namespaceUri, name, attrDef, model2, selection, null);
                properties.put((Object)namespaceUri, (Object)name, (Object)property2);
            }
            allProperties.put(tag.getLocalName(), PropertiesTable.Companion.create(properties));
            MotionLayoutPropertyProvider.loadCustomAttributes(model2, allProperties, motionSceneTag, selection);
            if (INCLUDE_SUB_TAGS_OF.contains(tag.getLocalName())) {
                XmlElementDescriptor[] subTagDescriptors;
                for (XmlElementDescriptor descriptor3 : subTagDescriptors = elementDescriptor.getElementsDescriptors(tag)) {
                    String subTagName = descriptor3.getName();
                    if (subTagName.equals("CustomAttribute")) continue;
                    Table<String, String, NelePropertyItem> subTagProperties = this.loadFromStyleableName(subTagName, localAttrDefs, model2, selection);
                    allProperties.put(subTagName, PropertiesTable.Companion.create(subTagProperties));
                }
            }
        } else if (selection.getType() == MotionEditorSelector.Type.CONSTRAINT) {
            Table<String, String, NelePropertyItem> constraintProperties = this.loadFromStyleableName("Constraint", localAttrDefs, model2, selection);
            NelePropertyItem id = MotionLayoutPropertyProvider.createProperty("http://schemas.android.com/apk/res/android", "id", null, model2, selection, null);
            constraintProperties.put((Object)id.getNamespace(), (Object)id.getName(), (Object)id);
            allProperties.put("Constraint", PropertiesTable.Companion.create(constraintProperties));
            MotionLayoutPropertyProvider.loadCustomAttributes(model2, allProperties, null, selection);
        }
        return allProperties;
    }

    private static void loadCustomAttributes(@NotNull NelePropertiesModel model2, @NotNull Map<String, PropertiesTable<NelePropertyItem>> allProperties, @Nullable MotionSceneTag motionSceneTag, @NotNull MotionSelection selection) {
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(10);
        }
        if (allProperties == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(11);
        }
        if (selection == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(12);
        }
        MTag[] customTags = motionSceneTag != null ? motionSceneTag.getChildTags("CustomAttribute") : new MTag[]{};
        List<MotionAttributes.DefinedAttribute> inheritedAttributes = Collections.emptyList();
        MotionAttributes attributes = selection.getMotionAttributes();
        if (attributes != null) {
            inheritedAttributes = attributes.getAttrMap().values().stream().filter(defined -> defined.isCustomAttribute()).collect(Collectors.toList());
        }
        if (customTags.length == 0 && inheritedAttributes.isEmpty()) {
            return;
        }
        HashBasedTable customProperties = HashBasedTable.create((int)3, (int)customTags.length);
        block0: for (MTag customTag : customTags) {
            String name = customTag.getAttributeValue("attributeName");
            if (name == null) continue;
            for (String customType : MotionSceneAttrs.ourCustomAttribute) {
                String customValue = customTag.getAttributeValue(customType);
                if (customValue == null) continue;
                NelePropertyItem item = MotionLayoutPropertyProvider.createCustomProperty(name, customType, selection, model2);
                customProperties.put((Object)item.getNamespace(), (Object)item.getName(), (Object)item);
                continue block0;
            }
        }
        inheritedAttributes.forEach(arg_0 -> MotionLayoutPropertyProvider.lambda$loadCustomAttributes$2(selection, model2, (Table)customProperties, arg_0));
        allProperties.put("CustomAttribute", PropertiesTable.Companion.create(customProperties));
    }

    private Table<String, String, NelePropertyItem> loadFromStyleableName(@NotNull String subTagName, @NotNull AttributeDefinitions attrDefs, @NotNull NelePropertiesModel model2, @NotNull MotionSelection selection) {
        ResourceReference reference2;
        StyleableDefinition styleable;
        if (subTagName == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(13);
        }
        if (attrDefs == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(14);
        }
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(15);
        }
        if (selection == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(16);
        }
        if ((styleable = attrDefs.getStyleableDefinition(reference2 = new ResourceReference(ResourceNamespace.TODO(), ResourceType.STYLEABLE, subTagName))) == null) {
            return this.myEmptyTable;
        }
        HashBasedTable properties = HashBasedTable.create((int)3, (int)styleable.getAttributes().size());
        styleable.getAttributes().forEach(arg_0 -> MotionLayoutPropertyProvider.lambda$loadFromStyleableName$3(model2, selection, subTagName, (Table)properties, arg_0));
        return properties;
    }

    public static NelePropertyItem createCustomProperty(@NotNull String name, @NotNull String customType, @NotNull MotionSelection selection, @NotNull NelePropertiesModel model2) {
        if (name == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(17);
        }
        if (customType == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(18);
        }
        if (selection == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(19);
        }
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(20);
        }
        NelePropertyType type = MotionLayoutPropertyProvider.mapFromCustomType(customType);
        List<? extends NlComponent> components = selection.getComponents();
        return new NelePropertyItem("", name, type, null, "", "", model2, components, selection, "CustomAttribute");
    }

    private static NelePropertyItem createProperty(@NotNull String namespace, @NotNull String name, @Nullable AttributeDefinition attr, @NotNull NelePropertiesModel model2, @NotNull MotionSelection selection, @Nullable String subTag) {
        if (namespace == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(21);
        }
        if (name == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(22);
        }
        if (model2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(23);
        }
        if (selection == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(24);
        }
        List<? extends NlComponent> components = selection.getComponents();
        NelePropertyType type = TypeResolver.INSTANCE.resolveType(name, attr);
        String libraryName = StringUtil.notNullize((String)(attr != null ? attr.getLibraryName() : null));
        if (namespace.equals("http://schemas.android.com/apk/res/android") && name.equals("id")) {
            return new MotionIdPropertyItem(model2, attr, "", components, selection, subTag);
        }
        if (attr != null && attr.getFormats().contains(AttributeFormat.FLAGS) && attr.getValues().length == 0) {
            return new NeleFlagsPropertyItem(namespace, name, type, attr, "", libraryName, model2, components, selection, subTag);
        }
        return new NelePropertyItem(namespace, name, type, attr, "", libraryName, model2, components, selection, subTag);
    }

    @NotNull
    private static String getNamespace(@NotNull XmlAttributeDescriptor descriptor2, @NotNull XmlTag context) {
        if (descriptor2 == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(25);
        }
        if (context == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(26);
        }
        String namespace = null;
        if (descriptor2 instanceof NamespaceAwareXmlAttributeDescriptor) {
            namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor2).getNamespace(context);
        }
        return namespace != null ? namespace : "http://schemas.android.com/apk/res/android";
    }

    @NotNull
    static NelePropertyType mapFromCustomType(@NotNull String customType) {
        if (customType == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(27);
        }
        switch (customType) {
            case "customColorValue": {
                NelePropertyType nelePropertyType = NelePropertyType.COLOR;
                if (nelePropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(28);
                }
                return nelePropertyType;
            }
            case "customColorDrawableValue": {
                NelePropertyType nelePropertyType = NelePropertyType.COLOR_STATE_LIST;
                if (nelePropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(29);
                }
                return nelePropertyType;
            }
            case "customIntegerValue": {
                NelePropertyType nelePropertyType = NelePropertyType.INTEGER;
                if (nelePropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(30);
                }
                return nelePropertyType;
            }
            case "customFloatValue": {
                NelePropertyType nelePropertyType = NelePropertyType.FLOAT;
                if (nelePropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(31);
                }
                return nelePropertyType;
            }
            case "customDimension": {
                NelePropertyType nelePropertyType = NelePropertyType.DIMENSION;
                if (nelePropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(32);
                }
                return nelePropertyType;
            }
            case "customPixelDimension": {
                NelePropertyType nelePropertyType = NelePropertyType.DIMENSION_PIXEL;
                if (nelePropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(33);
                }
                return nelePropertyType;
            }
            case "customBoolean": {
                NelePropertyType nelePropertyType = NelePropertyType.BOOLEAN;
                if (nelePropertyType == null) {
                    MotionLayoutPropertyProvider.$$$reportNull$$$0(34);
                }
                return nelePropertyType;
            }
        }
        NelePropertyType nelePropertyType = NelePropertyType.STRING;
        if (nelePropertyType == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(35);
        }
        return nelePropertyType;
    }

    @NotNull
    static String mapToCustomType(@NotNull NelePropertyType type) {
        if (type == null) {
            MotionLayoutPropertyProvider.$$$reportNull$$$0(36);
        }
        switch (type) {
            case COLOR: {
                return "customColorValue";
            }
            case COLOR_STATE_LIST: {
                return "customColorDrawableValue";
            }
            case INTEGER: {
                return "customIntegerValue";
            }
            case FLOAT: {
                return "customFloatValue";
            }
            case DIMENSION: {
                return "customDimension";
            }
            case DIMENSION_PIXEL: {
                return "customPixelDimension";
            }
            case BOOLEAN: {
                return "customBoolean";
            }
        }
        return "customStringValue";
    }

    private static /* synthetic */ void lambda$loadFromStyleableName$3(NelePropertiesModel model2, MotionSelection selection, String subTagName, Table properties, AttributeDefinition attr) {
        NelePropertyItem property2 = MotionLayoutPropertyProvider.createProperty(attr.getResourceReference().getNamespace().getXmlNamespaceUri(), attr.getName(), attr, model2, selection, subTagName);
        properties.put((Object)property2.getNamespace(), (Object)property2.getName(), (Object)property2);
    }

    private static /* synthetic */ void lambda$loadCustomAttributes$2(MotionSelection selection, NelePropertiesModel model2, Table customProperties, MotionAttributes.DefinedAttribute defined) {
        NelePropertyItem item = MotionLayoutPropertyProvider.createCustomProperty(defined.getName(), defined.getCustomType(), selection, model2);
        customProperties.put((Object)item.getNamespace(), (Object)item.getName(), (Object)item);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/property2/MotionLayoutPropertyProvider";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allProperties";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTagName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrDefs";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/property2/MotionLayoutPropertyProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProperties";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyTable";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "mapFromCustomType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadCustomAttributes";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStyleableName";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCustomProperty";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mapFromCustomType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "mapToCustomType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

